/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyColorUnformat;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class EditColorCommand
extends AbstractCommand {
    private final EditCurrencyUseCase editCurrencyUseCase;

    public EditColorCommand(EditCurrencyUseCase editCurrencyUseCase) {
        super("color", "", List.of("currency", "color"));
        this.editCurrencyUseCase = editCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        if (args.length < 2) {
            sender.sendMessage(ChatColor.stringValueOf(Colors.BLACK) + " BLACK");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_BLUE) + " DARK BLUE");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_GREEN) + " DARK GREEN");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_AQUA) + " DARK AQUA");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_RED) + " DARK RED");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_PURPLE) + " DARK PURPLE");
            sender.sendMessage(ChatColor.stringValueOf(Colors.GOLD) + " GOLD");
            sender.sendMessage(ChatColor.stringValueOf(Colors.GRAY) + " GRAY");
            sender.sendMessage(ChatColor.stringValueOf(Colors.DARK_GRAY) + " DARK GRAY");
            sender.sendMessage(ChatColor.stringValueOf(Colors.BLUE) + " BLUE");
            sender.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + " GREEN");
            sender.sendMessage(ChatColor.stringValueOf(Colors.AQUA) + " AQUA");
            sender.sendMessage(ChatColor.stringValueOf(Colors.RED) + " RED");
            sender.sendMessage(ChatColor.stringValueOf(Colors.LIGHT_PURPLE) + " LIGHT PURPLE");
            sender.sendMessage(ChatColor.stringValueOf(Colors.YELLOW) + " YELLOW");
            sender.sendMessage(ChatColor.stringValueOf(Colors.WHITE) + " WHITE");
            return false;
        }
        String currencyName = args[0];
        String colorString = args[1].toUpperCase();
        try {
            this.editCurrencyUseCase.editColor(currencyName, colorString);
            sender.sendMessage("Color for " + currencyName + " updated: " + colorString);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Currency not found.");
        }
        catch (CurrencyColorUnformat e) {
            sender.sendMessage("Invalid chat color.");
        }
        return true;
    }
}

