/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.mainMenus;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.result.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AccountsList;

public class AccountSelectorToEdit
extends AccountsList {
    private final IEntityGUI sender;
    private final SearchAccountUseCase searchAccountUseCase;

    public AccountSelectorToEdit(IEntityGUI sender, SearchAccountUseCase searchAccountUseCase, IGUI parent, ITextInput textInput) {
        super("Select player", 5, sender, parent, textInput);
        this.searchAccountUseCase = searchAccountUseCase;
        this.sender = sender;
        Result<List<Account>> result = searchAccountUseCase.getOfflineAccounts();
        if (result.isSuccess()) {
            ArrayList<Player> players = new ArrayList<Player>(result.getValue().stream().map(Account::getPlayer).sorted((a, b) -> a.getNickname().compareToIgnoreCase(b.getNickname())).collect(Collectors.toList()));
            this.showPlayers(players);
        } else {
            this.showPlayers(new ArrayList<Player>());
        }
    }

    @Override
    protected void addCustomButtons() {
        super.addCustomButtons();
        this.setItem(4, this.createItem(Materials.PAPER, "Select Account to edit", "Click to select an account, or search by name", "#Ordered by name, CaseSensitive"), null);
    }

    @Override
    public Player findPlayerByName(String playerName) {
        Result<Account> result = this.searchAccountUseCase.getAccount(playerName);
        if (result.isSuccess()) {
            return result.getValue().getPlayer();
        }
        return null;
    }

    @Override
    public void openNextSection(Player target) {
        GUIFactory.editAccountPanel(this.sender, target, this).open();
    }
}

