/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.result.Result;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.gui.templates.users.Offers.ListPlayerOnlineToOffer;
import lib.gui.templates.users.Offers.ListPlayersOfflineToOffer;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class BankPanel
extends AbstractPanel {
    private final IEntityGUI player;
    private final SearchAccountUseCase searchAccountUseCase;
    private final ITextInput textInput;

    public BankPanel(IEntityGUI player, SearchAccountUseCase SearchAccountUseCase2, ITextInput textInput) {
        super("Bank [" + player.getName() + "]", 4, player);
        this.player = player;
        this.searchAccountUseCase = SearchAccountUseCase2;
        this.textInput = textInput;
        this.setupGUI();
    }

    private void setupGUI() {
        Result<Account> account = this.searchAccountUseCase.getAccount(this.player.getUniqueId());
        boolean isBlocked = false;
        if (account.isSuccess()) {
            isBlocked = account.getValue().isBlocked();
        }
        this.setItem(4, isBlocked ? this.createItem(Materials.RED_CONCRETE, ChatColor.stringValueOf(Colors.RED) + "Account is blocked", "Your account is temporary blocked", "This affects:", "Withdraw", "Deposit", "Transfer", "Pay", "Trade", "Exchange", "All economy op") : this.createItem(Materials.LIME_CONCRETE, ChatColor.stringValueOf(Colors.GREEN) + "Account is enabled", "Your account is allowed to do transactions", "This affects:", "Withdraw", "Deposit", "Transfer", "Pay", "Trade", "Exchange", "All economy op"), null);
        this.setItem(11, this.createItem(Materials.DIAMOND, ChatColor.stringValueOf(Colors.GOLD) + "Exchange currencies", ChatColor.stringValueOf(Colors.WHITE) + "Click to exchange currencies"), unused -> GUIFactory.exchangeFirstPanel(this.player, this).open());
        this.setItem(24, this.createItem(Materials.WRITABLE_BOOK, ChatColor.stringValueOf(Colors.GOLD) + "Create Offer to Player online", ChatColor.stringValueOf(Colors.WHITE) + "Click to create an offer for trade currencies", ChatColor.stringValueOf(Colors.WHITE) + "with other players Online"), f -> new ListPlayerOnlineToOffer(this.player, this, this.textInput).open());
        this.setItem(25, this.createItem(Materials.WRITABLE_BOOK, ChatColor.stringValueOf(Colors.GOLD) + "Create Offer To Network Player", ChatColor.stringValueOf(Colors.WHITE) + "Click to create an offer for trade currencies", ChatColor.stringValueOf(Colors.WHITE) + "with other players from the network"), f -> new ListPlayersOfflineToOffer(this.player, this, this.searchAccountUseCase, this.textInput).open());
        this.setItem(22, this.createItem(Materials.ENDER_CHEST, ChatColor.stringValueOf(Colors.GOLD) + "My Active Offers", ChatColor.stringValueOf(Colors.WHITE) + "These are the offers you have created", ChatColor.stringValueOf(Colors.WHITE) + "and are currently active."), f -> GUIFactory.myActiveOffers(this.player, this).open());
        this.setItem(13, this.createItem(Materials.BOOK, ChatColor.stringValueOf(Colors.GOLD) + "See Balance", ChatColor.stringValueOf(Colors.WHITE) + "Click to see your balance"), unused -> GUIFactory.balancePanel(this.player, this).open());
        this.setItem(20, this.createItem(Materials.CHEST, ChatColor.stringValueOf(Colors.GOLD) + "Received Offers", ChatColor.stringValueOf(Colors.WHITE) + "Here you can view all the offers sent", ChatColor.stringValueOf(Colors.WHITE) + "to you by other players."), f -> GUIFactory.receivedOffers(this.player, this).open());
        this.setItem(15, this.createItem(Materials.PLAYER_HEAD, ChatColor.stringValueOf(Colors.GOLD) + "Pay a Player Online", ChatColor.stringValueOf(Colors.WHITE) + "Click to pay another player Online in this server"), unused -> GUIFactory.listPlayersOnline(this.player, this).open());
        this.setItem(16, this.createItem(Materials.PLAYER_HEAD, ChatColor.stringValueOf(Colors.GOLD) + "Transfer a Player from the Network", ChatColor.stringValueOf(Colors.WHITE) + "Click to Transfer founds to another", ChatColor.stringValueOf(Colors.WHITE) + "Player from the network"), f -> GUIFactory.listPlayersFromDb(this.player, this).open());
        this.setItem(31, this.createItem(Materials.BARRIER, ChatColor.stringValueOf(Colors.RED) + "Exit", ChatColor.stringValueOf(Colors.WHITE) + "Click to exit"), unused -> this.close());
    }
}

