/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.hibernate.Internal;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.UnsupportedOrmXsdVersionException;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.AbstractBinder;
import org.hibernate.boot.jaxb.internal.stax.HbmEventReader;
import org.hibernate.boot.jaxb.internal.stax.JpaOrmXmlEventReader;
import org.hibernate.boot.jaxb.internal.stax.MappingEventReader;
import org.hibernate.boot.jaxb.mapping.JaxbEntityMappings;
import org.hibernate.boot.jaxb.spi.BindableMappingDescriptor;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.xsd.MappingXsdSupport;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.config.ConfigurationException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class MappingBinder
extends AbstractBinder<BindableMappingDescriptor> {
    private static final Logger log = Logger.getLogger(MappingBinder.class);
    private final XMLEventFactory xmlEventFactory = XMLEventFactory.newInstance();
    private final Supplier<Options> optionsAccess;
    private final Supplier<UnsupportedFeatureHandling> unsupportedHandlingAccess;
    private JAXBContext hbmJaxbContext;
    private JAXBContext entityMappingsJaxbContext;
    public static final Options VALIDATING = new Options(){

        @Override
        public boolean validateMappings() {
            return true;
        }

        @Override
        public boolean transformHbmMappings() {
            return false;
        }
    };
    public static final Options NON_VALIDATING = new Options(){

        @Override
        public boolean validateMappings() {
            return true;
        }

        @Override
        public boolean transformHbmMappings() {
            return false;
        }
    };

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, Supplier<Options> optionsAccess, Supplier<UnsupportedFeatureHandling> unsupportedHandlingAccess) {
        super(resourceStreamLocator);
        this.optionsAccess = optionsAccess;
        this.unsupportedHandlingAccess = unsupportedHandlingAccess;
    }

    private MappingBinder(ResourceStreamLocator resourceStreamLocator, Options options, UnsupportedFeatureHandling unsupportedHandling) {
        this(resourceStreamLocator, () -> options, () -> unsupportedHandling);
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, final Function<String, Object> settingsAccess) {
        super(resourceStreamLocator == null ? MappingBinder.class.getClassLoader()::getResourceAsStream : resourceStreamLocator);
        if (settingsAccess == null) {
            this.optionsAccess = () -> VALIDATING;
            this.unsupportedHandlingAccess = () -> UnsupportedFeatureHandling.ERROR;
        } else {
            this.optionsAccess = () -> new Options(){

                @Override
                public boolean validateMappings() {
                    Object setting = settingsAccess.apply("hibernate.validate_xml");
                    if (setting == null) {
                        return false;
                    }
                    return StandardConverters.BOOLEAN.convert(setting);
                }

                @Override
                public boolean transformHbmMappings() {
                    Object setting = settingsAccess.apply("hibernate.transform_hbm_xml.enabled");
                    if (setting == null) {
                        return false;
                    }
                    return StandardConverters.BOOLEAN.convert(setting);
                }
            };
            this.unsupportedHandlingAccess = () -> {
                Object setting = settingsAccess.apply("hibernate.transform_hbm_xml.unsupported_feature_handling");
                return UnsupportedFeatureHandling.fromSetting(setting, UnsupportedFeatureHandling.ERROR);
            };
        }
    }

    public MappingBinder(ServiceRegistry serviceRegistry) {
        this((ResourceStreamLocator)serviceRegistry.getService(ClassLoaderService.class), (String settingName) -> {
            ConfigurationService configurationService;
            if (serviceRegistry instanceof ServiceRegistryImplementor) {
                ServiceRegistryImplementor serviceRegistryImplementor = (ServiceRegistryImplementor)serviceRegistry;
                configurationService = serviceRegistryImplementor.fromRegistryOrChildren(ConfigurationService.class);
            } else {
                configurationService = serviceRegistry.getService(ConfigurationService.class);
            }
            return configurationService == null ? null : configurationService.getSettings().get(settingName);
        });
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, UnsupportedFeatureHandling unsupportedHandling) {
        this(resourceStreamLocator, new Options(){

            @Override
            public boolean validateMappings() {
                return false;
            }

            @Override
            public boolean transformHbmMappings() {
                return false;
            }
        }, unsupportedHandling);
    }

    public MappingBinder(ResourceStreamLocator resourceStreamLocator, Options options) {
        this(resourceStreamLocator, options, UnsupportedFeatureHandling.ERROR);
    }

    @Override
    public boolean isValidationEnabled() {
        return this.optionsAccess.get().validateMappings();
    }

    @Override
    protected <X extends BindableMappingDescriptor> Binding<X> doBind(XMLEventReader staxEventReader, StartElement rootElementStartEvent, Origin origin) {
        String rootElementLocalName = rootElementStartEvent.getName().getLocalPart();
        if ("hibernate-mapping".equals(rootElementLocalName)) {
            if (log.isDebugEnabled()) {
                log.debugf("Performing JAXB binding of hbm.xml document : %s", (Object)origin.toString());
            }
            HbmEventReader hbmReader = new HbmEventReader(staxEventReader, this.xmlEventFactory);
            JaxbHbmHibernateMapping hbmBindings = (JaxbHbmHibernateMapping)this.jaxb(hbmReader, MappingXsdSupport.INSTANCE.hbmXsd().getSchema(), this.hbmJaxbContext(), origin);
            if (this.optionsAccess.get().transformHbmMappings()) {
                JaxbLogger.JAXB_LOGGER.tracef("Performing on-the-fly hbm.xml -> mapping.xml transformation - %s ", (Object)origin);
                return new Binding<JaxbEntityMappings>(HbmXmlTransformer.transform(hbmBindings, origin, this.unsupportedHandlingAccess::get), origin);
            }
            DeprecationLogger.DEPRECATION_LOGGER.logDeprecatedHbmXmlProcessing(origin.getType(), origin.getName());
            return new Binding<JaxbHbmHibernateMapping>(hbmBindings, origin);
        }
        assert ("entity-mappings".equals(rootElementLocalName));
        try {
            log.debugf("Performing JAXB binding of orm.xml document : %s", (Object)origin.toString());
            MappingEventReader reader = new MappingEventReader(staxEventReader, this.xmlEventFactory);
            JaxbEntityMappings bindingRoot = (JaxbEntityMappings)this.jaxb(reader, MappingXsdSupport.latestDescriptor().getSchema(), this.mappingJaxbContext(), origin);
            return new Binding<JaxbEntityMappings>(bindingRoot, origin);
        }
        catch (JpaOrmXmlEventReader.BadVersionException e) {
            throw new UnsupportedOrmXsdVersionException(e.getRequestedVersion(), origin);
        }
    }

    private JAXBContext hbmJaxbContext() {
        if (this.hbmJaxbContext == null) {
            try {
                this.hbmJaxbContext = JAXBContext.newInstance(JaxbHbmHibernateMapping.class);
            }
            catch (JAXBException e) {
                throw new ConfigurationException("Unable to build hbm.xml JAXBContext", e);
            }
        }
        return this.hbmJaxbContext;
    }

    @Internal
    public JAXBContext mappingJaxbContext() {
        if (this.entityMappingsJaxbContext == null) {
            try {
                this.entityMappingsJaxbContext = JAXBContext.newInstance(JaxbEntityMappings.class);
            }
            catch (JAXBException e) {
                throw new ConfigurationException("Unable to build orm.xml JAXBContext", e);
            }
        }
        return this.entityMappingsJaxbContext;
    }

    public static interface Options {
        public boolean validateMappings();

        public boolean transformHbmMappings();
    }
}

