/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.DiscriminatorColumn;
import jakarta.persistence.DiscriminatorValue;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.AnnotationException;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.EmbeddableInstantiator;
import org.hibernate.annotations.Instantiator;
import org.hibernate.annotations.TypeBinderType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.binder.TypeBinder;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.AggregateComponentBinder;
import org.hibernate.boot.model.internal.AnnotatedColumn;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AnnotatedDiscriminatorColumn;
import org.hibernate.boot.model.internal.AnnotatedJoinColumns;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.ComponentPropertyHolder;
import org.hibernate.boot.model.internal.CopyIdentifierComponentSecondPass;
import org.hibernate.boot.model.internal.EntityBinder;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.InheritanceState;
import org.hibernate.boot.model.internal.Nullability;
import org.hibernate.boot.model.internal.PropertyBinder;
import org.hibernate.boot.model.internal.PropertyContainer;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.model.internal.PropertyHolderBuilder;
import org.hibernate.boot.spi.AccessType;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.resource.beans.internal.FallbackBeanInstanceProducer;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.type.BasicType;
import org.hibernate.usertype.CompositeUserType;

public class EmbeddableBinder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EmbeddableBinder.class);

    static PropertyBinder createCompositeBinder(PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, XProperty property, AnnotatedColumns columns, XClass returnedClass, PropertyBinder propertyBinder, boolean isOverridden, Class<? extends CompositeUserType<?>> compositeUserType) {
        AnnotatedJoinColumns actualColumns;
        String propertyName;
        String referencedEntityName;
        if (isOverridden) {
            PropertyData mapsIdProperty = BinderHelper.getPropertyOverriddenByMapperOrMapsId(propertyBinder.isId(), propertyHolder, property.getName(), context);
            referencedEntityName = mapsIdProperty.getClassOrElementName();
            propertyName = mapsIdProperty.getPropertyName();
            AnnotatedJoinColumns parent = new AnnotatedJoinColumns();
            parent.setBuildingContext(context);
            parent.setPropertyHolder(propertyHolder);
            parent.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            for (AnnotatedColumn column : columns.getColumns()) {
                column.setParent(parent);
            }
            actualColumns = parent;
        } else {
            referencedEntityName = null;
            propertyName = null;
            actualColumns = null;
        }
        return EmbeddableBinder.createEmbeddedProperty(inferredData, propertyHolder, entityBinder, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, EmbeddableBinder.bindEmbeddable(inferredData, propertyHolder, entityBinder.getPropertyAccessor(property), entityBinder, isIdentifierMapper, context, isComponentEmbedded, propertyBinder.isId(), inheritanceStatePerClass, referencedEntityName, propertyName, EmbeddableBinder.determineCustomInstantiator(property, returnedClass, context), compositeUserType, actualColumns, columns));
    }

    static boolean isEmbedded(XProperty property, XClass returnedClass) {
        return property.isAnnotationPresent(Embedded.class) || property.isAnnotationPresent(EmbeddedId.class) || returnedClass.isAnnotationPresent(Embeddable.class) && !property.isAnnotationPresent(Convert.class);
    }

    public static Component bindEmbeddable(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, String referencedEntityName, String propertyName, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedJoinColumns columns, AnnotatedColumns annotatedColumns) {
        Component component;
        if (referencedEntityName != null) {
            component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
            context.getMetadataCollector().addSecondPass(new CopyIdentifierComponentSecondPass(component, referencedEntityName, propertyName, columns, context));
        } else {
            component = EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, propertyAccessor, !isId, entityBinder, isComponentEmbedded, isIdentifierMapper, context.getMetadataCollector().isInSecondPass(), customInstantiatorImpl, compositeUserTypeClass, annotatedColumns, context, inheritanceStatePerClass);
        }
        if (isId) {
            component.setKey(true);
            EmbeddableBinder.checkEmbeddedId(inferredData, propertyHolder, referencedEntityName, component);
        }
        EmbeddableBinder.callTypeBinders(component, context, inferredData.getPropertyClass());
        return component;
    }

    private static void callTypeBinders(Component component, MetadataBuildingContext context, XClass annotatedClass) {
        for (Annotation containingAnnotation : HCANNHelper.findContainingAnnotations(annotatedClass, TypeBinderType.class)) {
            TypeBinderType binderType = containingAnnotation.annotationType().getAnnotation(TypeBinderType.class);
            try {
                TypeBinder<?> binder = binderType.binder().newInstance();
                binder.bind(containingAnnotation, context, component);
            }
            catch (Exception e) {
                throw new AnnotationException("error processing @TypeBinderType annotation '" + containingAnnotation + "'", e);
            }
        }
    }

    private static PropertyBinder createEmbeddedProperty(PropertyData inferredData, PropertyHolder propertyHolder, EntityBinder entityBinder, MetadataBuildingContext context, boolean isComponentEmbedded, boolean isId, Map<XClass, InheritanceState> inheritanceStatePerClass, Component component) {
        PropertyBinder binder = new PropertyBinder();
        binder.setDeclaringClass(inferredData.getDeclaringClass());
        binder.setName(inferredData.getPropertyName());
        binder.setValue(component);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setEmbedded(isComponentEmbedded);
        binder.setHolder(propertyHolder);
        binder.setId(isId);
        binder.setEntityBinder(entityBinder);
        binder.setInheritanceStatePerClass(inheritanceStatePerClass);
        binder.setBuildingContext(context);
        binder.makePropertyAndBind();
        return binder;
    }

    private static void checkEmbeddedId(PropertyData inferredData, PropertyHolder propertyHolder, String referencedEntityName, Component component) {
        if (propertyHolder.getPersistentClass().getIdentifier() != null) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not have a property annotated '@Id' since it is used by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' as an '@EmbeddedId'");
        }
        if (referencedEntityName == null && component.getPropertySpan() == 0) {
            throw new AnnotationException("Embeddable class '" + component.getComponentClassName() + "' may not be used as an '@EmbeddedId' by '" + BinderHelper.getPath(propertyHolder, inferredData) + "' because it has no properties");
        }
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return EmbeddableBinder.fillEmbeddable(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, customInstantiatorImpl, compositeUserTypeClass, columns, context, inheritanceStatePerClass, false);
    }

    static Component fillEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, Class<? extends CompositeUserType<?>> compositeUserTypeClass, AnnotatedColumns columns, MetadataBuildingContext context, Map<XClass, InheritanceState> inheritanceStatePerClass, boolean isIdClass) {
        List<PropertyData> baseClassElements;
        XClass returnedClassOrElement;
        CompositeUserType<?> compositeUserType;
        Component component = EmbeddableBinder.createEmbeddable(propertyHolder, inferredData, isComponentEmbedded, isIdentifierMapper, customInstantiatorImpl, context);
        String subpath = BinderHelper.getPath(propertyHolder, inferredData);
        LOG.tracev("Binding component with path: {0}", (Object)subpath);
        PropertyHolder subholder = PropertyHolderBuilder.buildPropertyHolder(component, subpath, inferredData, propertyHolder, context, inheritanceStatePerClass);
        propertyHolder.startingProperty(inferredData.getProperty());
        if (compositeUserTypeClass == null) {
            compositeUserType = null;
            returnedClassOrElement = inferredData.getClassOrPluralElement();
        } else {
            compositeUserType = EmbeddableBinder.compositeUserType(compositeUserTypeClass, context);
            component.setTypeName(compositeUserTypeClass.getName());
            returnedClassOrElement = context.getBootstrapContext().getReflectionManager().toXClass(compositeUserType.embeddable());
        }
        AggregateComponentBinder.processAggregate(component, propertyHolder, inferredData, returnedClassOrElement, columns, context);
        InheritanceState inheritanceState = inheritanceStatePerClass.get(returnedClassOrElement);
        if (inheritanceState != null) {
            inheritanceState.postProcess(component);
            EmbeddableBinder.bindDiscriminator(component, returnedClassOrElement, propertyHolder, subholder, inferredData, inheritanceState, context);
        }
        XClass annotatedClass = inferredData.getPropertyClass();
        HashMap<String, String> subclassToSuperclass = component.isPolymorphic() ? new HashMap<String, String>() : null;
        List<PropertyData> classElements = EmbeddableBinder.collectClassElements(propertyAccessor, context, returnedClassOrElement, annotatedClass, isIdClass, subclassToSuperclass);
        if (component.isPolymorphic()) {
            EmbeddableBinder.validateInheritanceIsSupported(subholder, compositeUserType);
            BasicType discriminatorType = (BasicType)component.getDiscriminator().getType();
            TreeMap<Object, String> discriminatorValues = new TreeMap<Object, String>();
            EmbeddableBinder.collectDiscriminatorValue(returnedClassOrElement, discriminatorType, discriminatorValues);
            EmbeddableBinder.collectSubclassElements(propertyAccessor, context, returnedClassOrElement, classElements, discriminatorType, discriminatorValues, subclassToSuperclass);
            component.setDiscriminatorValues(discriminatorValues);
            component.setSubclassToSuperclass(subclassToSuperclass);
        }
        if ((baseClassElements = EmbeddableBinder.collectBaseClassElements(baseInferredData, propertyAccessor, context, annotatedClass)) != null && !EmbeddableBinder.hasAnnotationsOnIdClass(annotatedClass)) {
            EmbeddableBinder.processIdClassElements(propertyHolder, baseInferredData, classElements, baseClassElements);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            PropertyBinder.processElementAnnotations(subholder, entityBinder.getPersistentClass() instanceof SingleTableSubclass ? Nullability.FORCED_NULL : (isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL), propertyAnnotatedElement, new HashMap<String, IdentifierGeneratorDefinition>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, context, inheritanceStatePerClass);
            XProperty member = propertyAnnotatedElement.getProperty();
            if (isIdClass || subholder.isOrWithinEmbeddedId()) {
                Property property = EmbeddableBinder.findProperty(component, member.getName());
                if (property == null) continue;
                SimpleValue value = (SimpleValue)property.getValue();
                PropertyBinder.processId(subholder, propertyAnnotatedElement, value, Map.of(), context);
                continue;
            }
            if (!member.isAnnotationPresent(GeneratedValue.class)) continue;
            throw new AnnotationException("Property '" + member.getName() + "' of '" + BinderHelper.getPath(propertyHolder, inferredData) + "' is annotated '@GeneratedValue' but is not part of an identifier");
        }
        if (compositeUserType != null) {
            EmbeddableBinder.processCompositeUserType(component, compositeUserType);
        }
        return component;
    }

    private static Property findProperty(Component component, String name) {
        for (Property property : component.getProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    private static CompositeUserType<?> compositeUserType(Class<? extends CompositeUserType<?>> compositeUserTypeClass, MetadataBuildingContext context) {
        if (!context.getBuildingOptions().isAllowExtensionsInCdi()) {
            FallbackBeanInstanceProducer.INSTANCE.produceBeanInstance(compositeUserTypeClass);
        }
        return context.getBootstrapContext().getServiceRegistry().requireService(ManagedBeanRegistry.class).getBean(compositeUserTypeClass).getBeanInstance();
    }

    private static void bindDiscriminator(Component component, XClass componentClass, PropertyHolder parentHolder, PropertyHolder holder, PropertyData propertyData, InheritanceState inheritanceState, MetadataBuildingContext context) {
        if (inheritanceState == null) {
            return;
        }
        AnnotatedDiscriminatorColumn discriminatorColumn = EmbeddableBinder.processEmbeddableDiscriminatorProperties(componentClass, propertyData, parentHolder, holder, inheritanceState, context);
        if (discriminatorColumn != null) {
            EmbeddableBinder.bindDiscriminatorColumnToComponent(component, discriminatorColumn, holder, context);
        }
    }

    private static AnnotatedDiscriminatorColumn processEmbeddableDiscriminatorProperties(XClass annotatedClass, PropertyData propertyData, PropertyHolder parentHolder, PropertyHolder holder, InheritanceState inheritanceState, MetadataBuildingContext context) {
        DiscriminatorColumn discriminatorColumn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
        DiscriminatorFormula discriminatorFormula = BinderHelper.getOverridableAnnotation(annotatedClass, DiscriminatorFormula.class, context);
        if (!inheritanceState.hasParents()) {
            if (inheritanceState.hasSiblings()) {
                Column[] overrides;
                String columnPrefix;
                String path = StringHelper.qualify(holder.getPath(), "{discriminator}");
                if (holder.isWithinElementCollection()) {
                    columnPrefix = StringHelper.unqualify(parentHolder.getPath());
                    overrides = parentHolder.getOverriddenColumn(path);
                } else {
                    columnPrefix = propertyData.getPropertyName();
                    overrides = holder.getOverriddenColumn(path);
                }
                return AnnotatedDiscriminatorColumn.buildDiscriminatorColumn(discriminatorColumn, discriminatorFormula, overrides == null ? null : overrides[0], columnPrefix + "_DTYPE", context);
            }
        } else {
            if (discriminatorColumn != null) {
                throw new AnnotationException(String.format("Embeddable class '%s' is annotated '@DiscriminatorColumn' but it is not the root of the inheritance hierarchy", annotatedClass.getName()));
            }
            if (discriminatorFormula != null) {
                throw new AnnotationException(String.format("Embeddable class '%s' is annotated '@DiscriminatorFormula' but it is not the root of the inheritance hierarchy", annotatedClass.getName()));
            }
        }
        return null;
    }

    private static void bindDiscriminatorColumnToComponent(Component component, AnnotatedDiscriminatorColumn discriminatorColumn, PropertyHolder holder, MetadataBuildingContext context) {
        assert (component.getDiscriminator() == null);
        LOG.tracev("Setting discriminator for embeddable {0}", (Object)component.getComponentClassName());
        AnnotatedColumns columns = new AnnotatedColumns();
        columns.setPropertyHolder(holder);
        columns.setBuildingContext(context);
        discriminatorColumn.setParent(columns);
        BasicValue discriminatorColumnBinding = new BasicValue(context, component.getTable());
        discriminatorColumnBinding.setAggregateColumn(component.getAggregateColumn());
        component.setDiscriminator(discriminatorColumnBinding);
        discriminatorColumn.linkWithValue(discriminatorColumnBinding);
        discriminatorColumnBinding.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
    }

    private static void validateInheritanceIsSupported(PropertyHolder holder, CompositeUserType<?> compositeUserType) {
        if (holder.isOrWithinEmbeddedId()) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used in an '@EmbeddedId'", holder.getClassName()));
        }
        if (holder.isInIdClass()) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used in an '@IdClass'", holder.getClassName()));
        }
        if (compositeUserType != null) {
            throw new AnnotationException(String.format("Embeddable class '%s' defines an inheritance hierarchy and cannot be used with a custom '@CompositeType'", holder.getClassName()));
        }
    }

    private static List<PropertyData> collectClassElements(AccessType propertyAccessor, MetadataBuildingContext context, XClass returnedClassOrElement, XClass annotatedClass, boolean isIdClass, Map<String, String> subclassToSuperclass) {
        XClass superClass;
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        PropertyContainer container = new PropertyContainer(returnedClassOrElement, annotatedClass, propertyAccessor);
        PropertyBinder.addElementsOfClass(classElements, container, context);
        XClass subclass = returnedClassOrElement;
        while (EmbeddableBinder.isValidSuperclass(superClass = subclass.getSuperclass(), isIdClass)) {
            PropertyContainer superContainer = new PropertyContainer(superClass, annotatedClass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context);
            if (subclassToSuperclass != null) {
                subclassToSuperclass.put(subclass.getName(), superClass.getName());
            }
            subclass = superClass;
        }
        return classElements;
    }

    private static void collectSubclassElements(AccessType propertyAccessor, MetadataBuildingContext context, XClass superclass, List<PropertyData> classElements, BasicType<?> discriminatorType, Map<Object, String> discriminatorValues, Map<String, String> subclassToSuperclass) {
        for (XClass subclass : context.getMetadataCollector().getEmbeddableSubclasses(superclass)) {
            String old = EmbeddableBinder.collectDiscriminatorValue(subclass, discriminatorType, discriminatorValues);
            if (old != null) {
                throw new AnnotationException(String.format("Embeddable subclass '%s' defines the same discriminator value as '%s", subclass.getName(), old));
            }
            String put = subclassToSuperclass.put(subclass.getName().intern(), superclass.getName().intern());
            assert (put == null);
            PropertyContainer superContainer = new PropertyContainer(subclass, superclass, propertyAccessor);
            PropertyBinder.addElementsOfClass(classElements, superContainer, context);
            EmbeddableBinder.collectSubclassElements(propertyAccessor, context, subclass, classElements, discriminatorType, discriminatorValues, subclassToSuperclass);
        }
    }

    private static String collectDiscriminatorValue(XClass annotatedClass, BasicType<?> discriminatorType, Map<Object, String> discriminatorValues) {
        String discriminatorValue;
        String explicitValue;
        String string = explicitValue = annotatedClass.isAnnotationPresent(DiscriminatorValue.class) ? annotatedClass.getAnnotation(DiscriminatorValue.class).value() : null;
        if (StringHelper.isEmpty(explicitValue)) {
            String name = StringHelper.unqualify(annotatedClass.getName());
            if ("character".equals(discriminatorType.getName())) {
                throw new AnnotationException(String.format("Embeddable '%s' has a discriminator of character type and must specify its '@DiscriminatorValue'", name));
            }
            discriminatorValue = "integer".equals(discriminatorType.getName()) ? String.valueOf(name.hashCode()) : name;
        } else {
            discriminatorValue = explicitValue;
        }
        return discriminatorValues.put(discriminatorType.getJavaTypeDescriptor().fromString(discriminatorValue), annotatedClass.getName().intern());
    }

    private static boolean isValidSuperclass(XClass superClass, boolean isIdClass) {
        if (superClass == null) {
            return false;
        }
        return superClass.isAnnotationPresent(MappedSuperclass.class) || isIdClass && !superClass.getName().equals(Object.class.getName()) && !superClass.getName().equals("java.lang.Record");
    }

    private static List<PropertyData> collectBaseClassElements(PropertyData baseInferredData, AccessType propertyAccessor, MetadataBuildingContext context, XClass annotatedClass) {
        if (baseInferredData != null) {
            ArrayList<PropertyData> baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            while (!Object.class.getName().equals(baseReturnedClassOrElement.getName())) {
                PropertyContainer container = new PropertyContainer(baseReturnedClassOrElement, annotatedClass, propertyAccessor);
                PropertyBinder.addElementsOfClass(baseClassElements, container, context);
                baseReturnedClassOrElement = baseReturnedClassOrElement.getSuperclass();
            }
            return baseClassElements;
        }
        return null;
    }

    private static void processCompositeUserType(Component component, CompositeUserType<?> compositeUserType) {
        component.sortProperties();
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(component.getPropertySpan());
        ArrayList<Type> sortedPropertyTypes = new ArrayList<Type>(component.getPropertySpan());
        PropertyAccessStrategyCompositeUserTypeImpl strategy = new PropertyAccessStrategyCompositeUserTypeImpl(compositeUserType, sortedPropertyNames, sortedPropertyTypes);
        for (Property property : component.getProperties()) {
            sortedPropertyNames.add(property.getName());
            sortedPropertyTypes.add(PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(compositeUserType.embeddable(), property.getName(), false).getGetter().getReturnType());
            property.setPropertyAccessStrategy(strategy);
        }
    }

    private static boolean hasAnnotationsOnIdClass(XClass idClass) {
        for (XProperty property : idClass.getDeclaredProperties("field")) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(property)) continue;
            return true;
        }
        for (XMethod method : idClass.getDeclaredMethods()) {
            if (!EmbeddableBinder.hasTriggeringAnnotation(method)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTriggeringAnnotation(XAnnotatedElement property) {
        return property.isAnnotationPresent(Column.class) || property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToOne.class) || property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(GeneratedValue.class) || property.isAnnotationPresent(OneToOne.class) || property.isAnnotationPresent(ManyToMany.class);
    }

    private static void processIdClassElements(PropertyHolder propertyHolder, PropertyData baseInferredData, List<PropertyData> classElements, List<PropertyData> baseClassElements) {
        HashMap<String, PropertyData> baseClassElementsByName = new HashMap<String, PropertyData>();
        for (PropertyData element : baseClassElements) {
            baseClassElementsByName.put(element.getPropertyName(), element);
        }
        for (int i = 0; i < classElements.size(); ++i) {
            PropertyData idClassPropertyData = classElements.get(i);
            PropertyData entityPropertyData = (PropertyData)baseClassElementsByName.get(idClassPropertyData.getPropertyName());
            if (propertyHolder.isInIdClass()) {
                if (entityPropertyData == null) {
                    throw new AnnotationException("Property '" + BinderHelper.getPath(propertyHolder, idClassPropertyData) + "' belongs to an '@IdClass' but has no matching property in entity class '" + baseInferredData.getPropertyClass().getName() + "' (every property of the '@IdClass' must have a corresponding persistent property in the '@Entity' class)");
                }
                if (BinderHelper.hasToOneAnnotation(entityPropertyData.getProperty()) && !entityPropertyData.getClassOrElement().equals(idClassPropertyData.getClassOrElement())) continue;
            }
            classElements.set(i, entityPropertyData);
        }
    }

    static Component createEmbeddable(PropertyHolder propertyHolder, PropertyData inferredData, boolean isComponentEmbedded, boolean isIdentifierMapper, Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> customInstantiatorImpl, MetadataBuildingContext context) {
        XClass embeddableClass;
        Component component = new Component(context, propertyHolder.getPersistentClass());
        component.setEmbedded(isComponentEmbedded);
        component.setTable(propertyHolder.getTable());
        if (isIdentifierMapper || isComponentEmbedded && inferredData.getPropertyName() == null) {
            component.setComponentClassName(component.getOwner().getClassName());
            embeddableClass = inferredData.getClassOrElement();
        } else {
            embeddableClass = inferredData.getClassOrPluralElement();
            component.setComponentClassName(embeddableClass.getName());
        }
        component.setCustomInstantiator(customInstantiatorImpl);
        Constructor<?> constructor = EmbeddableBinder.resolveInstantiator(embeddableClass, context);
        if (constructor != null) {
            component.setInstantiator(constructor, constructor.getAnnotation(Instantiator.class).value());
        }
        if (propertyHolder.isComponent()) {
            ComponentPropertyHolder componentPropertyHolder = (ComponentPropertyHolder)propertyHolder;
            component.setParentAggregateColumn(componentPropertyHolder.getAggregateColumn());
        }
        return component;
    }

    private static Constructor<?> resolveInstantiator(XClass embeddableClass, MetadataBuildingContext buildingContext) {
        if (embeddableClass != null) {
            Constructor<?>[] declaredConstructors = buildingContext.getBootstrapContext().getReflectionManager().toClass(embeddableClass).getDeclaredConstructors();
            Constructor<?> constructor = null;
            for (Constructor<?> declaredConstructor : declaredConstructors) {
                if (!declaredConstructor.isAnnotationPresent(Instantiator.class)) continue;
                if (constructor != null) {
                    throw new AnnotationException("Multiple constructors of '" + embeddableClass.getName() + "' are annotated '@Instantiator' but only one constructor can be the canonical constructor");
                }
                constructor = declaredConstructor;
            }
            return constructor;
        }
        return null;
    }

    public static Class<? extends org.hibernate.metamodel.spi.EmbeddableInstantiator> determineCustomInstantiator(XProperty property, XClass returnedClass, MetadataBuildingContext context) {
        if (property.isAnnotationPresent(EmbeddedId.class)) {
            return null;
        }
        EmbeddableInstantiator propertyAnnotation = property.getAnnotation(EmbeddableInstantiator.class);
        if (propertyAnnotation != null) {
            return propertyAnnotation.value();
        }
        EmbeddableInstantiator classAnnotation = returnedClass.getAnnotation(EmbeddableInstantiator.class);
        if (classAnnotation != null) {
            return classAnnotation.value();
        }
        Class embeddableClass = context.getBootstrapContext().getReflectionManager().toClass(returnedClass);
        if (embeddableClass != null) {
            return context.getMetadataCollector().findRegisteredEmbeddableInstantiator(embeddableClass);
        }
        return null;
    }
}

