/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.AssertionFailure;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.internal.StatefulPersistenceContext;
import org.hibernate.engine.spi.CachedNaturalIdValueSource;
import org.hibernate.engine.spi.NaturalIdResolutions;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.Resolution;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.NaturalIdLogging;
import org.hibernate.metamodel.mapping.NaturalIdMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.LoadingLogger;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.jboss.logging.Logger;

public class NaturalIdResolutionsImpl
implements NaturalIdResolutions,
Serializable {
    private static final Logger LOG = Logger.getLogger(NaturalIdResolutionsImpl.class);
    private final StatefulPersistenceContext persistenceContext;
    private final ConcurrentHashMap<EntityMappingType, EntityResolutions> resolutionsByEntity = new ConcurrentHashMap();

    public NaturalIdResolutionsImpl(StatefulPersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
    }

    protected SharedSessionContractImplementor session() {
        return this.persistenceContext.getSession();
    }

    @Override
    public boolean cacheResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        this.validateNaturalId(entityDescriptor, naturalId);
        return this.cacheResolutionLocally(id, naturalId, entityDescriptor);
    }

    @Override
    public void cacheResolutionFromLoad(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        NaturalIdLogging.NATURAL_ID_LOGGER.debugf("Caching resolution natural-id resolution from load (%s) : `%s` -> `%s`", (Object)entityDescriptor.getEntityName(), naturalId, id);
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        boolean justAddedLocally = this.cacheResolution(id, naturalId, entityDescriptor);
        if (justAddedLocally && naturalIdMapping.getCacheAccess() != null) {
            this.manageSharedResolution(persister, id, naturalId, (Object)null, CachedNaturalIdValueSource.LOAD);
        }
    }

    private boolean cacheResolutionLocally(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        EntityResolutions resolutions;
        assert (entityDescriptor.getNaturalIdMapping() != null);
        assert (this.isValidValue(naturalId, entityDescriptor));
        NaturalIdLogging.NATURAL_ID_LOGGER.debugf("Locally caching natural-id resolution (%s) : `%s` -> `%s`", (Object)entityDescriptor.getEntityName(), naturalId, id);
        EntityMappingType rootEntityDescriptor = entityDescriptor.getRootEntityDescriptor();
        EntityResolutions previousEntry = this.resolutionsByEntity.get(rootEntityDescriptor);
        if (previousEntry != null) {
            resolutions = previousEntry;
        } else {
            resolutions = new EntityResolutions(rootEntityDescriptor, this.persistenceContext);
            this.resolutionsByEntity.put(rootEntityDescriptor, resolutions);
        }
        return resolutions.cache(id, naturalId);
    }

    @Override
    public Object removeResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        Resolution cachedNaturalId;
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        NaturalIdMapping naturalIdMapping = persister.getNaturalIdMapping();
        this.validateNaturalId(persister, naturalId);
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        Object sessionCachedNaturalIdValues = null;
        if (entityNaturalIdResolutionCache != null && (cachedNaturalId = entityNaturalIdResolutionCache.pkToNaturalIdMap.remove(id)) != null) {
            entityNaturalIdResolutionCache.naturalIdToPkMap.remove(cachedNaturalId);
            sessionCachedNaturalIdValues = cachedNaturalId.getNaturalIdValue();
        }
        return sessionCachedNaturalIdValues;
    }

    @Override
    public void manageLocalResolution(Object id, Object naturalIdValue, EntityMappingType entityDescriptor, CachedNaturalIdValueSource source) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        this.cacheResolutionLocally(id, naturalIdValue, entityDescriptor);
    }

    @Override
    public Object removeLocalResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        NaturalIdLogging.NATURAL_ID_LOGGER.debugf("Removing locally cached natural-id resolution (%s) : `%s` -> `%s`", (Object)entityDescriptor.getEntityName(), naturalId, id);
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return null;
        }
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        Object localNaturalIdValues = this.removeNaturalIdCrossReference(id, naturalId, persister);
        return localNaturalIdValues != null ? localNaturalIdValues : naturalId;
    }

    private Object removeNaturalIdCrossReference(Object id, Object naturalIdValue, EntityPersister persister) {
        Resolution cachedNaturalId;
        this.validateNaturalId(persister, naturalIdValue);
        EntityResolutions entityResolutions = this.resolutionsByEntity.get(persister);
        Object sessionCachedNaturalIdValues = null;
        if (entityResolutions != null && (cachedNaturalId = entityResolutions.pkToNaturalIdMap.remove(id)) != null) {
            entityResolutions.naturalIdToPkMap.remove(cachedNaturalId);
            sessionCachedNaturalIdValues = cachedNaturalId.getNaturalIdValue();
        }
        if (persister.hasNaturalIdCache()) {
            NaturalIdDataAccess naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
            Object naturalIdCacheKey = naturalIdCacheAccessStrategy.generateCacheKey(naturalIdValue, persister, this.session());
            naturalIdCacheAccessStrategy.evict(naturalIdCacheKey);
            if (sessionCachedNaturalIdValues != null && !Objects.deepEquals(sessionCachedNaturalIdValues, naturalIdValue)) {
                Object sessionNaturalIdCacheKey = naturalIdCacheAccessStrategy.generateCacheKey(sessionCachedNaturalIdValues, persister, this.session());
                naturalIdCacheAccessStrategy.evict(sessionNaturalIdCacheKey);
            }
        }
        return sessionCachedNaturalIdValues;
    }

    @Override
    public void manageSharedResolution(Object id, Object naturalId, Object previousNaturalId, EntityMappingType entityDescriptor, CachedNaturalIdValueSource source) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        if (naturalIdMapping.getCacheAccess() == null) {
            return;
        }
        this.manageSharedResolution(entityDescriptor.getEntityPersister(), id, naturalId, previousNaturalId, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void manageSharedResolution(EntityPersister persister, Object id, Object naturalIdValues, Object previousNaturalIdValues, CachedNaturalIdValueSource source) {
        NaturalIdDataAccess cacheAccess = persister.getNaturalIdMapping().getCacheAccess();
        if (cacheAccess == null) {
            return;
        }
        SharedSessionContractImplementor s = this.session();
        EntityMappingType rootEntityDescriptor = persister.getRootEntityDescriptor();
        EntityPersister rootEntityPersister = rootEntityDescriptor.getEntityPersister();
        Object cacheKey = cacheAccess.generateCacheKey(naturalIdValues, rootEntityPersister, s);
        SessionFactoryImplementor factory = s.getFactory();
        StatisticsImplementor statistics = factory.getStatistics();
        EventManager eventManager = s.getEventManager();
        switch (source) {
            case LOAD: {
                if (CacheHelper.fromSharedCache(s, cacheKey, persister, (CachedDomainDataAccess)cacheAccess) != null) {
                    return;
                }
                boolean put = false;
                HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
                try {
                    put = cacheAccess.putFromLoad(s, cacheKey, id, null);
                    if (!put || !statistics.isStatisticsEnabled()) break;
                    statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    break;
                }
                finally {
                    eventManager.completeCachePutEvent(cachePutEvent, this.session(), cacheAccess, rootEntityPersister, put, true, EventManager.CacheActionDescription.ENTITY_LOAD);
                }
            }
            case INSERT: {
                boolean put = false;
                HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
                try {
                    put = cacheAccess.insert(s, cacheKey, id);
                    if (put && statistics.isStatisticsEnabled()) {
                        statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventManager.completeCachePutEvent(cachePutEvent, this.session(), cacheAccess, rootEntityPersister, put, true, EventManager.CacheActionDescription.ENTITY_INSERT);
                }
                s.asEventSource().getActionQueue().registerProcess((success, session) -> {
                    if (success) {
                        boolean put1 = cacheAccess.afterInsert(session, cacheKey, id);
                        if (put1 && statistics.isStatisticsEnabled()) {
                            statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                        }
                    } else {
                        cacheAccess.evict(cacheKey);
                    }
                });
                break;
            }
            case UPDATE: {
                Object previousCacheKey = cacheAccess.generateCacheKey(previousNaturalIdValues, rootEntityPersister, s);
                if (cacheKey.equals(previousCacheKey)) {
                    return;
                }
                SoftLock removalLock = cacheAccess.lockItem(s, previousCacheKey, null);
                cacheAccess.remove(s, previousCacheKey);
                SoftLock lock = cacheAccess.lockItem(s, cacheKey, null);
                boolean put = false;
                HibernateMonitoringEvent cachePutEvent = eventManager.beginCachePutEvent();
                try {
                    put = cacheAccess.update(s, cacheKey, id);
                    if (put && statistics.isStatisticsEnabled()) {
                        statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                    }
                }
                finally {
                    eventManager.completeCachePutEvent(cachePutEvent, this.session(), cacheAccess, rootEntityPersister, put, true, EventManager.CacheActionDescription.ENTITY_UPDATE);
                }
                s.asEventSource().getActionQueue().registerProcess((success, session) -> {
                    cacheAccess.unlockItem(s, previousCacheKey, removalLock);
                    if (success) {
                        boolean putAfterUpdate = false;
                        HibernateMonitoringEvent cachePutEventAfterUpdate = eventManager.beginCachePutEvent();
                        try {
                            putAfterUpdate = cacheAccess.afterUpdate(s, cacheKey, id, lock);
                            if (!putAfterUpdate || !statistics.isStatisticsEnabled()) return;
                            statistics.naturalIdCachePut(rootEntityDescriptor.getNavigableRole(), cacheAccess.getRegion().getName());
                            return;
                        }
                        finally {
                            eventManager.completeCachePutEvent(cachePutEventAfterUpdate, this.session(), cacheAccess, rootEntityPersister, putAfterUpdate, true, EventManager.CacheActionDescription.ENTITY_AFTER_UPDATE);
                        }
                    } else {
                        cacheAccess.unlockItem(s, cacheKey, lock);
                    }
                });
                break;
            }
            default: {
                if (!LOG.isDebugEnabled()) break;
                LOG.debug("Unexpected CachedNaturalIdValueSource [" + source + "]");
            }
        }
    }

    @Override
    public void removeSharedResolution(Object id, Object naturalId, EntityMappingType entityDescriptor) {
        this.removeSharedResolution(id, naturalId, entityDescriptor, false);
    }

    @Override
    public void removeSharedResolution(Object id, Object naturalId, EntityMappingType entityDescriptor, boolean delayToAfterTransactionCompletion) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        NaturalIdDataAccess cacheAccess = naturalIdMapping.getCacheAccess();
        if (cacheAccess == null) {
            return;
        }
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        Object naturalIdCacheKey = cacheAccess.generateCacheKey(naturalId, persister, this.session());
        if (delayToAfterTransactionCompletion) {
            this.session().asEventSource().getActionQueue().registerProcess((success, session) -> {
                if (success) {
                    cacheAccess.evict(naturalIdCacheKey);
                }
            });
        } else {
            cacheAccess.evict(naturalIdCacheKey);
        }
    }

    @Override
    public void handleSynchronization(Object pk, Object entity, EntityMappingType entityDescriptor) {
        Object naturalIdValuesFromCurrentObjectState;
        boolean changed;
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            return;
        }
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        boolean bl = changed = !this.sameAsCached(persister, pk, naturalIdValuesFromCurrentObjectState = naturalIdMapping.extractNaturalIdFromEntity(entity));
        if (changed) {
            Object cachedNaturalIdValues = this.findCachedNaturalIdById(pk, persister);
            this.cacheResolution(pk, naturalIdValuesFromCurrentObjectState, persister);
            this.stashInvalidNaturalIdReference(persister, cachedNaturalIdValues);
            this.removeSharedResolution(pk, cachedNaturalIdValues, persister, false);
        }
    }

    @Override
    public void cleanupFromSynchronizations() {
        this.unStashInvalidNaturalIdReferences();
    }

    @Override
    public void handleEviction(Object id, Object object, EntityMappingType entityDescriptor) {
        this.removeResolution(id, this.findCachedNaturalIdById(id, entityDescriptor), entityDescriptor);
    }

    public boolean sameAsCached(EntityPersister persister, Object pk, Object naturalIdValues) {
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        return entityNaturalIdResolutionCache != null && entityNaturalIdResolutionCache.sameAsCached(pk, naturalIdValues);
    }

    protected EntityPersister locatePersisterForKey(EntityPersister persister) {
        return persister.getRootEntityDescriptor().getEntityPersister();
    }

    protected void validateNaturalId(EntityMappingType entityDescriptor, Object naturalIdValues) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            throw new IllegalArgumentException("Entity did not define a natural-id");
        }
        naturalIdMapping.validateInternalForm(naturalIdValues);
    }

    private boolean isValidValue(Object naturalIdValues, EntityMappingType entityDescriptor) {
        NaturalIdMapping naturalIdMapping = entityDescriptor.getNaturalIdMapping();
        if (naturalIdMapping == null) {
            throw new IllegalArgumentException("Entity did not define a natural-id");
        }
        naturalIdMapping.validateInternalForm(naturalIdValues);
        return true;
    }

    @Override
    public Object findCachedNaturalIdById(Object id, EntityMappingType entityDescriptor) {
        EntityPersister persister;
        EntityResolutions entityNaturalIdResolutionCache;
        if (LoadingLogger.TRACE_ENABLED) {
            LoadingLogger.LOGGER.tracef("Starting NaturalIdResolutionsImpl.#findCachedNaturalIdById( `%s`, `%s` )", (Object)entityDescriptor.getEntityName(), id);
        }
        if ((entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister()))) == null) {
            return null;
        }
        Resolution cachedNaturalId = entityNaturalIdResolutionCache.pkToNaturalIdMap.get(id);
        if (cachedNaturalId == null) {
            return null;
        }
        return cachedNaturalId.getNaturalIdValue();
    }

    @Override
    public Object findCachedIdByNaturalId(Object naturalId, EntityMappingType entityDescriptor) {
        Object pk;
        if (LoadingLogger.TRACE_ENABLED) {
            LoadingLogger.LOGGER.tracef("Starting NaturalIdResolutionsImpl.#findCachedIdByNaturalId( `%s`, `%s` )", (Object)entityDescriptor.getEntityName(), naturalId);
        }
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        this.validateNaturalId(persister, naturalId);
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        ResolutionImpl cachedNaturalId = new ResolutionImpl(persister, naturalId, this.persistenceContext);
        if (entityNaturalIdResolutionCache != null) {
            pk = entityNaturalIdResolutionCache.naturalIdToPkMap.get(cachedNaturalId);
            if (pk != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.tracef("Resolved natural key (%s) -> primary key (%s) resolution in session cache for `%s`:", naturalId, pk, (Object)entityDescriptor.getEntityName());
                }
                return pk;
            }
            if (entityNaturalIdResolutionCache.containsInvalidNaturalIdReference(naturalId)) {
                return NaturalIdResolutions.INVALID_NATURAL_ID_REFERENCE;
            }
        }
        if (!persister.hasNaturalIdCache()) {
            return null;
        }
        NaturalIdDataAccess naturalIdCacheAccessStrategy = persister.getNaturalIdCacheAccessStrategy();
        SharedSessionContractImplementor session = this.session();
        Object naturalIdCacheKey = naturalIdCacheAccessStrategy.generateCacheKey(naturalId, persister, session);
        pk = CacheHelper.fromSharedCache(session, naturalIdCacheKey, persister, true, naturalIdCacheAccessStrategy);
        SessionFactoryImplementor factory = session.getFactory();
        StatisticsImplementor statistics = factory.getStatistics();
        boolean statisticsEnabled = statistics.isStatisticsEnabled();
        if (pk != null) {
            EntityResolutions existingCache;
            if (statisticsEnabled) {
                statistics.naturalIdCacheHit(StatsHelper.INSTANCE.getRootEntityRole(persister), naturalIdCacheAccessStrategy.getRegion().getName());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracef("Found natural key [%s] -> primary key [%s] xref in second-level cache for %s", naturalId, pk, (Object)persister.getRootEntityName());
            }
            if (entityNaturalIdResolutionCache == null && (existingCache = this.resolutionsByEntity.putIfAbsent(persister, entityNaturalIdResolutionCache = new EntityResolutions(persister, this.persistenceContext))) != null) {
                entityNaturalIdResolutionCache = existingCache;
            }
            entityNaturalIdResolutionCache.pkToNaturalIdMap.put(pk, cachedNaturalId);
            entityNaturalIdResolutionCache.naturalIdToPkMap.put(cachedNaturalId, pk);
        } else if (statisticsEnabled) {
            statistics.naturalIdCacheMiss(StatsHelper.INSTANCE.getRootEntityRole(persister), naturalIdCacheAccessStrategy.getRegion().getName());
        }
        return pk;
    }

    @Override
    public Collection<?> getCachedPkResolutions(EntityMappingType entityDescriptor) {
        EntityPersister persister = this.locatePersisterForKey(entityDescriptor.getEntityPersister());
        Set<Object> pks = null;
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister);
        if (entityNaturalIdResolutionCache != null) {
            pks = entityNaturalIdResolutionCache.pkToNaturalIdMap.keySet();
        }
        if (pks == null || pks.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(pks);
    }

    public void stashInvalidNaturalIdReference(EntityPersister persister, Object invalidNaturalIdValues) {
        EntityResolutions entityNaturalIdResolutionCache = this.resolutionsByEntity.get(persister = this.locatePersisterForKey(persister));
        if (entityNaturalIdResolutionCache == null) {
            throw new AssertionFailure("Expecting NaturalIdResolutionCache to exist already for entity " + persister.getEntityName());
        }
        entityNaturalIdResolutionCache.stashInvalidNaturalIdReference(invalidNaturalIdValues);
    }

    public void unStashInvalidNaturalIdReferences() {
        for (EntityResolutions naturalIdResolutionCache : this.resolutionsByEntity.values()) {
            naturalIdResolutionCache.unStashInvalidNaturalIdReferences();
        }
    }

    public void clear() {
        this.resolutionsByEntity.clear();
    }

    private static class ResolutionImpl
    implements Resolution,
    Serializable {
        private final PersistenceContext persistenceContext;
        private final EntityMappingType entityDescriptor;
        private final Object naturalIdValue;
        private final int hashCode;

        public ResolutionImpl(EntityMappingType entityDescriptor, Object naturalIdValue, PersistenceContext persistenceContext) {
            this.entityDescriptor = entityDescriptor;
            this.naturalIdValue = naturalIdValue;
            this.persistenceContext = persistenceContext;
            int prime = 31;
            int hashCodeCalculation = 1;
            hashCodeCalculation = 31 * hashCodeCalculation + entityDescriptor.hashCode();
            this.hashCode = hashCodeCalculation = 31 * hashCodeCalculation + entityDescriptor.getNaturalIdMapping().calculateHashCode(naturalIdValue);
        }

        @Override
        public Object getNaturalIdValue() {
            return this.naturalIdValue;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResolutionImpl other = (ResolutionImpl)obj;
            return this.entityDescriptor.equals(other.entityDescriptor) && this.isSame(other.naturalIdValue);
        }

        @Override
        public boolean isSame(Object otherValue) {
            return this.entityDescriptor.getNaturalIdMapping().areEqual(this.naturalIdValue, otherValue, this.persistenceContext.getSession());
        }
    }

    private static class EntityResolutions
    implements Serializable {
        private final PersistenceContext persistenceContext;
        private final EntityMappingType entityDescriptor;
        private final Map<Object, Resolution> pkToNaturalIdMap = new ConcurrentHashMap<Object, Resolution>();
        private final Map<Resolution, Object> naturalIdToPkMap = new ConcurrentHashMap<Resolution, Object>();
        private List<Resolution> invalidNaturalIdList;

        private EntityResolutions(EntityMappingType entityDescriptor, PersistenceContext persistenceContext) {
            this.entityDescriptor = entityDescriptor;
            this.persistenceContext = persistenceContext;
        }

        public EntityMappingType getEntityDescriptor() {
            return this.entityDescriptor;
        }

        public EntityPersister getPersister() {
            return this.getEntityDescriptor().getEntityPersister();
        }

        public boolean sameAsCached(Object pk, Object naturalIdValues) {
            if (pk == null) {
                return false;
            }
            Resolution initial = this.pkToNaturalIdMap.get(pk);
            return initial != null && initial.isSame(naturalIdValues);
        }

        public boolean cache(Object pk, Object naturalIdValues) {
            if (pk == null) {
                return false;
            }
            Resolution initial = this.pkToNaturalIdMap.get(pk);
            if (initial != null) {
                if (initial.isSame(naturalIdValues)) {
                    return false;
                }
                this.naturalIdToPkMap.remove(initial);
            }
            ResolutionImpl cachedNaturalId = new ResolutionImpl(this.getEntityDescriptor(), naturalIdValues, this.persistenceContext);
            this.pkToNaturalIdMap.put(pk, cachedNaturalId);
            this.naturalIdToPkMap.put(cachedNaturalId, pk);
            return true;
        }

        public void stashInvalidNaturalIdReference(Object invalidNaturalIdValues) {
            if (this.invalidNaturalIdList == null) {
                this.invalidNaturalIdList = new ArrayList<Resolution>();
            }
            this.invalidNaturalIdList.add(new ResolutionImpl(this.getEntityDescriptor(), invalidNaturalIdValues, this.persistenceContext));
        }

        public boolean containsInvalidNaturalIdReference(Object naturalIdValues) {
            return this.invalidNaturalIdList != null && this.invalidNaturalIdList.contains(new ResolutionImpl(this.getEntityDescriptor(), naturalIdValues, this.persistenceContext));
        }

        public void unStashInvalidNaturalIdReferences() {
            if (this.invalidNaturalIdList != null) {
                this.invalidNaturalIdList.clear();
            }
        }
    }
}

