/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.graph.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.graph.CannotContainSubGraphException;
import org.hibernate.graph.SubGraph;
import org.hibernate.graph.internal.AbstractGraphNode;
import org.hibernate.graph.spi.AttributeNodeImplementor;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.internal.DomainModelHelper;
import org.jboss.logging.Logger;

public class AttributeNodeImpl<J>
extends AbstractGraphNode<J>
implements AttributeNodeImplementor<J> {
    private final PersistentAttribute<?, J> attribute;
    private Map<Class<? extends J>, SubGraphImplementor<? extends J>> subGraphMap;
    private Map<Class<? extends J>, SubGraphImplementor<? extends J>> keySubGraphMap;
    private static final Logger log = Logger.getLogger(AttributeNodeImpl.class);

    public <X> AttributeNodeImpl(PersistentAttribute<X, J> attribute, boolean mutable) {
        this(attribute, null, null, mutable);
    }

    private AttributeNodeImpl(PersistentAttribute<?, J> attribute, Map<Class<? extends J>, SubGraphImplementor<? extends J>> subGraphMap, Map<Class<? extends J>, SubGraphImplementor<? extends J>> keySubGraphMap, boolean mutable) {
        super(mutable);
        this.attribute = attribute;
        this.subGraphMap = subGraphMap;
        this.keySubGraphMap = keySubGraphMap;
    }

    @Override
    public String getAttributeName() {
        return this.getAttributeDescriptor().getName();
    }

    @Override
    public PersistentAttribute<?, J> getAttributeDescriptor() {
        return this.attribute;
    }

    @Override
    public Map<Class<? extends J>, SubGraphImplementor<? extends J>> getSubGraphMap() {
        return this.subGraphMap == null ? Collections.emptyMap() : this.subGraphMap;
    }

    @Override
    public Map<Class<? extends J>, SubGraphImplementor<? extends J>> getKeySubGraphMap() {
        return this.keySubGraphMap == null ? Collections.emptyMap() : this.keySubGraphMap;
    }

    @Override
    public SubGraphImplementor<J> makeSubGraph() {
        return this.internalMakeSubgraph((Class)null);
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subtype) {
        return this.internalMakeSubgraph(subtype);
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(ManagedDomainType<S> subtype) {
        return this.internalMakeSubgraph(subtype);
    }

    private <S extends J> SubGraphImplementor<S> internalMakeSubgraph(ManagedDomainType<S> type) {
        assert (type != null);
        log.debugf("Making sub-graph : ( (%s) %s )", (Object)type.getTypeName(), (Object)this.getAttributeName());
        SubGraphImplementor subGraph = DomainModelHelper.makeSubGraph(type, type.getBindableJavaType());
        this.internalAddSubGraph(subGraph);
        return subGraph;
    }

    private <T extends J> ManagedDomainType<T> valueGraphTypeAsManaged() {
        DomainType<?> valueGraphType = this.getAttributeDescriptor().getValueGraphType();
        if (valueGraphType instanceof ManagedDomainType) {
            return (ManagedDomainType)valueGraphType;
        }
        throw new CannotContainSubGraphException(String.format(Locale.ROOT, "Attribute [%s] (%s) cannot contain value sub-graphs", this.getAttributeName(), this.getAttributeDescriptor().getPersistentAttributeType().name()));
    }

    private <S extends J> SubGraphImplementor<S> internalMakeSubgraph(Class<S> subType) {
        this.verifyMutability();
        ManagedDomainType managedType = this.valueGraphTypeAsManaged();
        return this.internalMakeSubgraph(DomainModelHelper.findSubType(managedType, subType == null ? managedType.getJavaType() : subType));
    }

    protected void internalAddSubGraph(SubGraphImplementor<? extends J> subGraph) {
        SubGraphImplementor<? extends J> previous;
        log.tracef("Adding sub-graph : ( (%s) %s )", (Object)subGraph.getGraphedType().getTypeName(), (Object)this.getAttributeName());
        if (this.subGraphMap == null) {
            this.subGraphMap = new HashMap<Class<? extends J>, SubGraphImplementor<? extends J>>();
        }
        if ((previous = this.subGraphMap.put(subGraph.getClassType(), subGraph)) != null) {
            log.debugf("Adding sub-graph [%s] over-wrote existing [%s]", (Object)subGraph, (Object)previous);
        }
    }

    @Override
    public <S extends J> void addSubGraph(Class<S> subType, SubGraph<S> subGraph) {
        this.verifyMutability();
        assert (subGraph.getClassType() == subType);
        this.internalAddSubGraph((SubGraphImplementor)subGraph);
    }

    @Override
    public void addSubGraph(SubGraphImplementor<? extends J> subGraph) {
        this.internalAddSubGraph(subGraph);
    }

    @Override
    public SubGraphImplementor<J> makeKeySubGraph() {
        return this.internalMakeKeySubgraph((Class)null);
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeKeySubGraph(Class<S> subtype) {
        return this.internalMakeKeySubgraph(subtype);
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeKeySubGraph(ManagedDomainType<S> subtype) {
        return this.internalMakeKeySubgraph(subtype);
    }

    private <S extends J> SubGraphImplementor<S> internalMakeKeySubgraph(ManagedDomainType<S> type) {
        assert (type != null);
        log.debugf("Making key sub-graph : ( (%s) %s )", (Object)type.getTypeName(), (Object)this.getAttributeName());
        SubGraphImplementor subGraph = DomainModelHelper.makeSubGraph(type, type.getBindableJavaType());
        this.internalAddKeySubGraph(subGraph);
        return subGraph;
    }

    private <S extends J> SubGraphImplementor<S> internalMakeKeySubgraph(Class<S> type) {
        this.verifyMutability();
        ManagedDomainType managedType = this.keyGraphTypeAsManaged();
        return this.internalMakeKeySubgraph(type == null ? managedType : DomainModelHelper.findSubType(managedType, type));
    }

    protected void internalAddKeySubGraph(SubGraph<? extends J> subGraph) {
        SubGraphImplementor previous;
        log.tracef("Adding key sub-graph : ( (%s) %s )", (Object)subGraph.getClassType().getName(), (Object)this.getAttributeName());
        if (this.keySubGraphMap == null) {
            this.keySubGraphMap = new HashMap<Class<? extends J>, SubGraphImplementor<? extends J>>();
        }
        if ((previous = this.keySubGraphMap.put(subGraph.getClassType(), (SubGraphImplementor)subGraph)) != null) {
            log.debugf("Adding key sub-graph [%s] over-wrote existing [%]", (Object)subGraph, (Object)previous);
        }
    }

    private <T extends J> ManagedDomainType<T> keyGraphTypeAsManaged() {
        SimpleDomainType<?> keyGraphType = this.getAttributeDescriptor().getKeyGraphType();
        if (keyGraphType instanceof ManagedDomainType) {
            return (ManagedDomainType)((Object)keyGraphType);
        }
        throw new CannotContainSubGraphException(String.format(Locale.ROOT, "Attribute [%s#%s] (%s) cannot contain key sub-graphs - %s", this.getAttributeDescriptor().getDeclaringType().getTypeName(), this.getAttributeName(), this.getAttributeDescriptor().getPersistentAttributeType().name(), keyGraphType));
    }

    @Override
    public <S extends J> void addKeySubGraph(Class<S> subType, SubGraph<S> subGraph) {
        assert (subGraph.getClassType() == subType);
        this.internalAddKeySubGraph(subGraph);
    }

    @Override
    public AttributeNodeImplementor<J> makeCopy(boolean mutable) {
        return new AttributeNodeImpl<J>(this.attribute, this.makeMapCopy(mutable, this.subGraphMap), this.makeMapCopy(mutable, this.keySubGraphMap), mutable);
    }

    private Map<Class<? extends J>, SubGraphImplementor<? extends J>> makeMapCopy(boolean mutable, Map<Class<? extends J>, SubGraphImplementor<? extends J>> nodeMap) {
        if (nodeMap == null) {
            return null;
        }
        return nodeMap.entrySet().stream().map(entry -> Map.entry((Class)entry.getKey(), ((SubGraphImplementor)entry.getValue()).makeCopy(mutable))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void merge(AttributeNodeImplementor<?> attributeNode) {
        attributeNode.visitSubGraphs((incomingSubType, incomingGraph) -> {
            SubGraphImplementor<J> existing;
            if (this.subGraphMap == null) {
                this.subGraphMap = new HashMap<Class<? extends J>, SubGraphImplementor<? extends J>>();
                existing = null;
            } else {
                existing = this.subGraphMap.get(incomingSubType);
            }
            if (existing != null) {
                existing.merge((GraphImplementor<J>)incomingGraph);
            } else {
                this.internalAddSubGraph((SubGraphImplementor<? extends J>)incomingGraph.makeCopy(true));
            }
        });
        attributeNode.visitKeySubGraphs((incomingSubType, incomingGraph) -> {
            SubGraphImplementor<J> existing;
            if (this.keySubGraphMap == null) {
                this.keySubGraphMap = new HashMap<Class<? extends J>, SubGraphImplementor<? extends J>>();
                existing = null;
            } else {
                existing = this.keySubGraphMap.get(incomingSubType);
            }
            if (existing != null) {
                existing.merge((GraphImplementor<J>)incomingGraph);
            } else {
                this.internalAddKeySubGraph((SubGraph<? extends J>)incomingGraph.makeCopy(true));
            }
        });
    }
}

