/*
 * Decompiled with CFR 0.152.
 */
package proxy;

import BlockDynasty.Economy.domain.services.courier.Courier;
import Main.Console;
import com.BlockDynasty.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import lib.abstractions.IPlayer;
import lib.abstractions.PlatformAdapter;
import proxy.ProxyData;

public class ProxySender
implements Courier {
    private final PlatformAdapter platformAdapter;
    private final Gson gson = new Gson();

    public ProxySender(PlatformAdapter platformAdapter) {
        this.platformAdapter = platformAdapter;
    }

    @Override
    public void sendUpdateMessage(String type, String target) {
        this.sendUpdateMessage(type, null, target);
    }

    @Override
    public void sendUpdateMessage(String type, String data, String target) {
        if (this.shouldSkipProcessing(type, target)) {
            return;
        }
        try {
            this.platformAdapter.sendPluginMessage(ProxyData.getChannelName(), this.createMessage(type, data, target));
        }
        catch (IOException e) {
            Console.logError(e.getMessage());
        }
    }

    private boolean shouldSkipProcessing(String type, String target) {
        switch (type) {
            case "account": 
            case "event": {
                IPlayer player = this.platformAdapter.getPlayerByUUID(UUID.fromString(target));
                return player != null && player.isOnline();
            }
        }
        return false;
    }

    private byte[] createMessage(String type, String data, String target) throws IOException {
        HashMap<String, String> messageData = new HashMap<String, String>();
        messageData.put("type", type);
        messageData.put("target", target);
        if (data != null) {
            messageData.put("data", data);
        }
        String jsonMessage = this.gson.toJson(messageData);
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(outBytes);){
            out.writeUTF(jsonMessage);
        }
        return outBytes.toByteArray();
    }
}

