/*
 * Decompiled with CFR 0.152.
 */
package redis;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import BlockDynasty.Economy.domain.services.IOfferService;
import Main.Console;
import com.BlockDynasty.gson.Gson;
import com.BlockDynasty.gson.reflect.TypeToken;
import com.BlockDynasty.redis.clients.jedis.DefaultJedisClientConfig;
import com.BlockDynasty.redis.clients.jedis.HostAndPort;
import com.BlockDynasty.redis.clients.jedis.JedisClientConfig;
import com.BlockDynasty.redis.clients.jedis.JedisPubSub;
import com.BlockDynasty.redis.clients.jedis.UnifiedJedis;
import java.util.Map;
import java.util.UUID;
import lib.abstractions.IPlayer;
import lib.abstractions.PlatformAdapter;
import lib.scheduler.ContextualTask;
import redis.RedisData;

public class Subscriber {
    private final Gson gson = new Gson();
    private final PlatformAdapter platformAdapter;
    private final IOfferService offerService;
    private final EventManager eventManager;
    private final ICurrencyService currencyService;
    private final IAccountService accountService;
    private final HostAndPort hostAndPort;
    private final JedisClientConfig config;
    private Thread listenerThread;
    private boolean running = false;
    private final String channelName;
    private final String INSTANCE_ID;

    public Subscriber(RedisData redisData, PlatformAdapter platformAdapter, IOfferService offerService, ICurrencyService currencyService, IAccountService accountService, EventManager eventManager) {
        this.platformAdapter = platformAdapter;
        this.offerService = offerService;
        this.eventManager = eventManager;
        this.currencyService = currencyService;
        this.accountService = accountService;
        this.hostAndPort = new HostAndPort(redisData.getHost(), redisData.getPort());
        this.config = DefaultJedisClientConfig.builder().user(redisData.getUsername()).password(redisData.getPassword()).build();
        this.channelName = redisData.getChannelName();
        this.INSTANCE_ID = redisData.getInstanceID();
    }

    public void startListening() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.listenerThread = new Thread(() -> {
            try {
                UnifiedJedis jedis = new UnifiedJedis(this.hostAndPort, this.config);
                jedis.subscribe(new JedisPubSub(){

                    @Override
                    public void onMessage(String channel, String message) {
                        if (!channel.equals(Subscriber.this.channelName)) {
                            return;
                        }
                        try {
                            Map messageData = (Map)Subscriber.this.gson.fromJson(message, new TypeToken<Map<String, String>>(){}.getType());
                            if (((String)messageData.get("instanceId")).equals(Subscriber.this.INSTANCE_ID)) {
                                return;
                            }
                            String type = (String)messageData.get("type");
                            String target = (String)messageData.get("target");
                            UUID uuid = UUID.fromString(target);
                            if (type.equals("event")) {
                                String eventJson = (String)messageData.get("data");
                                Subscriber.this.offerService.processNetworkEvent(eventJson);
                                if (Subscriber.this.shouldSkipProcessing(target)) {
                                    return;
                                }
                                Subscriber.this.platformAdapter.getScheduler().runAsync(ContextualTask.build(() -> Subscriber.this.accountService.syncOnlineAccount(uuid)));
                                Subscriber.this.eventManager.processNetworkEvent(eventJson);
                                return;
                            }
                            if (type.equals("account")) {
                                if (Subscriber.this.shouldSkipProcessing(target)) {
                                    return;
                                }
                                Subscriber.this.platformAdapter.getScheduler().runAsync(ContextualTask.build(() -> Subscriber.this.accountService.syncOnlineAccount(uuid)));
                                return;
                            }
                            if (type.equals("currency")) {
                                Subscriber.this.currencyService.syncCurrency(uuid);
                            }
                        }
                        catch (Exception e) {
                            Console.logError("Redis message processing error: " + e.getMessage());
                        }
                    }
                }, this.channelName);
            }
            catch (Exception e) {
                Console.logError("Redis subscription error: " + e.getMessage());
                this.running = false;
            }
        });
        this.listenerThread.setDaemon(true);
        this.listenerThread.start();
    }

    public void stopListening() {
        this.running = false;
        if (this.listenerThread != null) {
            this.listenerThread.interrupt();
        }
    }

    private boolean shouldSkipProcessing(String target) {
        IPlayer player = this.platformAdapter.getPlayerByUUID(UUID.fromString(target));
        return player == null || !player.isOnline();
    }
}

