/*
 * Decompiled with CFR 0.152.
 */
package repository;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.transaction.ITransactions;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.result.TransferResult;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import java.math.BigDecimal;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import repository.Mappers.AccountMapper;
import repository.Models.AccountDb;
import repository.Models.BalanceDb;
import repository.Models.CurrencyDb;
import repository.Models.WalletDb;

public class TransactionRepository
implements ITransactions {
    private final SessionFactory sessionFactory;

    public TransactionRepository(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public Result<TransferResult> transfer(String fromUuid, String toUuid, Currency currency, BigDecimal amount) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb toDb;
            AccountDb fromDb;
            Transaction tx;
            block14: {
                Result<TransferResult> result;
                tx = session.beginTransaction();
                try {
                    fromDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)fromUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    toDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)toUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (fromDb != null && toDb != null) break block14;
                    tx.rollback();
                    Result<TransferResult> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error en la transferencia: " + e.getMessage(), ErrorCode.UNKNOWN_ERROR);
                    return result;
                }
            }
            Account from = AccountMapper.toDomain(fromDb);
            Account to = AccountMapper.toDomain(toDb);
            Result<Void> result = from.subtract(currency, amount);
            if (!result.isSuccess()) {
                tx.rollback();
                Result<TransferResult> result3 = Result.failure(result.getErrorMessage(), result.getErrorCode());
                return result3;
            }
            to.add(currency, amount);
            this.updateBalancesInDb(from, fromDb, session);
            this.updateBalancesInDb(to, toDb, session);
            tx.commit();
            Result<TransferResult> result4 = Result.success(new TransferResult(from, to));
            return result4;
        }
    }

    private void updateBalancesInDb(Account account, AccountDb accountDb, Session session) {
        WalletDb walletDb = accountDb.getWallet();
        for (Money money : account.getBalances()) {
            CurrencyDb currencyDb;
            String currencyUuid = money.getCurrency().getUuid().toString();
            Optional<BalanceDb> existingBalance = walletDb.getBalances().stream().filter(b -> b.getCurrency().getUuid().equals(currencyUuid)).findFirst();
            if (existingBalance.isPresent()) {
                existingBalance.get().setAmount(money.getAmount());
                continue;
            }
            try {
                currencyDb = (CurrencyDb)session.createQuery("FROM CurrencyDb WHERE uuid = :uuid", CurrencyDb.class).setParameter("uuid", (Object)currencyUuid).getSingleResult();
            }
            catch (NoResultException e) {
                throw new CurrencyNotFoundException("Currency not found: " + currencyUuid);
            }
            BalanceDb newBalance = new BalanceDb();
            newBalance.setCurrency(currencyDb);
            newBalance.setAmount(money.getAmount());
            newBalance.setWallet(walletDb);
            walletDb.getBalances().add(newBalance);
        }
    }

    @Override
    public Result<Account> withdraw(String accountUuid, Currency currency, BigDecimal amount) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb accountDb;
            Transaction tx;
            block14: {
                Result<Account> result;
                tx = session.beginTransaction();
                try {
                    accountDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)accountUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (accountDb != null) break block14;
                    tx.rollback();
                    Result<Account> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error en el retiro: " + e.getMessage(), ErrorCode.UNKNOWN_ERROR);
                    return result;
                }
            }
            Account account = AccountMapper.toDomain(accountDb);
            Result<Void> result = account.subtract(currency, amount);
            if (!result.isSuccess()) {
                tx.rollback();
                Result<Account> result3 = Result.failure(result.getErrorMessage(), result.getErrorCode());
                return result3;
            }
            this.updateBalancesInDb(account, accountDb, session);
            tx.commit();
            Result<Account> result4 = Result.success(account);
            return result4;
        }
    }

    @Override
    public Result<Account> deposit(String accountUuid, Currency currency, BigDecimal amount) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb accountDb;
            Transaction tx;
            block14: {
                Result<Account> result;
                tx = session.beginTransaction();
                try {
                    accountDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)accountUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (accountDb != null) break block14;
                    tx.rollback();
                    Result<Account> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error en el dep\u00f3sito: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
                    return result;
                }
            }
            Account account = AccountMapper.toDomain(accountDb);
            Result<Void> result = account.add(currency, amount);
            if (!result.isSuccess()) {
                tx.rollback();
                Result<Account> result3 = Result.failure(result.getErrorMessage(), result.getErrorCode());
                return result3;
            }
            this.updateBalancesInDb(account, accountDb, session);
            tx.commit();
            Result<Account> result4 = Result.success(account);
            return result4;
        }
    }

    @Override
    public Result<Account> exchange(String playerUUID, Currency fromCurrency, BigDecimal amountFrom, Currency toCurrency, BigDecimal amountTo) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb playerDb;
            Transaction tx;
            block16: {
                Result<Account> result;
                tx = session.beginTransaction();
                try {
                    playerDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)playerUUID).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (playerDb != null) break block16;
                    tx.rollback();
                    Result<Account> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error en el intercambio: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
                    return result;
                }
            }
            Account player = AccountMapper.toDomain(playerDb);
            Result<Void> resultSubtract = player.subtract(fromCurrency, amountFrom);
            if (!resultSubtract.isSuccess()) {
                tx.rollback();
                Result<Account> result = Result.failure(resultSubtract.getErrorMessage(), resultSubtract.getErrorCode());
                return result;
            }
            Result<Void> resultAdd = player.add(toCurrency, amountTo);
            if (!resultAdd.isSuccess()) {
                tx.rollback();
                Result<Account> result = Result.failure(resultAdd.getErrorMessage(), resultAdd.getErrorCode());
                return result;
            }
            this.updateBalancesInDb(player, playerDb, session);
            tx.commit();
            Result<Account> result = Result.success(player);
            return result;
        }
    }

    @Override
    public Result<TransferResult> trade(String fromUuid, String toUuid, Currency fromCurrency, Currency toCurrency, BigDecimal amountFrom, BigDecimal amountTo) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb toDb;
            AccountDb fromDb;
            Transaction tx;
            block20: {
                Result<TransferResult> result;
                tx = session.beginTransaction();
                try {
                    fromDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)fromUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    toDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)toUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (fromDb != null && toDb != null) break block20;
                    tx.rollback();
                    Result<TransferResult> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error en el intercambio: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
                    return result;
                }
            }
            Account from = AccountMapper.toDomain(fromDb);
            Account to = AccountMapper.toDomain(toDb);
            Result<Void> resultSubtractFrom = from.subtract(fromCurrency, amountFrom);
            if (!resultSubtractFrom.isSuccess()) {
                tx.rollback();
                Result<TransferResult> result = Result.failure(resultSubtractFrom.getErrorMessage(), resultSubtractFrom.getErrorCode());
                return result;
            }
            Result<Void> resultSubtractTo = to.subtract(toCurrency, amountTo);
            if (!resultSubtractTo.isSuccess()) {
                tx.rollback();
                Result<TransferResult> result = Result.failure(resultSubtractTo.getErrorMessage(), resultSubtractTo.getErrorCode());
                return result;
            }
            Result<Void> resultAddFrom = from.add(toCurrency, amountTo);
            if (!resultAddFrom.isSuccess()) {
                tx.rollback();
                Result<TransferResult> result = Result.failure(resultAddFrom.getErrorMessage(), resultAddFrom.getErrorCode());
                return result;
            }
            Result<Void> resultAddTo = to.add(fromCurrency, amountFrom);
            if (!resultAddTo.isSuccess()) {
                tx.rollback();
                Result<TransferResult> result = Result.failure(resultAddTo.getErrorMessage(), resultAddTo.getErrorCode());
                return result;
            }
            this.updateBalancesInDb(from, fromDb, session);
            this.updateBalancesInDb(to, toDb, session);
            tx.commit();
            Result<TransferResult> result = Result.success(new TransferResult(from, to));
            return result;
        }
    }

    @Override
    public Result<Account> setBalance(String accountUuid, Currency currency, BigDecimal amount) {
        try (Session session = this.sessionFactory.openSession();){
            AccountDb accountDb;
            Transaction tx;
            block14: {
                Result<Account> result;
                tx = session.beginTransaction();
                try {
                    accountDb = (AccountDb)session.createQuery("SELECT a FROM AccountDb a JOIN FETCH a.wallet w JOIN FETCH w.balances b JOIN FETCH b.currency c WHERE a.uuid = :uuid", AccountDb.class).setParameter("uuid", (Object)accountUuid).setLockMode(LockModeType.PESSIMISTIC_WRITE).uniqueResult();
                    if (accountDb != null) break block14;
                    tx.rollback();
                    Result<Account> result2 = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result2;
                }
                catch (NoResultException e) {
                    tx.rollback();
                    result = Result.failure("Cuenta no encontrada", ErrorCode.ACCOUNT_NOT_FOUND);
                    return result;
                }
                catch (Exception e) {
                    tx.rollback();
                    result = Result.failure("Error al establecer balance: " + e.getMessage(), ErrorCode.DATA_BASE_ERROR);
                    return result;
                }
            }
            Account account = AccountMapper.toDomain(accountDb);
            Result<Void> result = account.setMoney(currency, amount);
            if (!result.isSuccess()) {
                tx.rollback();
                Result<Account> result3 = Result.failure(result.getErrorMessage(), result.getErrorCode());
                return result3;
            }
            this.updateBalancesInDb(account, accountDb, session);
            tx.commit();
            Result<Account> result4 = Result.success(account);
            return result4;
        }
    }
}

