/*
 * Decompiled with CFR 0.152.
 */
package net.fellter.moreLeafParticles.yacl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.terraformersmc.modmenu.api.UpdateChannel;
import com.terraformersmc.modmenu.api.UpdateChecker;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.util.HttpUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreLeafParticlesUpdateChecker
implements UpdateChecker {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Mod Menu/More Leaf Particles Update Checker");
    private static final URI PROJECT_URI = URI.create("https://api.modrinth.com/v2/project/HwWDzPBa");

    public UpdateInfo checkForUpdates() {
        UpdateInfo result = null;
        try {
            result = MoreLeafParticlesUpdateChecker.check();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOGGER.error("Failed More Leaf Particles update check");
        }
        return result;
    }

    private static UpdateInfo check() throws IOException, InterruptedException {
        SemanticVersion currentMcVer;
        SemanticVersion currentModVer;
        JsonElement data;
        HttpRequest.Builder request = HttpRequest.newBuilder().GET().uri(PROJECT_URI);
        HttpResponse response = HttpUtil.request((HttpRequest.Builder)request, HttpResponse.BodyHandlers.ofString());
        int status = response.statusCode();
        if (status != 200) {
            LOGGER.warn("Modrinth API responded with a non-200 status: {}, couldn't retrieve project information", (Object)status);
            return null;
        }
        Optional<String> contentType = response.headers().firstValue("Content-Type");
        if (contentType.isEmpty() || !contentType.get().contains("application/json")) {
            LOGGER.warn("Modrinth API responded with a non-json content type, aborting check.");
            return null;
        }
        try {
            data = JsonParser.parseString((String)((String)response.body()));
        }
        catch (JsonSyntaxException e) {
            LOGGER.warn("Tried to parse malformed JSON data, aborting check.");
            return null;
        }
        JsonArray versions = MoreLeafParticlesUpdateChecker.getVersions(data.getAsJsonObject());
        SemanticVersion match = null;
        String versionId = null;
        try {
            String[] split = MoreLeafParticlesUpdateChecker.getCurrentVersion().getFriendlyString().split("\\+");
            currentModVer = SemanticVersion.parse((String)split[0]);
            currentMcVer = SemanticVersion.parse((String)split[1]);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't parse current version information, aborting check.");
            return null;
        }
        for (String version : versions.asList().stream().map(element -> MoreLeafParticlesUpdateChecker.stripQuotes(element.toString())).toList()) {
            SemanticVersion parsedModVer;
            URI versionURI = URI.create("https://api.modrinth.com/v2/version/" + version.replace("\"", ""));
            HttpRequest.Builder versionRequest = HttpRequest.newBuilder().GET().uri(versionURI);
            HttpResponse versionResponse = HttpUtil.request((HttpRequest.Builder)versionRequest, HttpResponse.BodyHandlers.ofString());
            if (versionResponse.statusCode() != 200) {
                LOGGER.warn("Modrinth API responded with a non-200 status: {}, couldn't retrieve information for version: {}", (Object)versionResponse.statusCode(), (Object)version);
                return null;
            }
            JsonElement versionData = JsonParser.parseString((String)((String)versionResponse.body()));
            JsonElement versionNumber = versionData.getAsJsonObject().get("version_number");
            JsonElement id = versionData.getAsJsonObject().get("id");
            List gameVersions = versionData.getAsJsonObject().get("game_versions").getAsJsonArray().asList();
            if (!gameVersions.stream().map(element -> MoreLeafParticlesUpdateChecker.stripQuotes(element.toString())).toList().contains(currentMcVer.getFriendlyString())) continue;
            try {
                parsedModVer = SemanticVersion.parse((String)MoreLeafParticlesUpdateChecker.stripQuotes(versionNumber.toString()).split("\\+")[0]);
            }
            catch (Exception e) {
                LOGGER.info("Couldn't parse mod version");
                continue;
            }
            if (match != null && !MoreLeafParticlesUpdateChecker.isNewer((Version)parsedModVer, (Version)match)) continue;
            match = parsedModVer;
            versionId = id.toString();
        }
        if (match == null || !MoreLeafParticlesUpdateChecker.isNewer(match, (Version)currentModVer) || versionId == null) {
            LOGGER.info("More Leaf Particles is up to date.");
            return null;
        }
        return new MoreLeafParticlesUpdateInfo(match.getFriendlyString(), currentMcVer.getFriendlyString(), versionId);
    }

    private static Version getCurrentVersion() {
        Optional mod = FabricLoader.getInstance().getModContainer("more-leaf-particles");
        if (mod.isPresent()) {
            return ((ModContainer)mod.get()).getMetadata().getVersion();
        }
        throw new NullPointerException();
    }

    private static JsonArray getVersions(JsonObject object) {
        if (!object.has("versions")) {
            throw new NullPointerException("No versions could be found.");
        }
        return object.get("versions").getAsJsonArray();
    }

    private static String stripQuotes(String toStrip) {
        return toStrip.replace("\"", "");
    }

    private static boolean isNewer(Version self, Version other) {
        return self.compareTo((Object)other) > 0;
    }

    public static class MoreLeafParticlesUpdateInfo
    implements UpdateInfo {
        private final String version;
        private final String mcVersion;
        private final String id;

        private MoreLeafParticlesUpdateInfo(String modVersion, String mcVersion, String id) {
            this.version = MoreLeafParticlesUpdateChecker.stripQuotes(modVersion);
            this.mcVersion = MoreLeafParticlesUpdateChecker.stripQuotes(mcVersion);
            this.id = MoreLeafParticlesUpdateChecker.stripQuotes(id);
        }

        @Nullable
        public class_2561 getUpdateMessage() {
            return class_2561.method_43469((String)"modmenu.install_version", (Object[])new Object[]{this.version + "+" + this.mcVersion});
        }

        public boolean isUpdateAvailable() {
            return true;
        }

        public String getDownloadLink() {
            return "https://cdn.modrinth.com/data/HwWDzPBa/versions/" + this.id + "/more_leaf_particles-" + this.version + "%2B" + this.mcVersion + ".jar";
        }

        public UpdateChannel getUpdateChannel() {
            return UpdateChannel.RELEASE;
        }
    }
}

