package net.fellter.moreLeafParticles.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.fellter.moreLeafParticles.ModLeavesParticle;
import net.fellter.moreLeafParticles.MoreLeafParticles;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_8253;
import net.minecraft.class_9381;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import static net.fellter.moreLeafParticles.yacl.ModConfig.*;

public final class LeavesParticleMixins {
	@Mixin(class_8253.class_10604.class)
	public static class TintedLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/TintedParticleEffect;Lnet/minecraft/client/world/ClientWorld;DDDDDDLnet/minecraft/util/math/random/Random;)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyOak(class_9381 tintedParticleEffect, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableOakSize ? oakSize : 2.0F;
				float gravity = enableOakGravity ? oakGravity : 0.07F;
				float initVelocityY = enableOakInitialVelocity ? oakInitialVelocity : 0.021F;
				float wind = enableOakWind ? oakWind : 10.0F;

				class_8253 particle = new class_8253(clientWorld, d, e, f, spriteProvider.method_18139(random), gravity, wind, true, oakFlowAway, size, initVelocityY);
				ModLeavesParticle.tintParticle(particle, tintedParticleEffect, enableOakCustomColor, useOakTint, oakColor);
				return particle;
			} else {
				return original.call(tintedParticleEffect, clientWorld, d, e, f, g, h, i, random);
			}
		}
	}

	@Mixin(class_8253.class_10380.class)
	public static class PaleOakLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/SimpleParticleType;Lnet/minecraft/client/world/ClientWorld;DDDDDDLnet/minecraft/util/math/random/Random;)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyPaleOak(class_2400 simpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = enablePaleOakSize ? paleOakSize : 2.0F;
				float gravity = enablePaleOakGravity ? paleOakGravity : 0.07F;
				float initVelocityY = enablePaleOakInitialVelocity ? paleOakInitialVelocity : 0.021F;
				float wind = enablePaleOakWind ? paleOakWind : 10F;

				return new class_8253(clientWorld, d, e, f, spriteProvider.method_18139(random), gravity, wind, true, paleOakFlowAway, size, initVelocityY);
			} else {
				return original.call(simpleParticleType, clientWorld, d, e, f, g, h, i, random);
			}
		}
	}

	@Mixin(class_8253.class_10379.class)
	public static class CherryLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/SimpleParticleType;Lnet/minecraft/client/world/ClientWorld;DDDDDDLnet/minecraft/util/math/random/Random;)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyCherry(class_2400 simpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, class_5819 random, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableCherrySize ? cherrySize : 2.0F;
				float gravity = enableCherryGravity ? cherryGravity : 0.07F;
				float initVelocityY = enableCherryInitialVelocity ? cherryInitialVelocity : 0.021F;
				float wind = enableCherryWind ? cherryWind : 10F;

				return new class_8253(clientWorld, d, e, f, spriteProvider.method_18139(random), gravity, wind, true, cherryFlowAway, size, initVelocityY);
			} else {
				return original.call(simpleParticleType, clientWorld, d, e, f, g, h, i, random);
			}
		}
	}
}
