package net.fellter.moreLeafParticles;

import java.awt.*;

import org.jetbrains.annotations.Nullable;
import net.minecraft.class_2400;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_8253;
import net.minecraft.class_9381;
import net.minecraft.client.particle.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import static net.fellter.moreLeafParticles.yacl.ModConfig.*;

@Environment(EnvType.CLIENT)
public class ModLeavesParticle {
	public static class SpruceLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public SpruceLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableSpruceSize ? spruceSize : 2F;
				float gravity = enableSpruceGravity ? spruceGravity : 0.07F;
				float initYVelocity = enableSpruceInitialVelocity ? spruceInitialVelocity : 0.021F;
				float wind = enableSpruceWind ? spruceWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, spruceFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableSpruceCustomColor, useSpruceTint, spruceColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class BirchLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public BirchLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableBirchSize ? birchSize : 2F;
				float gravity = enableBirchGravity ? birchGravity : 0.07F;
				float initYVelocity = enableBirchInitialVelocity ? birchInitialVelocity : 0.021F;
				float wind = enableBirchWind ? birchWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, birchFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableBirchCustomColor, useBirchTint, birchColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class MangroveLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public MangroveLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableMangroveSize ? mangroveSize : 2F;
				float gravity = enableMangroveGravity ? mangroveGravity : 0.07F;
				float initYVelocity = enableMangroveInitialVelocity ? mangroveInitialVelocity : 0.021F;
				float wind = enableMangroveWind ? mangroveWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, mangroveFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableMangroveCustomColor, useMangroveTint, mangroveColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class JungleLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public JungleLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableJungleSize ? jungleSize : 2F;
				float gravity = enableJungleGravity ? jungleGravity : 0.07F;
				float initYVelocity = enableJungleInitialVelocity ? jungleInitialVelocity : 0.021F;
				float wind = enableJungleWind ? jungleWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, jungleFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableJungleCustomColor, useJungleTint, jungleColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class AcaciaLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public AcaciaLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableAcaciaSize ? acaciaSize : 1.66F;
				float gravity = enableAcaciaGravity ? acaciaGravity : 0.07F;
				float initYVelocity = enableAcaciaInitialVelocity ? acaciaInitialVelocity : 0.021F;
				float wind = enableAcaciaWind ? acaciaWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, acaciaFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableAcaciaCustomColor, useAcaciaTint, acaciaColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 1.66F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class DarkOakLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public DarkOakLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_8253 particle;

			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableDarkOakSize ? darkOakSize : 2F;
				float gravity = enableDarkOakGravity ? darkOakGravity : 0.07F;
				float initYVelocity = enableDarkOakInitialVelocity ? darkOakInitialVelocity : 0.021F;
				float wind = enableDarkOakWind ? darkOakWind : 10F;

				particle = new class_8253(clientWorld, d, e, f, provider, gravity, wind, true, darkOakFlowAway, size, initYVelocity);
				tintParticle(particle, tinted, enableDarkOakCustomColor, useDarkOakTint, darkOakColor);
			} else {
				particle = new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2F, 0.021F);
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		}
	}

	public static class AzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public AzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableAzaleaSize ? azaleaSize : 2.0F;
				float initVelocityY = enableAzaleaInitialVelocity ? azaleaInitialVelocity : 0.021F;
				float gravity = enableAzaleaGravity ? azaleaGravity : 0.07F;
				float wind = enableAzaleaWind ? azaleaWind : 10F;

				return new class_8253(world, x, y, z, spriteProvider, gravity, wind, true, azaleaFlowAway, size, initVelocityY);
			} else {
				return new class_8253(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	public static class FloweringAzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public FloweringAzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = enableFloweringAzaleaSize ? floweringAzaleaSize : 2.0F;
				float initVelocityY = enableFloweringAzaleaInitialVelocity ? floweringAzaleaInitialVelocity : 0.021F;
				float gravity = enableFloweringAzaleaGravity ? floweringAzaleaGravity : 0.07F;
				float wind = enableFloweringAzaleaWind ? floweringAzaleaWind : 10F;

				return new class_8253(world, x, y, z, spriteProvider, gravity, wind, true, floweringAzaleaFlowAway, size, initVelocityY);
			} else {
				return new class_8253(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	public static void tintParticle(
			class_3940 particle,
			class_9381 tinted,
			boolean enableCustomColor,
			boolean useTint,
			Color color
	) {
		float red = tinted.method_58259();
		float green = tinted.method_58263();
		float blue = tinted.method_58264();

		if (!enableCustomColor) {
			particle.method_3084(red, green, blue);
			return;
		}

		if (!useTint) {
			particle.method_3084((float) color.getRed() / 255, (float) color.getGreen() / 255, (float) color.getBlue() / 255);
		} else {
			red = ((red + (float) color.getRed() / 255) / 2);
			green = ((green + (float) color.getRed() / 255) / 2);
			blue = ((blue + (float) color.getBlue() / 255) / 2);

			particle.method_3084(red, green, blue);
		}
	}

	public static class Builder {
		private final class_638 world;
		private final class_4002 provider;
		private final double x;
		private final double y;
		private final double z;
		private float gravity = 0.07F;
		private float initVelocityY = 0.021F;
		private float size = 2.0F;

		public Builder(class_638 world, class_4002 provider, double x, double y, double z) {
			this.world = world;
			this.provider = provider;
			this.x = x;
			this.y = y;
			this.z = z;
		}

		public class_8253 build(boolean enableGrav, boolean enableSize, boolean enableInitVelocityY) {
			float gravity = enableGrav ? this.gravity : 0.07F;
			float size = enableSize ? this.size : 2.0F;
			float initVelocityY = enableInitVelocityY ? this.initVelocityY : 0.021F;

			return new class_8253(world, x, y, z, provider, gravity, 10.0F, true, false, size, initVelocityY);
		}

		public Builder gravity(float gravity) {
			this.gravity = gravity;
			return this;
		}

		public Builder initVelocityY(float initVelocityY) {
			this.initVelocityY = initVelocityY;
			return this;
		}

		public Builder size(float size) {
			this.size = size;
			return this;
		}
	}
}