package net.fellter.moreLeafParticles;

import java.awt.*;

import net.fellter.moreLeafParticles.yacl.ModConfig;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_8253;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(EnvType.CLIENT)
public class ModLeavesParticle {
	public static class SpruceLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public SpruceLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.spruceGravity)
					.initVelocityY(ModConfig.spruceInitialVelocity)
					.size(ModConfig.spruceSize)
					.build(ModConfig.enableSpruceGravity, ModConfig.enableSpruceSize, ModConfig.enableSpruceInitialVelocity)
					: super.method_66537(tinted, clientWorld, d, e, f, g, h, i);
			tintParticle(particle, tinted, ModConfig.enableSpruceCustomColor, ModConfig.useSpruceTint, ModConfig.spruceColor);
			return particle;
		}
	}

	public static class BirchLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public BirchLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.birchGravity)
					.initVelocityY(ModConfig.birchInitialVelocity)
					.size(ModConfig.birchSize)
					.build(ModConfig.enableBirchGravity, ModConfig.enableBirchSize, ModConfig.enableBirchInitialVelocity)
					: super.method_66537(tinted, clientWorld, d, e, f, g, h, i);
			tintParticle(particle, tinted, ModConfig.enableBirchCustomColor, ModConfig.useBirchTint, ModConfig.birchColor);
			return particle;
		}
	}

	public static class MangroveLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public MangroveLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.mangroveGravity)
					.initVelocityY(ModConfig.mangroveInitialVelocity)
					.size(ModConfig.mangroveSize)
					.build(ModConfig.enableMangroveGravity, ModConfig.enableMangroveSize, ModConfig.enableMangroveInitialVelocity)
					: super.method_66537(tinted, clientWorld, d, e, f, g, h, i);
			tintParticle(particle, tinted, ModConfig.enableMangroveCustomColor, ModConfig.useMangroveTint, ModConfig.mangroveColor);
			return particle;
		}
	}

	public static class JungleLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public JungleLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.jungleGravity)
					.initVelocityY(ModConfig.jungleInitialVelocity)
					.size(ModConfig.jungleSize)
					.build(ModConfig.enableJungleGravity, ModConfig.enableJungleSize, ModConfig.enableJungleInitialVelocity)
					: super.method_66537(tinted, clientWorld, d, e, f, g, h, i);
			tintParticle(particle, tinted, ModConfig.enableSpruceCustomColor, ModConfig.useSpruceTint, ModConfig.spruceColor);
			return particle;
		}
	}

	public static class AcaciaLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public AcaciaLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.acaciaGravity)
					.initVelocityY(ModConfig.acaciaInitialVelocity)
					.size(ModConfig.acaciaSize)
					.build(ModConfig.enableAcaciaGravity, ModConfig.enableAcaciaSize, ModConfig.enableAcaciaInitialVelocity)
					: new class_8253(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 1.66F, 0.021F);
			tintParticle(particle, tinted, ModConfig.enableAcaciaCustomColor, ModConfig.useAcaciaTint, ModConfig.acaciaColor);
			return particle;
		}
	}

	public static class DarkOakLeavesFactory extends class_8253.class_10604 {
		private final class_4002 provider;

		public DarkOakLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			class_703 particle = MoreLeafParticles.isYACLPresent()
					? new Builder(clientWorld, provider, d, e, f)
					.gravity(ModConfig.darkOakGravity)
					.initVelocityY(ModConfig.darkOakInitialVelocity)
					.size(ModConfig.darkOakSize)
					.build(ModConfig.enableDarkOakGravity, ModConfig.enableDarkOakSize, ModConfig.enableDarkOakInitialVelocity)
					: super.method_66537(tinted, clientWorld, d, e, f, g, h, i);
			tintParticle(particle, tinted, ModConfig.enableDarkOakCustomColor, ModConfig.useDarkOakTint, ModConfig.darkOakColor);
			return particle;
		}
	}

	public static class AzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public AzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enableAzaleaSize ? ModConfig.azaleaSize : 2.0F;
				float initVelocityY = ModConfig.enableAzaleaInitialVelocity ? ModConfig.azaleaInitialVelocity : 0.021F;
				float gravity = ModConfig.enableAzaleaGravity ? ModConfig.azaleaGravity : 0.07F;

				return new class_8253(world, x, y, z, spriteProvider, gravity, 10.0F, true, false, size, initVelocityY);
			} else {
				return new class_8253(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	public static class FloweringAzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public FloweringAzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enableFloweringAzaleaSize ? ModConfig.floweringAzaleaSize : 2.0F;
				float initVelocityY = ModConfig.enableFloweringAzaleaInitialVelocity ? ModConfig.floweringAzaleaInitialVelocity : 0.021F;
				float gravity = ModConfig.enableFloweringAzaleaGravity ? ModConfig.floweringAzaleaGravity : 0.07F;

				return new class_8253(world, x, y, z, spriteProvider, gravity, 10.0F, true, false, size, initVelocityY);
			} else {
				return new class_8253(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	public static void tintParticle(
			class_703 particle,
			class_9381 tinted,
			boolean enableColor,
			boolean useTint,
			Color color
	) {
		if (enableColor) {
			float red = tinted.method_58259();
			float green = tinted.method_58263();
			float blue = tinted.method_58264();

			if (useTint) {
				red = red + ((float) color.getRed() / 255);
				green = green + ((float) color.getRed() / 255);
				blue = blue + ((float) color.getBlue() / 255);

				particle.method_3084(red, green, blue);
			} else {
				particle.method_3084(red, green, blue);
			}
		} else {
			particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
		}
	}

	public static class Builder {
		private final class_638 world;
		private final class_4002 provider;
		private final double x;
		private final double y;
		private final double z;
		private float gravity = 0.07F;
		private float initVelocityY = 0.021F;
		private float size = 2.0F;

		public Builder(class_638 world, class_4002 provider, double x, double y, double z) {
			this.world = world;
			this.provider = provider;
			this.x = x;
			this.y = y;
			this.z = z;
		}

		public class_8253 build(boolean enableGrav, boolean enableSize, boolean enableInitVelocityY) {
			float gravity = enableGrav ? this.gravity : 0.07F;
			float size = enableSize ? this.size : 2.0F;
			float initVelocityY = enableInitVelocityY ? this.initVelocityY : 0.021F;

			return new class_8253(world, x, y, z, provider, gravity, 10.0F, true, false, size, initVelocityY);
		}

		public Builder gravity(float gravity) {
			this.gravity = gravity;
			return this;
		}

		public Builder initVelocityY(float initVelocityY) {
			this.initVelocityY = initVelocityY;
			return this;
		}

		public Builder size(float size) {
			this.size = size;
			return this;
		}
	}
}
