package net.fellter.moreLeafParticles.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.fellter.moreLeafParticles.ModLeavesParticle;
import net.fellter.moreLeafParticles.MoreLeafParticles;
import net.fellter.moreLeafParticles.yacl.ModConfig;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_8253;
import net.minecraft.class_9381;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

public class LeavesParticleMixins {
	@Mixin(class_8253.class_10604.class)
	public static class TintedLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/TintedParticleEffect;Lnet/minecraft/client/world/ClientWorld;DDDDDD)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyOak(class_9381 tintedParticleEffect, class_638 clientWorld, double d, double e, double f, double g, double h, double i, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				class_703 particle = new ModLeavesParticle.Builder(clientWorld, spriteProvider, d, e, f)
						.gravity(ModConfig.oakGravity)
						.initVelocityY(ModConfig.oakInitialVelocity)
						.size(ModConfig.oakSize)
						.build(ModConfig.enableOakGravity, ModConfig.enableOakSize, ModConfig.enableOakInitialVelocity);
				ModLeavesParticle.tintParticle(particle, tintedParticleEffect, ModConfig.enableSpruceCustomColor, ModConfig.useSpruceTint, ModConfig.spruceColor);
				return particle;
			} else {
				return original.call(tintedParticleEffect, clientWorld, d, e, f, g, h, i);
			}
		}
	}

	@Mixin(class_8253.class_10380.class)
	public static class PaleOakLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/SimpleParticleType;Lnet/minecraft/client/world/ClientWorld;DDDDDD)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyPaleOak(class_2400 simpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enablePaleOakSize ? ModConfig.paleOakSize : 2.0F;
				float gravity = ModConfig.enablePaleOakGravity ? ModConfig.paleOakGravity : 0.07F;
				float initVelocityY = ModConfig.enablePaleOakInitialVelocity ? ModConfig.paleOakInitialVelocity : 0.021F;

				return new class_8253(clientWorld, d, e, f, spriteProvider, gravity, 10.0F, true, false, size, initVelocityY);
			} else {
				return original.call(simpleParticleType, clientWorld, d, e, f, g, h, i);
			}
		}
	}

	@Mixin(class_8253.class_10379.class)
	public static class CherryLeavesFactoryMixin {
		@Shadow
		@Final
		private class_4002 spriteProvider;

		@WrapMethod(method = "createParticle(Lnet/minecraft/particle/SimpleParticleType;Lnet/minecraft/client/world/ClientWorld;DDDDDD)Lnet/minecraft/client/particle/Particle;")
		private class_703 fellter$modifyCherry(class_2400 simpleParticleType, class_638 clientWorld, double d, double e, double f, double g, double h, double i, Operation<class_703> original) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enableCherrySize ? ModConfig.cherrySize : 2.0F;
				float gravity = ModConfig.enableCherryGravity ? ModConfig.cherryGravity : 0.07F;
				float initVelocityY = ModConfig.enableCherryInitialVelocity ? ModConfig.cherryInitialVelocity : 0.021F;

				return new class_8253(clientWorld, d, e, f, spriteProvider, gravity, 10.0F, true, false, size, initVelocityY);
			} else {
				return original.call(simpleParticleType, clientWorld, d, e, f, g, h, i);
			}
		}
	}
}
