package net.fellter.moreLeafParticles;

import java.awt.*;

import net.fellter.moreLeafParticles.yacl.ModConfig;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_8253;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(EnvType.CLIENT)
public class ModLeavesParticle extends class_8253 {
	public ModLeavesParticle(class_638 world, double x, double y, double z, class_4002 spriteProvider, float gravity, float f, boolean bl, boolean bl2, float size, float initialYVelocity) {
		super(world, x, y, z, spriteProvider, gravity, f, bl, bl2, size, initialYVelocity);
	}

	public static class SpruceLeavesFactory extends class_10604 {
		private final class_4002 provider;

		public SpruceLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			return createTintedParticle(tinted, clientWorld, provider, d, e, f, ModConfig.enableSpruceSize, ModConfig.spruceSize, ModConfig.enableSpruceCustomColor, ModConfig.useSpruceTint, ModConfig.spruceColor);
		}
	}

	public static class BirchLeavesFactory extends class_10604 {
		private final class_4002 provider;

		public BirchLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			return createTintedParticle(tinted, clientWorld, provider, d, e, f, ModConfig.enableBirchSize, ModConfig.birchSize, ModConfig.enableBirchCustomColor, ModConfig.useBirchTint, ModConfig.birchColor);
		}
	}

	public static class MangroveLeavesFactory extends class_10604 {
		private final class_4002 provider;

		public MangroveLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			return createTintedParticle(tinted, clientWorld, provider, d, e, f, ModConfig.enableMangroveSize, ModConfig.mangroveSize, ModConfig.enableMangroveCustomColor, ModConfig.useMangroveTint, ModConfig.mangroveColor);
		}
	}

	public static class JungleLeavesFactory extends class_10604 {
		private final class_4002 provider;

		public JungleLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			return createTintedParticle(tinted, clientWorld, provider, d, e, f, ModConfig.enableJungleSize, ModConfig.jungleSize, ModConfig.enableJungleCustomColor, ModConfig.useJungleTint, ModConfig.jungleColor);
		}
	}

	public static class AcaciaLeavesFactory extends class_10604 {
		private final class_4002 provider;

		public AcaciaLeavesFactory(class_4002 spriteProvider) {
			super(spriteProvider);
			this.provider = spriteProvider;
		}

		@Override
		public class_703 method_66537(class_9381 tinted, class_638 clientWorld, double d, double e, double f, double g, double h, double i) {
			return createTintedParticle(tinted, clientWorld, provider, d, e, f, ModConfig.enableAcaciaSize, ModConfig.acaciaSize, ModConfig.enableAcaciaCustomColor, ModConfig.useAcaciaTint, ModConfig.acaciaColor);
		}
	}

	public static class AzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public AzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enableAzaleaSize ? ModConfig.azaleaSize : 2.0F;
				return new ModLeavesParticle(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, size, 0.021F);
			} else {
				return new ModLeavesParticle(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	public static class FloweringAzaleaLeavesFactory implements class_707<class_2400> {
		private final class_4002 spriteProvider;

		public FloweringAzaleaLeavesFactory(class_4002 spriteProvider) {
			this.spriteProvider = spriteProvider;
		}

		@Override
		public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
			if (MoreLeafParticles.isYACLPresent()) {
				float size = ModConfig.enableFloweringAzaleaSize ? ModConfig.floweringAzaleaSize : 2.0F;
				return new ModLeavesParticle(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, size, 0.021F);
			} else {
				return new ModLeavesParticle(world, x, y, z, spriteProvider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			}
		}
	}

	static class_703 createTintedParticle(
			class_9381 tinted,
			class_638 clientWorld,
			final class_4002 provider,
			double d,
			double e,
			double f,
			boolean enableSize,
			float customSize,
			boolean enableCustomColor,
			boolean useTint,
			Color customColor
	) {
		if (MoreLeafParticles.isYACLPresent()) {
			float size = enableSize ? customSize : 2.0F;
			class_703 particle = new ModLeavesParticle(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, size, 0.021F);

			if (enableCustomColor) {
				if (useTint) {
					particle.method_3084(
							Math.clamp((tinted.method_58259() + customColor.getRed()) / 510, 0, 255),
							Math.clamp((tinted.method_58263() + customColor.getGreen()) / 510, 0, 255),
							Math.clamp((tinted.method_58264() + customColor.getBlue()) / 510, 0, 255)
					);
				} else {
					particle.method_3084(
							(float) customColor.getRed() / 255,
							(float) customColor.getGreen() / 255,
							(float) customColor.getBlue() / 255
					);
				}
			} else {
				particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			}

			return particle;
		} else {
			class_703 particle = new ModLeavesParticle(clientWorld, d, e, f, provider, 0.07F, 10.0F, true, false, 2.0F, 0.021F);
			particle.method_3084(tinted.method_58259(), tinted.method_58263(), tinted.method_58264());
			return particle;
		}
	}
}
