/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations;

import cn.jason31416.betternations.army.BreakCampRunnable;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.ArmyListener;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.command.BetterNationsCommand;
import cn.jason31416.betternations.command.nation.ToggleArmyUpdateCommand;
import cn.jason31416.betternations.manager.ArmyUpdateManager;
import cn.jason31416.betternations.manager.BorderDisplayManager;
import cn.jason31416.betternations.manager.EventListener;
import cn.jason31416.betternations.manager.FromToAnimationManager;
import cn.jason31416.betternations.manager.HistoricalBroadcastManager;
import cn.jason31416.betternations.manager.ItemCraftingManager;
import cn.jason31416.betternations.manager.LandArmyManager;
import cn.jason31416.betternations.manager.NaturalResourcesManager;
import cn.jason31416.betternations.manager.map.BlueMapHook;
import cn.jason31416.betternations.manager.map.MapDisplayManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.TownLevel;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.Hologram;
import cn.jason31416.betternations.structure.PlaceableStructure;
import cn.jason31416.betternations.structure.StructureListener;
import cn.jason31416.betternations.structure.types.Extractor;
import cn.jason31416.betternations.structure.types.Granary;
import cn.jason31416.betternations.structure.types.Machinery;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.Utils;
import cn.jason31416.planetlib.data.DataList;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.data.YamlStorage;
import cn.jason31416.planetlib.gui.GUILoader;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.update.UpdateCycle;
import cn.jason31416.planetlib.update.UpdateTask;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class BetterNations
extends JavaPlugin {
    public static BetterNations instance;
    public static YamlStorage storage;

    private void saveFolder(String name) throws URISyntaxException, IOException {
        if (new File(this.getDataFolder(), name).isDirectory()) {
            return;
        }
        URI uri = this.getClassLoader().getResource(name).toURI();
        try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
             Stream<Path> walk = Files.walk(fileSystem.getPath(name, new String[0]), 1, new FileVisitOption[0]);){
            Iterator it = walk.iterator();
            while (it.hasNext()) {
                Path i = (Path)it.next();
                if (i.toString().equals(name)) continue;
                this.savePluginResource(i.toString());
            }
        }
    }

    public void saveAllResources() {
        this.savePluginResource("army.yml");
        try {
            this.saveFolder("gui/zh_cn");
            this.saveFolder("gui/en_us");
            this.saveFolder("item");
            this.saveFolder("lang");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.savePluginResource("gui/README.md");
    }

    public void savePluginResource(@NotNull String resourcePath) {
        if (!resourcePath.isEmpty()) {
            InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
            if (in == null) {
                throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + this.getFile());
            }
            File outFile = new File(this.getDataFolder(), resourcePath);
            int lastIndex = resourcePath.lastIndexOf(47);
            File outDir = new File(this.getDataFolder(), resourcePath.substring(0, Math.max(lastIndex, 0)));
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            try {
                if (!outFile.exists()) {
                    int len;
                    OutputStream out = Files.newOutputStream(outFile.toPath(), new OpenOption[0]);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.close();
                    in.close();
                }
            }
            catch (IOException var10) {
                this.getLogger().log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + outFile, var10);
            }
        } else {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
    }

    public void printAsciiArt() {
        this.getLogger().info("\u001b[37m+-------------------------------------------------------------------+");
        this.getLogger().info("\u001b[37m|\u001b[36m    ____       __  __            _   __      __  _                 \u001b[37m|");
        this.getLogger().info("\u001b[37m|\u001b[36m   / __ )___  / /_/ /____  _____/ | / /___ _/ /_(_)___  ____  _____\u001b[37m|");
        this.getLogger().info("\u001b[37m|\u001b[36m  / __  / _ \\/ __/ __/ _ \\/ ___/  |/ / __ `/ __/ / __ \\/ __ \\/ ___/\u001b[37m|");
        this.getLogger().info("\u001b[37m|\u001b[36m / /_/ /  __/ /_/ /_/  __/ /  / /|  / /_/ / /_/ / /_/ / / / (__  ) \u001b[37m|");
        this.getLogger().info("\u001b[37m|\u001b[36m/_____/\\___/\\__/\\__/\\___/_/  /_/ |_/\\__,_/\\__/_/\\____/_/ /_/____/  \u001b[37m|");
        this.getLogger().info("\u001b[37m|\u001b[36m                                                                   \u001b[37m|");
        this.getLogger().info("\u001b[37m+-------------------------------------------------\u001b[34mBy Jason31416\u001b[37m-----+");
    }

    public void loadGUIs(File guiFolder) {
        if (!guiFolder.exists()) {
            guiFolder.mkdirs();
        } else {
            for (File file : guiFolder.listFiles()) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(".yml")) continue;
                    this.getLogger().info("\u001b[36m- Loading " + file.getName() + "\u001b[0m");
                    GUILoader.loadFile(file);
                    continue;
                }
                this.loadGUIs(file);
            }
        }
    }

    public void loadGUIs() {
        File guiFolder = new File(this.getDataFolder(), "gui/" + Config.getString("lang"));
        this.getLogger().info("\u001b[34mLoading GUIs:\u001b[0m");
        this.loadGUIs(guiFolder);
    }

    public void registerDataLists() {
        this.getLogger().info("\u001b[34mLoading data...\u001b[0m");
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        storage = new YamlStorage(dataFolder);
        storage.registerDataList(new DataList<Nation>(){

            @Override
            public String getName() {
                return "nations";
            }

            @Override
            public List<Nation> getAllData() {
                return new ArrayList<Nation>(Nation.nations.values());
            }

            @Override
            public boolean serialize(Object data, IDataItem dataItem) {
                if (!(data instanceof Nation)) {
                    return false;
                }
                Nation nation = (Nation)data;
                return nation.serialize(dataItem);
            }

            @Override
            public Nation deserialize(IDataItem dataItem) {
                return Nation.deserialize(dataItem);
            }
        });
        storage.registerDataList(new DataList<Town>(){

            @Override
            public String getName() {
                return "towns";
            }

            @Override
            public List<Town> getAllData() {
                return new ArrayList<Town>(Town.towns.values());
            }

            @Override
            public boolean serialize(Object data, IDataItem dataItem) {
                if (!(data instanceof Town)) {
                    return false;
                }
                Town town = (Town)data;
                return town.serialize(dataItem);
            }

            @Override
            public Town deserialize(IDataItem dataItem) {
                return Town.deserialize(dataItem);
            }
        });
        storage.registerDataList(new DataList<AbstractStructure>(){

            @Override
            public String getName() {
                return "structures";
            }

            @Override
            public List<AbstractStructure> getAllData() {
                return new ArrayList<AbstractStructure>(AbstractStructure.structures.values());
            }

            @Override
            public boolean serialize(Object data, IDataItem dataItem) {
                if (data instanceof AbstractStructure) {
                    AbstractStructure structure = (AbstractStructure)data;
                    return AbstractStructure.pack(dataItem, structure);
                }
                return false;
            }

            @Override
            public AbstractStructure deserialize(IDataItem dataItem) {
                return AbstractStructure.unpack(dataItem);
            }
        });
        storage.registerDataList(new DataList<HistoricalBroadcastManager.HistoricalEvent>(){

            @Override
            public String getName() {
                return "history";
            }

            @Override
            public List<HistoricalBroadcastManager.HistoricalEvent> getAllData() {
                ArrayList<HistoricalBroadcastManager.HistoricalEvent> ret = new ArrayList<HistoricalBroadcastManager.HistoricalEvent>();
                for (List<HistoricalBroadcastManager.HistoricalEvent> i : HistoricalBroadcastManager.history.values()) {
                    ret.addAll(i);
                }
                return ret;
            }

            @Override
            public boolean serialize(Object data, IDataItem dataItem) {
                if (data instanceof HistoricalBroadcastManager.HistoricalEvent) {
                    HistoricalBroadcastManager.HistoricalEvent event = (HistoricalBroadcastManager.HistoricalEvent)data;
                    return event.serialize(dataItem);
                }
                return false;
            }

            @Override
            public HistoricalBroadcastManager.HistoricalEvent deserialize(IDataItem dataItem) {
                return HistoricalBroadcastManager.HistoricalEvent.deserialize(dataItem);
            }
        });
        storage.load();
        UpdateCycle.registerTask("BetterNations.PeriodicSave", new UpdateTask(1200, () -> storage.save()));
    }

    public void onEnable() {
        instance = this;
        this.saveAllResources();
        this.printAsciiArt();
        PlanetLib.initialize(this, "1");
        BlueMapHook.init();
        ItemCraftingManager.loadAll();
        LandArmyManager.loadAll();
        PlaceableStructure.registerAll();
        AbstractStructure.registerAllStructures();
        this.registerDataLists();
        this.loadGUIs();
        MapDisplayManager.init();
        Granary.loadSupplyWorth();
        ToggleArmyUpdateCommand.bossBar = Bukkit.createBossBar((String)Message.getMessage("combat.next-update-bossbar").toString(), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
        ToggleArmyUpdateCommand.bossBar.setVisible(true);
        TownLevel.loadLevels();
        NaturalResourcesManager.load();
        UpdateCycle.registerTask("BetterNations.BorderDisplay", new UpdateTask(Config.getInt("border-display.interval"), new BorderDisplayManager()));
        UpdateCycle.registerTask("BetterNations.ArmyUpdate", new UpdateTask(Config.getInt("combat.army-tick-interval") * 20, new ArmyUpdateManager()));
        if (Config.getBoolean("combat.enable-animation")) {
            UpdateCycle.registerTask("BetterNations.FromToParticlesUpdate", new UpdateTask(Config.getInt("combat.particle-interval"), FromToAnimationManager::updateAll));
        }
        UpdateCycle.registerTask("BetterNations.ArmyUpdateBossbar", new UpdateTask(5, () -> {
            ToggleArmyUpdateCommand.bossBar.setProgress(Math.min(1.0, Math.max(0.0, (double)(ArmyUpdateManager.nextUpdate - System.currentTimeMillis()) / 1000.0 / (double)Config.getInt("combat.army-tick-interval"))));
            ToggleArmyUpdateCommand.bossBar.setTitle(Message.getMessage("combat.next-update-bossbar").add("timer", Utils.formatSeconds((int)(ArmyUpdateManager.nextUpdate - System.currentTimeMillis()) / 1000)).toString());
        }));
        UpdateCycle.registerTask("BetterNations.ExtractorUpdate", new UpdateTask(Config.getInt("structure.extractor-tick-interval"), Extractor::tickAll));
        UpdateCycle.registerTask("BetterNations.MapUpdate", new UpdateTask(Config.getInt("bluemap.check-interval"), MapDisplayManager::update));
        ArmyUpdateManager.nextUpdate = System.currentTimeMillis() + 1000L * (long)Config.getInt("combat.army-tick-interval");
        UpdateCycle.registerTask("BetterNations.ClaimingActionbar", new UpdateTask(20, () -> {
            for (SimplePlayer i : new ArrayList<SimplePlayer>(EventListener.autoClaiming.keySet())) {
                if (!i.isOnline()) {
                    EventListener.autoClaiming.remove(i);
                    continue;
                }
                switch (EventListener.autoClaiming.get(i)) {
                    case CLAIM: {
                        Message.getMessage("auto-claiming.claim").sendActionbar(i);
                        break;
                    }
                    case UNCLAIM: {
                        Message.getMessage("auto-claiming.unclaim").sendActionbar(i);
                        break;
                    }
                    case TOWN_CLAIM: {
                        Message.getMessage("auto-claiming.town-claim").sendActionbar(i);
                        break;
                    }
                    case TOWN_UNCLAIM: {
                        Message.getMessage("auto-claiming.town-unclaim").sendActionbar(i);
                    }
                }
            }
        }));
        UpdateCycle.registerTask("BetterNations.TownDevPointsIncrement", new UpdateTask(20, () -> {
            for (Player i : Bukkit.getOnlinePlayers()) {
                SimplePlayer player = SimplePlayer.of(i);
                SimpleChunkLocation chunk = player.getLocation().getChunkLocation();
                if (!chunk.isTownChunk() || Objects.requireNonNull(chunk.getTown()).getRole(player) == TownRole.NONE || chunk.getTown().devadded.getOrDefault(player, 0) >= Config.getInt("town.dev-points.max-day-exist")) continue;
                chunk.getTown().devPoints += Config.getDouble("town.dev-points.exists");
                chunk.getTown().devadded.put(player, chunk.getTown().devadded.getOrDefault(player, 0) + 1);
            }
        }));
        UpdateCycle.registerTask("BetterNations.DayChange", new UpdateTask(1728000, () -> {
            Message.getMessage("town.day-change").broadcast();
            for (Town i : Town.towns.values()) {
                i.devadded.clear();
                i.devPoints = Math.max(i.devPoints - Config.getDouble("town.dev-points.drop-per-day"), 0.0);
            }
        }));
        UpdateCycle.registerTask("BetterNations.MachineryUpdate", new UpdateTask(20, Machinery::updateMachineries));
        new BetterNationsCommand().register();
        Bukkit.getPluginManager().registerEvents((Listener)new EventListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new StructureListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ArmyListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BreakCampRunnable.CampBreakingListener(), (Plugin)this);
    }

    public void reload() {
        this.saveAllResources();
        storage.save();
        PlanetLib.reload(this);
        ItemCraftingManager.unregisterAll();
        LandArmyManager.unregisterAll();
        ItemCraftingManager.loadAll();
        LandArmyManager.loadAll();
        Granary.loadSupplyWorth();
        TownLevel.loadLevels();
        NaturalResourcesManager.load();
        GUILoader.loadedGUIs.clear();
        this.loadGUIs();
        UpdateCycle.unregisterTask("BetterNations.BorderDisplay");
        UpdateCycle.registerTask("BetterNations.BorderDisplay", new UpdateTask(Config.getInt("border-display.interval"), new BorderDisplayManager()));
        UpdateCycle.unregisterTask("BetterNations.ExtractorUpdate");
        UpdateCycle.registerTask("BetterNations.ExtractorUpdate", new UpdateTask(Config.getInt("structure.extractor-tick-interval"), Extractor::tickAll));
        UpdateCycle.unregisterTask("BetterNations.FromToParticlesUpdate");
        if (Config.getBoolean("combat.enable-animation")) {
            UpdateCycle.registerTask("BetterNations.FromToParticlesUpdate", new UpdateTask(Config.getInt("combat.particle-interval"), FromToAnimationManager::updateAll));
        }
        UpdateCycle.unregisterTask("BetterNations.MapUpdate");
        MapDisplayManager.reload();
        UpdateCycle.registerTask("BetterNations.MapUpdate", new UpdateTask(Config.getInt("bluemap.check-interval"), MapDisplayManager::update));
        UpdateCycle.unregisterTask("BetterNations.ArmyUpdate");
        UpdateCycle.registerTask("BetterNations.ArmyUpdate", new UpdateTask(Config.getInt("combat.army-tick-interval") * 20, new ArmyUpdateManager()));
        ArmyUpdateManager.nextUpdate = System.currentTimeMillis() + 1000L * (long)Config.getInt("combat.army-tick-interval");
        for (AbstractStructure i : AbstractStructure.structures.values()) {
            i.updateHologram();
        }
    }

    public void onDisable() {
        ArrayList<Exception> throwables = new ArrayList<Exception>();
        for (TransportArmy transportArmy : new ArrayList<TransportArmy>(TransportArmy.transportArmyMap.values())) {
            try {
                SimpleLocation loc = transportArmy.mob.getLocation().getBlockLocation();
                while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
                    loc = loc.getRelative(0.0, 1.0, 0.0);
                }
                if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) continue;
                ArmyCamp c = new ArmyCamp();
                transportArmy.unregister();
                c.stack = transportArmy.stack;
                c.location = loc;
                transportArmy.stack.curHolder = c;
                c.place();
                transportArmy.mob.remove();
            }
            catch (Exception e) {
                throwables.add(e);
            }
        }
        for (GUISession gUISession : new ArrayList<GUISession>(GUISession.sessions.values())) {
            gUISession.close();
        }
        if (ToggleArmyUpdateCommand.bossBar != null) {
            ToggleArmyUpdateCommand.bossBar.removeAll();
        }
        MapDisplayManager.unload();
        for (BreakCampRunnable breakCampRunnable : BreakCampRunnable.breakingPlayers.values()) {
            try {
                breakCampRunnable.failed();
            }
            catch (Exception e) {
                throwables.add(e);
            }
        }
        for (Collection collection : new ArrayList<Set<Hologram>>(Hologram.holograms.values())) {
            for (Hologram j : collection) {
                try {
                    j.despawn();
                }
                catch (Exception e) {
                    throwables.add(e);
                }
            }
        }
        try {
            storage.save();
        }
        catch (Exception e) {
            throwables.add(e);
        }
        PlanetLib.shutdown();
        if (!throwables.isEmpty()) {
            Bukkit.getLogger().severe("Encountered " + throwables.size() + " errors while attempting to shut down BetterNations!");
            Bukkit.getLogger().severe("Below is one of them:");
            ((Throwable)throwables.get(0)).printStackTrace();
        }
    }
}

