/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army;

import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.army.DamageSource;
import cn.jason31416.betternations.army.Damageable;
import cn.jason31416.betternations.army.states.ArmyStackHolder;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ArmyStack
implements Damageable,
DamageSource {
    public Map<ArmyType, Unit> armies = new HashMap<ArmyType, Unit>();
    public Nation nation;
    public ArmyStackHolder curHolder = null;
    public double supply;
    public Queue<Object> damageQueue = new ArrayDeque<Object>();

    public ArmyStack(Nation nation) {
        this.nation = nation;
    }

    public void addArmy(ArmyType type, Integer count, Double health) {
        if (this.armies.containsKey(type)) {
            this.armies.get((Object)type).count += count.intValue();
            this.armies.get((Object)type).hp += health.doubleValue();
        } else {
            this.armies.put(type, new Unit(type, count, health));
        }
    }

    public void addArmy(ArmyType type, Integer count) {
        if (this.armies.containsKey(type)) {
            this.armies.get((Object)type).count += count.intValue();
            this.armies.get((Object)type).hp += type.health * (double)count.intValue();
        } else {
            this.armies.put(type, new Unit(type, count));
        }
    }

    public void addArmy(Unit unit) {
        if (this.armies.containsKey(unit.type)) {
            this.armies.get((Object)unit.type).count += unit.count;
            this.armies.get((Object)unit.type).hp += unit.hp;
        } else {
            this.armies.put(unit.type, unit.copy());
        }
    }

    public boolean removeArmy(ArmyType armyType, Integer count) {
        if (this.armies.containsKey(armyType)) {
            if (this.armies.get((Object)armyType).count > count) {
                this.armies.get((Object)armyType).count -= count.intValue();
            } else if (this.armies.get((Object)armyType).count == count) {
                this.armies.remove(armyType);
            } else {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean removeArmyStack(ArmyStack group) {
        boolean bb = true;
        for (ArmyType i : group.armies.keySet()) {
            bb &= this.removeArmy(i, group.armies.get((Object)i).count);
        }
        this.supply -= group.supply;
        return bb;
    }

    public void addArmyStack(ArmyStack group) {
        this.supply += group.supply;
        for (ArmyType i : group.armies.keySet()) {
            this.addArmy(group.armies.get(i));
        }
    }

    public int size() {
        int count = 0;
        for (ArmyType i : this.armies.keySet()) {
            count += this.armies.get((Object)i).count;
        }
        return count;
    }

    public double getMaxSupply() {
        double total = 0.0;
        for (ArmyType i : this.armies.keySet()) {
            total += i.maxSupply * (double)this.armies.get((Object)i).count;
        }
        return total;
    }

    public double getSupplyConsumption() {
        double total = 0.0;
        for (ArmyType i : this.armies.keySet()) {
            total += i.consumption * (double)this.armies.get((Object)i).count;
        }
        return total;
    }

    public double getMaxHealth() {
        double hp = 0.0;
        for (ArmyType i : this.armies.keySet()) {
            hp += (double)this.armies.get((Object)i).count * i.health;
        }
        return hp;
    }

    @Override
    public double getHealth() {
        double hp = 0.0;
        for (ArmyType i : this.armies.keySet()) {
            hp += this.armies.get((Object)i).hp;
        }
        return hp;
    }

    public void displayGUI(GUI gui, int starting, int ending) {
        int pos = starting;
        for (ArmyType type : this.armies.keySet()) {
            if (pos >= ending) {
                return;
            }
            gui.addItem("army-" + pos, pos, this.armies.get(type).getItemStack());
            if (++pos % 9 != 8) continue;
            pos += 2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBreaking() {
        ArmyStackHolder armyStackHolder = this.curHolder;
        if (!(armyStackHolder instanceof StructuredArmy)) return false;
        StructuredArmy sa = (StructuredArmy)armyStackHolder;
        if (sa.runnable == null) return false;
        return true;
    }

    public void processDamageQueue() {
        if (this.isBreaking()) {
            return;
        }
        while (!this.damageQueue.isEmpty()) {
            Object item = this.damageQueue.poll();
            if (item instanceof Double) {
                Double dmg = (Double)item;
                this.damage(dmg);
                continue;
            }
            if (!(item instanceof DamageSource)) continue;
            DamageSource dmg = (DamageSource)item;
            this.damage(dmg);
        }
    }

    public String getStackName() {
        return Message.getMessage("combat.stack-name").add("nation", this.nation.getName()).add("count", this.size()).toString();
    }

    public ItemStack getItemDisplay(double supplygain) {
        if (this.armies.isEmpty()) {
            GUI.Item ret = new GUI.Item("");
            ret.setMaterial(Material.BARRIER).setName(" ");
            return ret.toBukkitItem();
        }
        GUI.Item ret = new GUI.Item("");
        ret.setMaterial(((ArmyType)this.armies.keySet().stream().toList().get((int)0)).icon).setName(this.getStackName()).setLore(this.getLore(supplygain));
        return ret.toBukkitItem();
    }

    public List<String> getLore(double supplygain) {
        return MessageLoader.getList("combat.stack-lore").add("health", (double)Math.round(this.getHealth() * 10.0) / 10.0).add("max_health", this.getMaxHealth()).add("supply", (double)Math.round(this.supply * 100.0) / 100.0).add("max_supply", this.getMaxSupply()).add("supply_change", (this.getSupplyConsumption() <= 0.0 ? "&a+" : "&c-") + Math.abs(Math.round((this.getSupplyConsumption() - supplygain) * 100.0) / 100L)).add("nation", this.nation.getColorTag() + this.nation.getName()).add("damage_unarmed", this.getDamageTowards(ArmorType.UNARMED)).add("damage_armored", this.getDamageTowards(ArmorType.ARMORED)).add("damage_territory", this.getDamageTowards(ArmorType.TERRITORY)).asList();
    }

    public ItemStack getItemDisplay() {
        return this.getItemDisplay(0.0);
    }

    @Override
    public void damage(double dmg) {
        if (this.isBreaking()) {
            return;
        }
        double div = this.size();
        for (ArmyType i : new ArrayList<ArmyType>(this.armies.keySet())) {
            Unit unit = this.armies.get(i);
            unit.hp -= dmg * (double)unit.count / div;
            while (unit.hp <= (double)(unit.count - 1) * i.health) {
                --unit.count;
            }
            if (unit.count > 0) continue;
            this.armies.remove(i);
        }
    }

    @Override
    public void damage(DamageSource source) {
        if (this.isBreaking()) {
            return;
        }
        double div = this.size();
        for (ArmyType i : new ArrayList<ArmyType>(this.armies.keySet())) {
            Unit unit = this.armies.get(i);
            unit.hp -= source.getDamageTowards(i.armorType) * (double)unit.count / div;
            while (unit.hp <= (double)(unit.count - 1) * i.health) {
                --unit.count;
            }
            if (unit.count > 0) continue;
            this.armies.remove(i);
        }
    }

    public SimpleLocation getLocation() {
        return this.curHolder.getLocation();
    }

    @Override
    public boolean isAlive() {
        return this.armies.isEmpty();
    }

    @Override
    public double getDamageTowards(ArmorType type) {
        PriorityQueue<Double> minHeap = new PriorityQueue<Double>(10);
        block0: for (ArmyType i : this.armies.keySet()) {
            Double dmg = i.attack.get((Object)type);
            if (dmg == null) continue;
            for (int j = 0; j < this.armies.get((Object)i).count; ++j) {
                if (minHeap.size() < Config.getInt("combat.damage-units", 10) || minHeap.isEmpty()) {
                    minHeap.offer(dmg);
                    continue;
                }
                if (!(dmg > (Double)minHeap.peek())) continue block0;
                minHeap.poll();
                minHeap.offer(dmg);
            }
        }
        double sum = 0.0;
        while (!minHeap.isEmpty()) {
            sum += ((Double)minHeap.poll()).doubleValue();
        }
        return sum;
    }

    public boolean serialize(IDataItem dataItem) {
        if (!Nation.nations.containsValue(this.nation)) {
            return false;
        }
        ArrayList<CallSite> armyList = new ArrayList<CallSite>();
        for (ArmyType i : this.armies.keySet()) {
            armyList.add((CallSite)((Object)(i.id + ":" + this.armies.get((Object)i).count + ":" + this.armies.get((Object)i).hp)));
        }
        dataItem.set("a_bel", this.nation.getId().toString());
        dataItem.set("a_cont", String.join((CharSequence)";", armyList));
        dataItem.set("a_sup", this.supply);
        return true;
    }

    public static ArmyStack deserialize(IDataItem dataItem) {
        ArmyStack stack = new ArmyStack(Nation.getNation(UUID.fromString(dataItem.getString("a_bel"))));
        stack.supply = dataItem.getDouble("a_sup");
        for (String i : dataItem.getString("a_cont").split(";")) {
            if (i.isEmpty()) continue;
            String[] unit_string = i.split(":");
            if (ArmyType.armyTypes.containsKey(unit_string[0])) {
                stack.addArmy(ArmyType.armyTypes.get(unit_string[0]), Integer.parseInt(unit_string[1]), Double.parseDouble(unit_string[2]));
                continue;
            }
            Bukkit.getLogger().severe("Error loading armystack: Army type not found! Please check your configuration.");
        }
        return stack;
    }

    public static class Unit {
        public ArmyType type;
        public int count;
        public double hp;

        public Unit(ArmyType type, int count) {
            this.type = type;
            this.count = count;
            this.hp = type.health * (double)count;
        }

        public Unit(ArmyType type, int count, double hp) {
            this.type = type;
            this.count = count;
            this.hp = hp;
        }

        public ItemStack getItemStack() {
            GUI.Item item = new GUI.Item("unit");
            item.setName(new StringMessage("&f" + this.type.name + " &7x" + this.count).toString());
            item.setQuantity(this.count);
            item.setLore(MessageLoader.getList("combat.unit.item-lore").add("health", (double)Math.round(this.hp * 10.0) / 10.0).add("max_health", (double)this.count * this.type.health).asList());
            item.setMaterial(this.type.icon);
            return item.toBukkitItem();
        }

        public Unit copy() {
            return new Unit(this.type, this.count, this.hp);
        }
    }
}

