/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.manager.ArmyUpdateManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.Hologram;
import cn.jason31416.planetlib.ColorUtils;
import cn.jason31416.planetlib.Utils;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SiegeFlag
extends StructuredArmy {
    public Town target;

    public SiegeFlag() {
    }

    public SiegeFlag(Town target) {
        this.target = target;
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        if (!this.target.isAlive()) {
            return false;
        }
        dataItem.set("targ", this.target.getId().toString());
        return super.serialize(dataItem);
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        super.deserialize(dataItem);
        this.target = Town.getTown(UUID.fromString(dataItem.getString("targ")));
    }

    @Override
    public String getHologramText() {
        return Message.getMessage("combat.siege-name").add("nation", this.stack.nation.getColorTag() + this.stack.nation.getName()).add("units", this.stack.size()).add("town", this.target.getNation().getColorTag() + this.target.getName()).toString();
    }

    @Override
    public void place() {
        this.location.setBlockMaterial(this.getMaterial());
        this.hologram = Hologram.createHologram(SimpleLocation.of(this.location.getBlock().getLocation().add(0.5, 2.3, 0.5)), this.getHologramText());
        this.register();
    }

    @Override
    public Material getMaterial() {
        return ColorUtils.getClosest(this.stack.nation.getColor()).banner();
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (type == AbstractStructure.InteractionType.INTERACT) {
            final SiegeFlag siege = this;
            new GUISession(player){

                @Override
                public void constructGUI(final String guiID, final GUI gui) {
                    gui.placeholder("town", SiegeFlag.this.target.getName());
                    switch (guiID) {
                        case "siege-main": {
                            SiegeFlag.this.stack.displayGUI(gui, 28, 44);
                            gui.getItems("army-overview").setItemStack(SiegeFlag.this.stack.getItemDisplay(ArmyCamp.supplyGain(SiegeFlag.this.location.getChunkLocation(), SiegeFlag.this.stack.nation)));
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            if (this.player.getNation() == SiegeFlag.this.stack.nation && this.player.hasPermission(Permission.MANAGE_ARMY)) {
                                gui.getItems("action-page").setClickHandler(new GUI.SwitchGuiRunnable("siege-actions"));
                            } else {
                                gui.getItems("action-page").setMaterial(Material.BARRIER);
                            }
                            double mxhp = SiegeFlag.this.target.getMaxHealth();
                            double chunkhp = SiegeFlag.this.target.getHealth();
                            if (chunkhp > mxhp) {
                                return;
                            }
                            int cnt = (int)((mxhp - chunkhp) * 5.0 / mxhp);
                            for (int i = 0; i < 7; ++i) {
                                int pos = i + 10;
                                if (i < cnt) {
                                    gui.addItem("prog-" + i, " ", pos, Material.RED_STAINED_GLASS_PANE, 1);
                                    continue;
                                }
                                if (i == cnt) {
                                    gui.addItem("prog-" + i, Message.getMessage("combat.progress.invasion.attack.name").add("attacker", SiegeFlag.this.stack.nation.getColorTag() + SiegeFlag.this.stack.nation.getName()).toString(), pos, Material.IRON_SWORD, 1).setLore(MessageLoader.getList("combat.progress.invasion.attack.lore").add("next_attack", Utils.formatSeconds((int)((ArmyUpdateManager.nextUpdate - System.currentTimeMillis()) / 1000L))).add("health", (double)Math.round(SiegeFlag.this.stack.getHealth() * 10.0) / 10.0).add("damage", SiegeFlag.this.stack.getDamageTowards(ArmorType.TERRITORY)).asList());
                                    continue;
                                }
                                if (i == cnt + 1) {
                                    Nation nation = SiegeFlag.this.target.getNation();
                                    if (nation == null) continue;
                                    gui.addItem("prog-" + i, Message.getMessage("combat.progress.invasion.town.name").add("defender", nation.getColorTag() + nation.getName()).add("town", SiegeFlag.this.target.getName()).toString(), pos, Material.SHIELD, 1).setLore(MessageLoader.getList("combat.progress.invasion.town.lore").add("health", chunkhp).add("max_health", mxhp).asList());
                                    continue;
                                }
                                gui.addItem("prog-" + i, " ", pos, Material.BLUE_STAINED_GLASS_PANE, 1);
                            }
                            new BukkitRunnable(){

                                public void run() {
                                    if (!GUISession.sessions.containsKey(player) || GUISession.sessions.get((Object)player).gui != gui) {
                                        return;
                                    }
                                    if (!siege.running) {
                                        player.getPlayer().closeInventory();
                                        return;
                                    }
                                    int pos = 28;
                                    while (pos < 44) {
                                        gui.container.remove(pos);
                                        if (++pos % 9 != 8) continue;
                                        pos += 2;
                                    }
                                    this.constructGUI(guiID, gui);
                                    gui.update();
                                }
                            }.runTaskLater((Plugin)BetterNations.instance, 4L);
                        }
                        case "siege-actions": {
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            if (SiegeFlag.this.isInCombat()) {
                                gui.getItems("extract").setMaterial(Material.BARRIER);
                            }
                            gui.getItems("extract").setClickHandler((session, action, evt) -> {
                                if (SiegeFlag.this.isInCombat()) {
                                    Message.getMessage("combat.cannot-move-unit-during-combat").send(this.player);
                                    session.close();
                                    return;
                                }
                                if (SiegeFlag.this.stack.curHolder == siege) {
                                    TransportArmy.spawn(SiegeFlag.this.location, this.player, SiegeFlag.this.stack);
                                    siege.breakStructure();
                                    siege.unregister();
                                    session.close();
                                }
                            });
                        }
                    }
                }
            }.display("siege-main");
        } else if (type == AbstractStructure.InteractionType.BREAK) {
            if (this.stack.nation.getRelation(player.getNation()) == Relation.ENEMY && this.runnable == null) {
                player.sendMessage(Message.getMessage("combat.cannot-break-camps-in-nation"));
            }
            return false;
        }
        return true;
    }

    public void convertToCamp() {
        ArmyCamp camp = new ArmyCamp();
        camp.stack = this.stack;
        camp.location = this.location;
        this.breakStructure();
        this.unregister();
        camp.place();
    }
}

