/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.BreakCampRunnable;
import cn.jason31416.betternations.army.states.ArmyStackHolder;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.manager.FromToAnimationManager;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.types.Granary;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Color;

public abstract class StructuredArmy
extends AbstractStructure
implements ArmyStackHolder {
    public static Map<SimpleChunkLocation, Set<StructuredArmy>> armyLocationMap = new HashMap<SimpleChunkLocation, Set<StructuredArmy>>();
    public ArmyStack stack;
    public BreakCampRunnable runnable = null;
    public boolean running = true;

    @Override
    public void register() {
        super.register();
        if (!armyLocationMap.containsKey(this.location.getChunkLocation())) {
            armyLocationMap.put(this.location.getChunkLocation(), new HashSet());
        }
        for (StructuredArmy structuredArmy : armyLocationMap.get(this.location.getChunkLocation())) {
            if (!structuredArmy.running || structuredArmy.getStack().nation.getRelation(this.stack.nation) != Relation.ENEMY) continue;
            new FromToAnimationManager(this, structuredArmy, Color.RED);
            new FromToAnimationManager(structuredArmy, this, Color.RED);
        }
        if (this.stack.nation.getRelation(this.location.getChunkLocation().getNation()) == Relation.ALLY && Granary.granaries.containsKey(this.location.getChunkLocation())) {
            for (Granary granary : Granary.granaries.get(this.location.getChunkLocation())) {
                new FromToAnimationManager(granary, this, Color.YELLOW);
            }
        }
        armyLocationMap.get(this.location.getChunkLocation()).add(this);
        this.stack.curHolder = this;
    }

    @Override
    public void unregister() {
        super.unregister();
        this.running = false;
        if (armyLocationMap.containsKey(this.location.getChunkLocation())) {
            armyLocationMap.get(this.location.getChunkLocation()).remove(this);
            if (armyLocationMap.get(this.location.getChunkLocation()).isEmpty()) {
                armyLocationMap.remove(this.location.getChunkLocation());
            }
        }
    }

    public boolean isInCombat() {
        for (StructuredArmy i : armyLocationMap.get(this.location.getChunkLocation())) {
            if (!i.running || i.getStack().nation.getRelation(this.stack.nation) != Relation.ENEMY) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArmyStack getStack() {
        return this.stack;
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        if (!this.stack.nation.exists()) {
            return false;
        }
        this.stack.serialize(dataItem);
        return true;
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        this.stack = ArmyStack.deserialize(dataItem);
    }

    @Override
    public SimpleLocation getLocation() {
        return this.location;
    }

    public static boolean isInvasionChunk(SimpleChunkLocation chunk) {
        if (!armyLocationMap.containsKey(chunk)) {
            return false;
        }
        for (StructuredArmy i : armyLocationMap.get(chunk)) {
            if (!(i instanceof InvasionFlag) && !(i instanceof SiegeFlag)) continue;
            return true;
        }
        return false;
    }
}

