/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.misc;

import cn.jason31416.betternations.manager.ItemCraftingManager;
import cn.jason31416.betternations.structure.types.Machinery;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.item.CustomItemType;
import cn.jason31416.planetlib.item.ItemType;
import cn.jason31416.planetlib.item.SimpleCraftingRecipe;
import cn.jason31416.planetlib.item.SimpleFurnaceRecipe;
import cn.jason31416.planetlib.item.SimpleRecipe;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryAction;
import org.jetbrains.annotations.Nullable;

public class CraftingGuideCommand
extends ChildCommand {
    public CraftingGuideCommand(IParentCommand parent) {
        super(List.of("recipe", "guide"), parent);
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        if (context.getPlayer() == null) {
            return null;
        }
        SimplePlayer player = context.getPlayer();
        GUISession session = new GUISession(player){
            int page;
            int recipePage;
            int catpage;
            CustomItemType selectedType;
            String curCat;
            {
                this.page = 0;
                this.recipePage = 0;
                this.catpage = 0;
                this.selectedType = null;
                this.curCat = "";
            }

            @Override
            public void constructGUI(String guiID, GUI gui) {
                block5 : switch (guiID) {
                    case "item-categories": {
                        int totalpages = ItemCraftingManager.itemTypes.size() / 28 + 1;
                        if (this.catpage < totalpages - 1) {
                            gui.getItems("nextpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                ++this.catpage;
                                this.constructGUI(guiID, gui);
                            });
                        } else {
                            gui.getItems("nextpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                        }
                        if (this.catpage > 0) {
                            gui.getItems("prevpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                --this.catpage;
                                this.constructGUI(guiID, gui);
                            });
                        } else {
                            gui.getItems("prevpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                        }
                        gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                        List<ItemCraftingManager.ItemCategory> cats = new ArrayList<ItemCraftingManager.ItemCategory>(ItemCraftingManager.itemTypes.values()).subList(this.page * 28, Math.min(ItemCraftingManager.itemTypes.size(), this.page * 28 + 28));
                        int cur = 0;
                        for (int i = 10; i < 44; ++i) {
                            if (i % 9 == 8) {
                                i += 2;
                            }
                            if (cur >= cats.size()) break block5;
                            ItemCraftingManager.ItemCategory t = cats.get(cur);
                            gui.addItem("item-" + i, new StringMessage(t.displayName).toString(), i, t.material, 1);
                            gui.getItems("item-" + i).setClickHandler((session, action, event) -> {
                                this.curCat = t.catid;
                                this.page = 0;
                                session.display("custom-items");
                            });
                            ++cur;
                        }
                        break;
                    }
                    case "custom-items": {
                        gui.placeholder("category", new StringMessage(ItemCraftingManager.itemTypes.get((Object)this.curCat).displayName).toFormatted());
                        List<CustomItemType> customItemTypes = ItemCraftingManager.itemTypes.get((Object)this.curCat).types;
                        int totalpages = customItemTypes.size() / 28 + 1;
                        if (this.page < totalpages - 1) {
                            gui.getItems("nextpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                ++this.page;
                                this.constructGUI(guiID, gui);
                            });
                        } else {
                            gui.getItems("nextpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                        }
                        if (this.page > 0) {
                            gui.getItems("prevpage").setMaterial(Material.LIME_STAINED_GLASS_PANE).setClickHandler((session, action, event) -> {
                                --this.page;
                                this.constructGUI(guiID, gui);
                            });
                        } else {
                            gui.getItems("prevpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE).setName(" ");
                        }
                        gui.getItems("close").setClickHandler((session, action, event) -> session.display("item-categories"));
                        List<CustomItemType> types = customItemTypes.subList(this.page * 28, Math.min(customItemTypes.size(), this.page * 28 + 28));
                        int cur = 0;
                        for (int i = 10; i < 44; ++i) {
                            if (i % 9 == 8) {
                                i += 2;
                            }
                            if (cur >= types.size()) break block5;
                            CustomItemType t = types.get(cur);
                            GUI.Item itm = gui.addItem("item-" + i, t.displayName, i, t.material, 1).setLore(t.lore);
                            if (t.glow) {
                                itm.setGlow(true);
                            }
                            if (!t.enchantments.isEmpty()) {
                                itm.enchantments = new HashMap<Enchantment, Integer>(t.enchantments);
                            }
                            if (t.customModelData != 0) {
                                itm.setCustomModelData(t.customModelData);
                            }
                            if (t.skullValue != null) {
                                itm.setSkullID(t.skullValue);
                            }
                            int c = cur++;
                            gui.getItems("item-" + i).setClickHandler((session, action, event) -> {
                                if (action == InventoryAction.PICKUP_ALL) {
                                    if (ItemCraftingManager.recipes.get(types.get(c)) != null) {
                                        this.selectedType = t;
                                        this.recipePage = 0;
                                        session.display("recipe-display");
                                    }
                                } else if (action == InventoryAction.PICKUP_HALF && this.player.getPlayer().isOp()) {
                                    this.player.getPlayer().setItemOnCursor(t.getItemStack(1));
                                } else if (action == InventoryAction.SWAP_WITH_CURSOR && this.player.getPlayer().isOp() && ItemType.getItemType(this.player.getPlayer().getItemOnCursor()) == t && this.player.getPlayer().getItemOnCursor().getAmount() < t.material.getMaxStackSize()) {
                                    this.player.getPlayer().getItemOnCursor().setAmount(this.player.getPlayer().getItemOnCursor().getAmount() + 1);
                                }
                            });
                        }
                        break;
                    }
                    case "recipe-display": {
                        if (this.selectedType == null) {
                            return;
                        }
                        List<SimpleRecipe> recipes = ItemCraftingManager.recipes.get(this.selectedType);
                        if (recipes == null || this.recipePage >= recipes.size()) {
                            return;
                        }
                        gui.placeholder("item", new StringMessage(this.selectedType.displayName).toFormatted());
                        gui.placeholder("category", new StringMessage(ItemCraftingManager.itemTypes.get((Object)this.curCat).displayName).toFormatted());
                        if (this.recipePage < recipes.size() - 1) {
                            gui.getItems("nextpage").setClickHandler((session, action, event) -> {
                                ++this.recipePage;
                                session.display("recipe-display");
                            });
                        } else {
                            gui.getItems("nextpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE);
                        }
                        if (this.recipePage > 0) {
                            gui.getItems("prevpage").setClickHandler((session, action, event) -> {
                                --this.recipePage;
                                session.display("recipe-display");
                            });
                        } else {
                            gui.getItems("prevpage").setMaterial(Material.BLACK_STAINED_GLASS_PANE);
                        }
                        gui.getItems("product").setItemStack(recipes.get(this.recipePage).getProduct());
                        gui.getItems("back").setClickHandler((session, action, event) -> session.display("custom-items"));
                        SimpleRecipe i = recipes.get(this.recipePage);
                        if (i instanceof SimpleCraftingRecipe) {
                            SimpleCraftingRecipe recipe = (SimpleCraftingRecipe)i;
                            gui.getItems("process").setName(Message.getMessage("item.recipe.crafting.name").toString()).setMaterial(Material.CRAFTING_TABLE).setLore(MessageLoader.getList("item.recipe.crafting.lore").asList());
                            List<List<ItemType>> rcp = recipe.recipe;
                            for (int i2 = 0; i2 < rcp.size(); ++i2) {
                                for (int j = 0; j < rcp.get(i2).size(); ++j) {
                                    if (rcp.get(i2).get(j).getMaterial() == Material.AIR) {
                                        gui.getItems("slot" + (i2 + 1) + "-" + (j + 1)).setMaterial(Material.AIR);
                                        continue;
                                    }
                                    gui.getItems("slot" + (i2 + 1) + "-" + (j + 1)).setItemStack(rcp.get(i2).get(j).getItemStack());
                                    ItemType itemType = rcp.get(i2).get(j);
                                    if (!(itemType instanceof CustomItemType)) continue;
                                    CustomItemType rc = (CustomItemType)itemType;
                                    gui.getItems("slot" + (i2 + 1) + "-" + (j + 1)).setClickHandler((session, action, clicktype) -> {
                                        this.selectedType = rc;
                                        this.recipePage = 0;
                                        session.display("recipe-display");
                                    });
                                }
                            }
                            break;
                        }
                        SimpleRecipe simpleRecipe = recipes.get(this.recipePage);
                        if (simpleRecipe instanceof SimpleFurnaceRecipe) {
                            SimpleFurnaceRecipe recipe = (SimpleFurnaceRecipe)simpleRecipe;
                            gui.getItems("process").setName(Message.getMessage("item.recipe.smelting.name").toString()).setMaterial(Material.FURNACE).setLore(MessageLoader.getList("item.recipe.smelting.lore").add("smelting-time", (double)recipe.recipe.getCookingTime() / 20.0).asList());
                            gui.getItems("slot2-2").setItemStack(recipe.recipe.getInput());
                            gui.getItems("slot2-2").setClickHandler((session, action, clicktype) -> {
                                ItemType patt11570$temp = ItemType.getItemType(recipe.recipe.getInput());
                                if (patt11570$temp instanceof CustomItemType) {
                                    CustomItemType tp;
                                    this.selectedType = tp = (CustomItemType)patt11570$temp;
                                    this.recipePage = 0;
                                    session.display("recipe-display");
                                }
                            });
                            gui.getItems("slot1-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot1-2").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot1-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot2-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot2-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot3-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot3-2").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            gui.getItems("slot3-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                            break;
                        }
                        simpleRecipe = recipes.get(this.recipePage);
                        if (!(simpleRecipe instanceof Machinery.Recipe)) break;
                        Machinery.Recipe recipe = (Machinery.Recipe)simpleRecipe;
                        gui.getItems("process").setName(Message.getMessage("structure." + recipe.machineryType + ".hologram").toString()).setMaterial(Machinery.materialMap.get(recipe.machineryType)).setLore(MessageLoader.getList("item.recipe.machinery.lore").add("time", recipe.duration).asList());
                        gui.getItems("slot2-2").setItemStack(recipe.ingredient.getItemStack());
                        gui.getItems("slot2-2").setClickHandler((session, action, clicktype) -> {
                            ItemType patt13565$temp = ItemType.getItemType(recipe.ingredient.getItemStack());
                            if (patt13565$temp instanceof CustomItemType) {
                                CustomItemType tp;
                                this.selectedType = tp = (CustomItemType)patt13565$temp;
                                this.recipePage = 0;
                                session.display("recipe-display");
                            }
                        });
                        gui.getItems("slot1-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot1-2").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot1-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot2-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot2-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot3-1").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot3-2").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        gui.getItems("slot3-3").setMaterial(Material.WHITE_STAINED_GLASS_PANE);
                        break;
                    }
                }
            }
        };
        session.display("item-categories");
        return null;
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        return null;
    }
}

