/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.resolution;

import cn.jason31416.betternations.nation.resolution.AbstractResolution;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.command.ParameterType;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageList;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResolutionInfoCommand
extends ChildCommand {
    public ResolutionInfoCommand(IParentCommand parent) {
        super("info", parent);
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        SimplePlayer player = context.getPlayer();
        if (player == null || !context.checkArgs(ParameterType.STRING)) {
            return null;
        }
        if (player.getNation() == null) {
            return Message.getMessage("command.failed.player-not-in-nation");
        }
        String id = context.getArg(0);
        AbstractResolution resolution = player.getNation().resolutions.get(id);
        if (resolution == null) {
            return Message.getMessage("command.failed.resolution-not-found");
        }
        MessageList message = resolution.requiredSigners.contains(player) ? MessageLoader.getList("nation.resolution.info").add("proposer", resolution.proposer.getName()).add("nation", resolution.nation.getName()).add("resolution_id", resolution.resolutionId).add("content", resolution.getResolutionContent().toFormatted()).add("signed_players", String.join((CharSequence)",", resolution.signedPlayers.stream().map(SimplePlayer::getName).toList())).add("signed_players_count", "" + resolution.signedPlayers.size()).add("required_signers", (int)Math.max(Math.ceil((double)resolution.requiredSigners.size() * resolution.requiredRatio), (double)resolution.minimalSigners)) : MessageLoader.getList("nation.resolution.info-no-permission").add("proposer", resolution.proposer.getName()).add("nation", resolution.nation.getName()).add("resolution_id", resolution.resolutionId).add("content", resolution.getResolutionContent().toFormatted()).add("signed_players", String.join((CharSequence)",", resolution.signedPlayers.stream().map(SimplePlayer::getName).toList())).add("signed_players_count", "" + resolution.signedPlayers.size()).add("required_signers", (int)Math.max(Math.ceil((double)resolution.requiredSigners.size() * resolution.requiredRatio), (double)Math.min(resolution.minimalSigners, resolution.requiredSigners.size())));
        message.send(player);
        return null;
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        return List.of("<id>");
    }
}

