/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.manager.HistoricalBroadcastManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.structure.types.Granary;
import cn.jason31416.betternations.structure.types.Outpost;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.update.UpdateTask;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ArmyUpdateManager
implements UpdateTask.RunnableTask {
    public static Map<SimpleChunkLocation, Double> chunkHealths = new HashMap<SimpleChunkLocation, Double>();
    public static long nextUpdate = 0L;

    private void checkChunkAfterInvasion(SimpleChunkLocation origchunk, final Nation winner, final Nation loser) {
        final HashSet encircled = new HashSet();
        block0: for (SimpleChunkLocation adj : origchunk.getAdjacentChunks()) {
            if (adj.getNation() != loser || encircled.contains(adj)) continue;
            ArrayDeque<SimpleChunkLocation> chunks = new ArrayDeque<SimpleChunkLocation>();
            HashSet<SimpleChunkLocation> searched = new HashSet<SimpleChunkLocation>();
            chunks.add(adj);
            searched.add(adj);
            int cnt = 0;
            while (!chunks.isEmpty()) {
                SimpleChunkLocation cur = (SimpleChunkLocation)chunks.poll();
                if (cur.isTownChunk() || Outpost.outposts.contains(cur)) continue block0;
                for (SimpleChunkLocation c : cur.getAdjacentChunks()) {
                    if (c.getNation() != loser || searched.contains(c)) continue;
                    chunks.add(c);
                    searched.add(c);
                }
                ++cnt;
            }
            encircled.addAll(searched);
        }
        new BukkitRunnable(){

            public void run() {
                for (SimpleChunkLocation i : encircled) {
                    loser.forceUnclaim(i);
                    winner.claim(i);
                }
            }
        }.runTaskLater((Plugin)BetterNations.instance, 0L);
    }

    @Override
    public void run() {
        if (Config.getBoolean("combat.enable-supply-system")) {
            new BukkitRunnable(){

                public void run() {
                    for (TransportArmy army : new HashSet<TransportArmy>(TransportArmy.transportArmyMap.values())) {
                        army.stack.supply -= army.stack.getSupplyConsumption() * 2.0;
                        if (!(army.stack.supply <= 0.0)) continue;
                        army.destroy(true);
                    }
                }
            }.runTaskLater((Plugin)BetterNations.instance, 0L);
        }
        for (Town town : Town.towns.values()) {
            town.townHealth = Math.min(town.townHealth + Config.getDouble("town.hp-recover-speed"), town.getMaxHealth());
        }
        for (final SimpleChunkLocation chunk : new HashSet<SimpleChunkLocation>(StructuredArmy.armyLocationMap.keySet())) {
            try {
                Set<StructuredArmy> armies = StructuredArmy.armyLocationMap.get(chunk);
                for (StructuredArmy army : armies) {
                    if (Config.getBoolean("combat.enable-supply-system")) {
                        army.stack.supply -= army.stack.getSupplyConsumption();
                        if (army.stack.nation.getRelation(chunk.getNation()) == Relation.ALLY && Granary.granaries.containsKey(chunk)) {
                            for (Granary granary : Granary.granaries.get(chunk)) {
                                if (granary.supply <= 0.0) continue;
                                double t = Math.min(army.stack.getMaxSupply() - army.stack.supply, Math.min(Config.getDouble("combat.supply-regain-speed"), granary.supply));
                                granary.supply -= t;
                                army.stack.supply += t;
                                granary.updateHologram();
                            }
                        }
                    }
                    for (StructuredArmy structuredArmy : armies) {
                        if (structuredArmy.stack.nation.getRelation(army.stack.nation) != Relation.ENEMY) continue;
                        army.stack.damage(structuredArmy.stack);
                    }
                    if (!(army instanceof SiegeFlag)) continue;
                    SiegeFlag siege = (SiegeFlag)army;
                    for (SimpleChunkLocation townChunks : siege.target.getTownChunks()) {
                        if (!StructuredArmy.armyLocationMap.containsKey(townChunks)) continue;
                        for (StructuredArmy otherArmy : StructuredArmy.armyLocationMap.get(townChunks)) {
                            if (otherArmy.stack.nation.getRelation(siege.stack.nation) != Relation.ENEMY) continue;
                            otherArmy.stack.damage(siege.stack);
                            siege.stack.damage(otherArmy.stack);
                        }
                    }
                }
                for (StructuredArmy army : new HashSet<StructuredArmy>(armies)) {
                    army.hologram.setText(army.getHologramText());
                    if (army.stack.nation.exists() && (army.stack.size() > 0 && !(army.stack.supply <= 0.0) || army.runnable != null)) continue;
                    army.breakStructure();
                    army.unregister();
                }
                for (StructuredArmy army : new HashSet<StructuredArmy>(armies)) {
                    Town town;
                    if (army instanceof InvasionFlag) {
                        InvasionFlag invasion = (InvasionFlag)army;
                        if (!chunk.isClaimed() || chunk.isTownChunk() || army.stack.nation.getRelation(chunk.getNation()) != Relation.ENEMY) {
                            invasion.convertToCamp();
                            continue;
                        }
                        if (!chunkHealths.containsKey(chunk)) {
                            chunkHealths.put(chunk, Config.getDouble("combat.chunk-hp", 20.0));
                        }
                        chunkHealths.put(chunk, chunkHealths.get(chunk) - invasion.stack.getDamageTowards(ArmorType.TERRITORY));
                        continue;
                    }
                    if (army instanceof SiegeFlag) {
                        final SiegeFlag siegeFlag = (SiegeFlag)army;
                        new BukkitRunnable(){

                            public void run() {
                                block3: {
                                    if (siegeFlag.target == null || siegeFlag.stack.nation.getRelation(siegeFlag.target.getNation()) != Relation.ENEMY || siegeFlag.stack.nation.getRelation(siegeFlag.getLocation().getChunkLocation().getNation()) != Relation.ALLY) {
                                        siegeFlag.convertToCamp();
                                        return;
                                    }
                                    for (SimpleChunkLocation adj : siegeFlag.getLocation().getChunkLocation().getAdjacentChunks()) {
                                        if (adj.getTown() != siegeFlag.target) continue;
                                        break block3;
                                    }
                                    siegeFlag.convertToCamp();
                                    return;
                                }
                                siegeFlag.target.damage(siegeFlag.stack);
                                if (siegeFlag.target.townHealth <= 0.0) {
                                    HistoricalBroadcastManager.broadcast(Message.getMessage("history.town-sieged").add("nation", siegeFlag.stack.nation.getName()).add("town", siegeFlag.target.getName()), List.of(siegeFlag.target.getNation(), siegeFlag.stack.nation));
                                    siegeFlag.target.transferNation(siegeFlag.stack.nation);
                                    siegeFlag.target.townHealth = siegeFlag.target.getMaxHealth() / 2.0;
                                    siegeFlag.convertToCamp();
                                }
                            }
                        }.runTaskLater((Plugin)BetterNations.instance, 0L);
                        continue;
                    }
                    if (!(army instanceof ArmyCamp)) continue;
                    ArmyCamp camp = (ArmyCamp)army;
                    if (!chunk.isTownChunk() || (town = chunk.getTown()) == null) continue;
                    town.townHealth = Math.min(town.townHealth + camp.stack.getDamageTowards(ArmorType.TERRITORY) / 2.0, town.getMaxHealth());
                }
                if (!chunkHealths.containsKey(chunk) || !(chunkHealths.get(chunk) <= 0.0)) continue;
                new BukkitRunnable(){

                    public void run() {
                        double mxatt = -1.0;
                        Nation tnation = null;
                        for (StructuredArmy army : new HashSet(StructuredArmy.armyLocationMap.get(chunk))) {
                            if (!(army instanceof InvasionFlag)) continue;
                            InvasionFlag invasion = (InvasionFlag)army;
                            invasion.convertToCamp();
                            if (!(invasion.stack.getDamageTowards(ArmorType.TERRITORY) > mxatt)) continue;
                            mxatt = invasion.stack.getDamageTowards(ArmorType.TERRITORY);
                            tnation = invasion.stack.nation;
                        }
                        chunkHealths.remove(chunk);
                        final Nation origNation = chunk.getNation();
                        if (tnation != null && origNation != null) {
                            origNation.forceUnclaim(chunk);
                            tnation.claim(chunk);
                            final Nation n = tnation;
                            new BukkitRunnable(){

                                public void run() {
                                    ArmyUpdateManager.this.checkChunkAfterInvasion(chunk, n, origNation);
                                }
                            }.runTaskAsynchronously((Plugin)BetterNations.instance);
                        }
                    }
                }.runTaskLater((Plugin)BetterNations.instance, 0L);
            }
            catch (Exception e) {
                Bukkit.getLogger().severe("Failed to update combat for " + chunk.toString() + "! PLEASE REPORT THE FOLLOWING TO THE DEVELOPER:");
                e.printStackTrace();
            }
        }
        nextUpdate = System.currentTimeMillis() + 1000L * (long)Config.getInt("combat.army-tick-interval");
    }
}

