/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.planetlib.Utils;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class HistoricalBroadcastManager {
    public static Map<Integer, List<HistoricalEvent>> history = new HashMap<Integer, List<HistoricalEvent>>();

    public static void broadcast(Message content, List<Nation> nations) {
        long time = System.currentTimeMillis();
        int day = (int)(time / 1000L / 60L / 60L / 24L);
        history.putIfAbsent(day, new ArrayList());
        HistoricalEvent event = new HistoricalEvent(UUID.randomUUID(), history.get(day).size(), day, Utils.getTimeString(time).split(" ")[1], content.toFormatted(), nations.stream().map(Nation::getName).toList());
        history.get(day).add(event);
        Message.getMessage("history.broadcast-message").add("content", content).broadcast();
    }

    public record HistoricalEvent(UUID id, Integer order, Integer date, String time, String cont, List<String> nations) {
        public boolean serialize(IDataItem dataItem) {
            dataItem.setUUID(this.id);
            dataItem.set("date", this.date);
            dataItem.set("order", this.order);
            dataItem.set("time", this.time);
            dataItem.set("cont", this.cont);
            dataItem.set("nations", String.join((CharSequence)",", this.nations));
            return true;
        }

        public static HistoricalEvent deserialize(IDataItem dataItem) {
            HistoricalEvent event = new HistoricalEvent(dataItem.getUUID(), dataItem.getInteger("order"), dataItem.getInteger("date"), dataItem.getString("time"), dataItem.getString("cont"), List.of(dataItem.getString("nations").split(",")));
            history.putIfAbsent(event.date(), new ArrayList());
            history.get(event.date()).add(event);
            history.get(event.date()).sort(Comparator.comparing(a -> a.order));
            return event;
        }
    }
}

