/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.manager.map;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.manager.NaturalResourcesManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Color;
import de.bluecolored.bluemap.api.math.Shape;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MapDisplayManager {
    public static Map<SimpleWorld, MarkerSet> nations = new HashMap<SimpleWorld, MarkerSet>();
    public static Map<SimpleWorld, MarkerSet> towns = new HashMap<SimpleWorld, MarkerSet>();
    public static Map<SimpleWorld, MarkerSet> pois = new HashMap<SimpleWorld, MarkerSet>();
    public static Set<Nation> nationUpdates = new HashSet<Nation>();
    public static Set<Town> townUpdates = new HashSet<Town>();

    private static Color adaptColor(org.bukkit.Color clr) {
        return new Color(clr.getRed(), clr.getGreen(), clr.getBlue(), (float)clr.getAlpha() / 255.0f);
    }

    private static SimpleChunkLocation getRoot(Map<SimpleChunkLocation, SimpleChunkLocation> p, SimpleChunkLocation loc) {
        if (p.get(loc).equals(loc)) {
            return loc;
        }
        SimpleChunkLocation ret = MapDisplayManager.getRoot(p, p.get(loc));
        p.put(loc, ret);
        return ret;
    }

    public static void drawNations(Collection<Nation> allNations) {
        HashMap<SimpleChunkLocation, SimpleChunkLocation> p = new HashMap<SimpleChunkLocation, SimpleChunkLocation>();
        for (Nation n : allNations) {
            for (SimpleChunkLocation loc : new HashSet<SimpleChunkLocation>(n.nationalChunks)) {
                p.put(loc, loc);
                for (SimpleChunkLocation adj : loc.getAdjacentChunks()) {
                    if (adj.getNation() != n || !p.containsKey(adj) || MapDisplayManager.getRoot(p, loc).equals(MapDisplayManager.getRoot(p, adj))) continue;
                    p.put(MapDisplayManager.getRoot(p, loc), MapDisplayManager.getRoot(p, adj));
                }
            }
        }
        HashMap<SimpleChunkLocation, ChunkCluster> clusters = new HashMap<SimpleChunkLocation, ChunkCluster>();
        for (SimpleChunkLocation loc : p.keySet()) {
            SimpleChunkLocation root = MapDisplayManager.getRoot(p, loc);
            if (!clusters.containsKey(root)) {
                clusters.put(root, new ChunkCluster());
            }
            ((ChunkCluster)clusters.get(root)).add(loc);
        }
        for (ChunkCluster i : clusters.values()) {
            Nation nation = i.corner.getNation();
            if (nation == null) continue;
            HashMap<SimpleChunkLocation, SimpleChunkLocation> np = new HashMap<SimpleChunkLocation, SimpleChunkLocation>();
            for (int j = i.minx - 1; j <= i.maxx + 1; ++j) {
                for (int k = i.minz - 1; k <= i.maxz + 1; ++k) {
                    SimpleChunkLocation loc = SimpleChunkLocation.of(j, k, i.corner.world());
                    if (i.contains(loc)) continue;
                    np.put(loc, loc);
                    for (SimpleChunkLocation adj : loc.getAdjacentChunks()) {
                        if (!np.containsKey(adj) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, adj))) continue;
                        np.put(MapDisplayManager.getRoot(np, loc), MapDisplayManager.getRoot(np, adj));
                    }
                    for (SimpleChunkLocation adj : loc.getDiagAdjacentChunks()) {
                        if (!np.containsKey(adj) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, adj)) || !MapDisplayManager.getRoot(np, adj).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world()))) && !MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world())))) continue;
                        np.put(MapDisplayManager.getRoot(np, loc), MapDisplayManager.getRoot(np, adj));
                    }
                }
            }
            HashMap<SimpleChunkLocation, ChunkCluster> negativeClusters = new HashMap<SimpleChunkLocation, ChunkCluster>();
            for (int j = i.minx - 1; j <= i.maxx + 1; ++j) {
                for (int k = i.minz - 1; k <= i.maxz + 1; ++k) {
                    SimpleChunkLocation loc = SimpleChunkLocation.of(j, k, i.corner.world());
                    if (!np.containsKey(loc) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world())))) continue;
                    if (!negativeClusters.containsKey(MapDisplayManager.getRoot(np, loc))) {
                        negativeClusters.put(MapDisplayManager.getRoot(np, loc), new ChunkCluster());
                    }
                    ((ChunkCluster)negativeClusters.get(MapDisplayManager.getRoot(np, loc))).add(loc);
                }
            }
            Shape[] holes = new Shape[negativeClusters.size()];
            int idx = 0;
            for (ChunkCluster j : negativeClusters.values()) {
                holes[idx++] = j.drawShape();
            }
            if (!nations.containsKey(i.corner.world())) {
                nations.put(i.corner.world(), MarkerSet.builder().label(Message.getMessage("bluemap.markerset.nation").toString()).build());
            }
            ShapeMarker marker = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().shape(i.drawShape(), (float)Config.getInt("bluemap.nation-layer-height")).holes(holes).lineColor(MapDisplayManager.adaptColor(nation.getColor().setAlpha(255))).fillColor(MapDisplayManager.adaptColor(nation.getColor().setAlpha(120))).lineWidth(Config.getInt("bluemap.line-width")).label(nation.getName())).maxDistance((double)Config.getInt("bluemap.max-view-distance"))).build();
            nations.get(i.corner.world()).put(nation.getId().toString() + "." + i.corner.x() + "-" + i.corner.z(), (Marker)marker);
        }
    }

    public static void drawTowns(Collection<Town> allTowns) {
        HashMap<SimpleChunkLocation, SimpleChunkLocation> p = new HashMap<SimpleChunkLocation, SimpleChunkLocation>();
        for (Town t : allTowns) {
            for (SimpleChunkLocation loc : new HashSet<SimpleChunkLocation>(t.getTownChunks())) {
                p.put(loc, loc);
                for (SimpleChunkLocation adj : loc.getAdjacentChunks()) {
                    if (adj.getTown() != t || !p.containsKey(adj) || MapDisplayManager.getRoot(p, loc).equals(MapDisplayManager.getRoot(p, adj))) continue;
                    p.put(MapDisplayManager.getRoot(p, loc), MapDisplayManager.getRoot(p, adj));
                }
            }
        }
        HashMap<SimpleChunkLocation, ChunkCluster> clusters = new HashMap<SimpleChunkLocation, ChunkCluster>();
        for (SimpleChunkLocation loc : p.keySet()) {
            SimpleChunkLocation root = MapDisplayManager.getRoot(p, loc);
            if (!clusters.containsKey(root)) {
                clusters.put(root, new ChunkCluster());
            }
            ((ChunkCluster)clusters.get(root)).add(loc);
        }
        for (ChunkCluster i : clusters.values()) {
            Town town = i.corner.getTown();
            if (town == null) continue;
            HashMap<SimpleChunkLocation, SimpleChunkLocation> np = new HashMap<SimpleChunkLocation, SimpleChunkLocation>();
            for (int j = i.minx - 1; j <= i.maxx + 1; ++j) {
                for (int k = i.minz - 1; k <= i.maxz + 1; ++k) {
                    SimpleChunkLocation loc = SimpleChunkLocation.of(j, k, i.corner.world());
                    if (i.contains(loc)) continue;
                    np.put(loc, loc);
                    for (SimpleChunkLocation adj : loc.getAdjacentChunks()) {
                        if (!np.containsKey(adj) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, adj))) continue;
                        np.put(MapDisplayManager.getRoot(np, loc), MapDisplayManager.getRoot(np, adj));
                    }
                    for (SimpleChunkLocation adj : loc.getDiagAdjacentChunks()) {
                        if (!np.containsKey(adj) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, adj)) || !MapDisplayManager.getRoot(np, adj).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world()))) && !MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world())))) continue;
                        np.put(MapDisplayManager.getRoot(np, loc), MapDisplayManager.getRoot(np, adj));
                    }
                }
            }
            HashMap<SimpleChunkLocation, ChunkCluster> negativeClusters = new HashMap<SimpleChunkLocation, ChunkCluster>();
            for (int j = i.minx - 1; j <= i.maxx + 1; ++j) {
                for (int k = i.minz - 1; k <= i.maxz + 1; ++k) {
                    SimpleChunkLocation loc = SimpleChunkLocation.of(j, k, i.corner.world());
                    if (!np.containsKey(loc) || MapDisplayManager.getRoot(np, loc).equals(MapDisplayManager.getRoot(np, SimpleChunkLocation.of(i.minx - 1, i.minz - 1, i.corner.world())))) continue;
                    if (!negativeClusters.containsKey(MapDisplayManager.getRoot(np, loc))) {
                        negativeClusters.put(MapDisplayManager.getRoot(np, loc), new ChunkCluster());
                    }
                    ((ChunkCluster)negativeClusters.get(MapDisplayManager.getRoot(np, loc))).add(loc);
                }
            }
            Shape[] holes = new Shape[negativeClusters.size()];
            int idx = 0;
            for (ChunkCluster j : negativeClusters.values()) {
                holes[idx++] = j.drawShape();
            }
            if (!towns.containsKey(i.corner.world())) {
                towns.put(i.corner.world(), MarkerSet.builder().label(Message.getMessage("bluemap.markerset.town").toString()).build());
            }
            ShapeMarker marker = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().shape(i.drawShape(), (float)Config.getInt("bluemap.town-layer-height")).holes(holes).lineColor(new Color(170, 170, 170)).fillColor(new Color(170, 170, 170, 0.3f)).lineWidth(Config.getInt("bluemap.line-width")).label(town.getName())).maxDistance((double)Config.getInt("bluemap.town-max-view-distance"))).build();
            towns.get(i.corner.world()).put(town.getId().toString() + "." + i.corner.x() + "-" + i.corner.z(), (Marker)marker);
        }
    }

    public static void drawInvasions() {
        for (SimpleChunkLocation loc : new HashSet<SimpleChunkLocation>(StructuredArmy.armyLocationMap.keySet())) {
            for (StructuredArmy i : new HashSet(StructuredArmy.armyLocationMap.get(loc))) {
                POIMarker.Builder marker;
                if (i instanceof InvasionFlag) {
                    marker = (POIMarker.Builder)POIMarker.builder().label(Message.getMessage("bluemap.invasion-title").add("nation", i.stack.nation.getName()).add("size", i.stack.size()).add("health", (double)Math.round(i.stack.getHealth() * 10.0) / 10.0).add("max_health", i.stack.getMaxHealth()).toString());
                } else {
                    if (!(i instanceof SiegeFlag)) continue;
                    SiegeFlag flag = (SiegeFlag)i;
                    marker = (POIMarker.Builder)POIMarker.builder().label(Message.getMessage("bluemap.siege-title").add("nation", i.stack.nation.getName()).add("size", i.stack.size()).add("health", (double)Math.round(i.stack.getHealth() * 10.0) / 10.0).add("max_health", i.stack.getMaxHealth()).add("town", flag.target.getName()).toString());
                }
                ((POIMarker.Builder)marker.position(i.location.x(), i.location.y(), i.location.z())).maxDistance(1000.0);
                if (!pois.containsKey(loc.world())) {
                    pois.put(loc.world(), MarkerSet.builder().label(Message.getMessage("bluemap.markerset.poi").toString()).build());
                }
                pois.get(loc.world()).put(i.uuid.toString(), (Marker)marker.build());
            }
        }
    }

    public static void drawResources() {
        for (SimpleChunkLocation loc : new HashSet<SimpleChunkLocation>(NaturalResourcesManager.naturalResourcesMap.keySet())) {
            double x = loc.x() * 16 + 8;
            double z = loc.z() * 16 + 8;
            double y = loc.world().getBukkitWorld().getHighestBlockYAt((int)x, (int)z) + 1;
            POIMarker.Builder marker = (POIMarker.Builder)((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().label(Message.getMessage("bluemap.resource-title").add("type", Objects.requireNonNull(NaturalResourcesManager.naturalResourcesMap.get(loc).getItemStack().getItemMeta()).getDisplayName().replaceAll("\u00a7.", "")).toString())).position(x, y, z)).maxDistance(500.0);
            String type = NaturalResourcesManager.naturalResourcesMap.get(loc).getName();
            if (Config.contains("bluemap.resource-img." + type)) {
                marker.icon(Config.getString("bluemap.resource-img." + type), new Vector2i(0, 0));
            }
            if (!pois.containsKey(loc.world())) {
                pois.put(loc.world(), MarkerSet.builder().label(Message.getMessage("bluemap.markerset.poi").toString()).build());
            }
            pois.get(loc.world()).put(loc.toString(), (Marker)marker.build());
        }
    }

    private static BukkitRunnable getRunnable(final BlueMapAPI api) {
        return new BukkitRunnable(){

            public void run() {
                nations.clear();
                towns.clear();
                pois.clear();
                MapDisplayManager.drawNations(Nation.nations.values());
                MapDisplayManager.drawTowns(Town.towns.values());
                MapDisplayManager.drawInvasions();
                MapDisplayManager.drawResources();
                for (SimpleWorld i : nations.keySet()) {
                    api.getWorld((Object)i.getBukkitWorld()).ifPresent(world -> {
                        for (BlueMapMap map : world.getMaps()) {
                            map.getMarkerSets().put("bn.nations", nations.get(i));
                        }
                    });
                }
                for (SimpleWorld i : towns.keySet()) {
                    api.getWorld((Object)i.getBukkitWorld()).ifPresent(world -> {
                        for (BlueMapMap map : world.getMaps()) {
                            map.getMarkerSets().put("bn.towns", towns.get(i));
                        }
                    });
                }
                for (SimpleWorld i : pois.keySet()) {
                    api.getWorld((Object)i.getBukkitWorld()).ifPresent(world -> {
                        for (BlueMapMap map : world.getMaps()) {
                            map.getMarkerSets().put("bn.pois", pois.get(i));
                        }
                    });
                }
                BetterNations.instance.getLogger().info("\u001b[32mHooked into Bluemap!\u001b[0m");
            }
        };
    }

    public static void init() {
        BlueMapAPI.onEnable(api -> MapDisplayManager.getRunnable(api).runTaskAsynchronously((Plugin)BetterNations.instance));
    }

    public static void unload() {
        BlueMapAPI.getInstance().ifPresent(api -> {
            for (BlueMapMap map : api.getMaps()) {
                map.getMarkerSets().remove("bn.nations");
                map.getMarkerSets().remove("bn.towns");
                map.getMarkerSets().remove("bn.pois");
            }
        });
    }

    public static void updateNation(Nation nation) {
        nationUpdates.add(nation);
    }

    public static void updateTown(Town town) {
        townUpdates.add(town);
    }

    public static void update() {
        BlueMapAPI.getInstance().ifPresent(api -> {
            HashSet<Nation> nu = new HashSet<Nation>(nationUpdates);
            HashSet<Town> tu = new HashSet<Town>(townUpdates);
            nationUpdates.clear();
            townUpdates.clear();
            for (BlueMapMap map : api.getMaps()) {
                UUID id2;
                if (map.getMarkerSets().containsKey("bn.nations")) {
                    for (String marker : new HashSet(((MarkerSet)map.getMarkerSets().get("bn.nations")).getMarkers().keySet())) {
                        try {
                            id2 = UUID.fromString(marker.split("\\.")[0]);
                            Nation n = Nation.getNation(id2);
                            if (!nu.contains(n)) continue;
                            ((MarkerSet)map.getMarkerSets().get("bn.nations")).remove(marker);
                        }
                        catch (Exception id2) {}
                    }
                }
                if (map.getMarkerSets().containsKey("bn.towns")) {
                    for (String marker : new HashSet(((MarkerSet)map.getMarkerSets().get("bn.towns")).getMarkers().keySet())) {
                        try {
                            id2 = UUID.fromString(marker.split("\\.")[0]);
                            Town t = Town.getTown(id2);
                            if (!tu.contains(t)) continue;
                            ((MarkerSet)map.getMarkerSets().get("bn.towns")).remove(marker);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!map.getMarkerSets().containsKey("bn.pois")) continue;
                for (String marker : new HashSet(((MarkerSet)map.getMarkerSets().get("bn.pois")).getMarkers().keySet())) {
                    try {
                        ((MarkerSet)map.getMarkerSets().get("bn.pois")).remove(marker);
                    }
                    catch (Exception exception) {}
                }
            }
            MapDisplayManager.drawNations(nu);
            MapDisplayManager.drawTowns(tu);
            MapDisplayManager.drawInvasions();
            MapDisplayManager.drawResources();
        });
    }

    public static void reload() {
        MapDisplayManager.unload();
        BlueMapAPI.getInstance().ifPresent(api -> MapDisplayManager.getRunnable(api).runTaskAsynchronously((Plugin)BetterNations.instance));
    }

    public static class ChunkCluster
    extends HashSet<SimpleChunkLocation> {
        public SimpleChunkLocation corner = null;
        public int minx = Integer.MAX_VALUE;
        public int maxx = Integer.MIN_VALUE;
        public int minz = Integer.MAX_VALUE;
        public int maxz = Integer.MIN_VALUE;

        @Override
        public boolean add(SimpleChunkLocation chunk) {
            if (this.corner == null || this.corner.x() > chunk.x() || this.corner.x() == chunk.x() && this.corner.z() > chunk.z()) {
                this.corner = chunk;
            }
            this.minx = Math.min(this.minx, chunk.x());
            this.maxx = Math.max(this.maxx, chunk.x());
            this.minz = Math.min(this.minz, chunk.z());
            this.maxz = Math.max(this.maxz, chunk.z());
            return super.add(chunk);
        }

        private Vector2d getLeftTopCorner(SimpleChunkLocation chunk) {
            return Vector2d.from((double)((double)(chunk.x() * 16) + 0.5), (double)((double)(chunk.z() * 16) + 0.5));
        }

        private Vector2d getRightTopCorner(SimpleChunkLocation chunk) {
            return Vector2d.from((double)((double)(chunk.x() * 16) + 15.5), (double)((double)(chunk.z() * 16) + 0.5));
        }

        private Vector2d getRightBottomCorner(SimpleChunkLocation chunk) {
            return Vector2d.from((double)((double)(chunk.x() * 16) + 15.5), (double)((double)(chunk.z() * 16) + 15.5));
        }

        private Vector2d getLeftBottomCorner(SimpleChunkLocation chunk) {
            return Vector2d.from((double)((double)(chunk.x() * 16) + 0.5), (double)((double)(chunk.z() * 16) + 15.5));
        }

        public Shape drawShape() {
            Shape.Builder shape = Shape.builder();
            shape.addPoint(this.getLeftTopCorner(this.corner));
            SimpleChunkLocation.Direction dir = SimpleChunkLocation.Direction.EAST;
            SimpleChunkLocation cur = this.corner;
            do {
                switch (dir) {
                    case EAST: {
                        SimpleChunkLocation nxt = cur.getRelative(0, -1);
                        if (this.contains(nxt)) {
                            shape.addPoint(this.getLeftTopCorner(cur));
                            dir = SimpleChunkLocation.Direction.NORTH;
                            cur = nxt;
                            break;
                        }
                        nxt = cur.getRelative(1, 0);
                        if (this.contains(nxt)) {
                            cur = nxt;
                            break;
                        }
                        shape.addPoint(this.getRightTopCorner(cur));
                        dir = SimpleChunkLocation.Direction.SOUTH;
                        break;
                    }
                    case WEST: {
                        SimpleChunkLocation nxt = cur.getRelative(0, 1);
                        if (this.contains(nxt)) {
                            shape.addPoint(this.getRightBottomCorner(cur));
                            dir = SimpleChunkLocation.Direction.SOUTH;
                            cur = nxt;
                            break;
                        }
                        nxt = cur.getRelative(-1, 0);
                        if (this.contains(nxt)) {
                            cur = nxt;
                            break;
                        }
                        shape.addPoint(this.getLeftBottomCorner(cur));
                        dir = SimpleChunkLocation.Direction.NORTH;
                        break;
                    }
                    case SOUTH: {
                        SimpleChunkLocation nxt = cur.getRelative(1, 0);
                        if (this.contains(nxt)) {
                            shape.addPoint(this.getRightTopCorner(cur));
                            dir = SimpleChunkLocation.Direction.EAST;
                            cur = nxt;
                            break;
                        }
                        nxt = cur.getRelative(0, 1);
                        if (this.contains(nxt)) {
                            cur = nxt;
                            break;
                        }
                        shape.addPoint(this.getRightBottomCorner(cur));
                        dir = SimpleChunkLocation.Direction.WEST;
                        break;
                    }
                    case NORTH: {
                        SimpleChunkLocation nxt = cur.getRelative(-1, 0);
                        if (this.contains(nxt)) {
                            shape.addPoint(this.getLeftBottomCorner(cur));
                            dir = SimpleChunkLocation.Direction.WEST;
                            cur = nxt;
                            break;
                        }
                        nxt = cur.getRelative(0, -1);
                        if (this.contains(nxt)) {
                            cur = nxt;
                            break;
                        }
                        shape.addPoint(this.getLeftTopCorner(cur));
                        dir = SimpleChunkLocation.Direction.EAST;
                    }
                }
            } while (!cur.equals(this.corner) || dir != SimpleChunkLocation.Direction.EAST);
            return shape.build();
        }
    }
}

