/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation;

import cn.jason31416.betternations.manager.map.MapDisplayManager;
import cn.jason31416.betternations.nation.NationType;
import cn.jason31416.betternations.nation.NationalRank;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.betternations.nation.resolution.AbstractResolution;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Color;

public class Nation {
    public static Map<UUID, Nation> nations = new HashMap<UUID, Nation>();
    public static Map<SimplePlayer, Nation> playerNationMap = new HashMap<SimplePlayer, Nation>();
    public static Map<SimpleChunkLocation, Nation> chunkNationMap = new HashMap<SimpleChunkLocation, Nation>();
    public final Map<String, AbstractResolution> resolutions = new HashMap<String, AbstractResolution>();
    List<Town> towns = new ArrayList<Town>();
    public Set<SimpleChunkLocation> nationalChunks = new HashSet<SimpleChunkLocation>();
    Map<SimplePlayer, NationalRank> memberRanks = new HashMap<SimplePlayer, NationalRank>();
    UUID id;
    String name;
    SimplePlayer owner;
    Color color;
    NationType type = NationType.MONARCHY;
    public Map<Nation, Relation> relations = new HashMap<Nation, Relation>();

    public Nation(UUID id, String name, Color color) {
        this.id = id;
        this.name = name;
        this.color = color;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public String getColorTag() {
        return "<#" + Integer.toHexString(this.color.asRGB()) + ">";
    }

    public void setColor(Color color) {
        this.color = color;
        for (Town t : this.towns) {
            if (t.core == null) continue;
            t.core.hologram.setText(t.core.getHologramText());
        }
    }

    public List<Town> getTowns() {
        return this.towns;
    }

    public SimplePlayer getOwner() {
        return this.owner;
    }

    public NationType getType() {
        return this.type;
    }

    public void setType(NationType type) {
        for (SimplePlayer player : this.memberRanks.keySet()) {
            if (player.equals(this.owner)) {
                this.memberRanks.put(player, type.getOwnerRank());
                continue;
            }
            this.memberRanks.put(player, type.getDefaultRank());
        }
        this.type = type;
    }

    public Set<SimplePlayer> getMembers() {
        return this.memberRanks.keySet();
    }

    public NationalRank getRank(SimplePlayer player) {
        return this.memberRanks.get(player);
    }

    public boolean exists() {
        return nations.containsValue(this);
    }

    public boolean isNomad() {
        return this.towns.isEmpty();
    }

    public void disband() {
        for (Town town : new ArrayList<Town>(this.towns)) {
            town.remove();
        }
        for (SimpleChunkLocation chunk : this.nationalChunks) {
            chunkNationMap.remove(chunk);
        }
        for (Nation other : new ArrayList<Nation>(this.relations.keySet())) {
            other.setRelation(this, Relation.NEUTRAL);
        }
        for (SimplePlayer player : this.memberRanks.keySet()) {
            playerNationMap.remove(player);
        }
        this.unregisterNation();
    }

    public void setRank(SimplePlayer player, NationalRank rank) {
        this.memberRanks.put(player, rank);
    }

    public void setOwner(SimplePlayer owner) {
        if (this.owner != null) {
            this.memberRanks.put(this.owner, this.type.allRanks.get(this.type.allRanks.size() - 2));
        }
        this.owner = owner;
        this.memberRanks.put(owner, this.type.getOwnerRank());
    }

    public void kickPlayer(SimplePlayer player) {
        if (player == this.owner) {
            return;
        }
        this.memberRanks.remove(player);
        playerNationMap.remove(player);
        ArrayList<Town> ownedTowns = new ArrayList<Town>();
        for (Town town : this.towns) {
            if (town.getMayor() == player) {
                ownedTowns.add(town);
                continue;
            }
            town.removeResident(player);
        }
        if (!ownedTowns.isEmpty()) {
            Object initname = Message.getMessage("town.revolt-name").add("town_name", ((Town)ownedTowns.get((int)0)).name).toString();
            String name = initname;
            int cnt = 1;
            while (Nation.getNation((String)initname) != null) {
                initname = name + "_" + cnt++;
            }
            Nation newNation = Nation.createNation(player, (String)initname);
            for (Town town : ownedTowns) {
                if (newNation.getTowns().contains(town)) {
                    town.nation = newNation;
                    continue;
                }
                newNation.addTown(town);
            }
            newNation.setRelation(this, Relation.ENEMY);
        }
    }

    public void removePlayer(SimplePlayer player) {
        if (player == this.owner) {
            return;
        }
        this.memberRanks.remove(player);
        playerNationMap.remove(player);
        for (Town town : this.towns) {
            town.setRole(this.owner, TownRole.MAYOR);
            town.removeResident(player);
        }
    }

    public void addPlayer(SimplePlayer player) {
        if (player.getNation() != null) {
            return;
        }
        for (Town town : this.towns) {
            if (town.getRole(player) != TownRole.GREENCARD) continue;
            town.setRole(player, TownRole.RESIDENT);
        }
        playerNationMap.put(player, this);
        this.memberRanks.put(player, this.type.getDefaultRank());
    }

    public synchronized boolean claim(SimpleChunkLocation chunk) {
        if (chunk.isClaimed()) {
            return false;
        }
        this.nationalChunks.add(chunk);
        chunkNationMap.put(chunk, this);
        MapDisplayManager.updateNation(this);
        return true;
    }

    public synchronized boolean unclaim(SimpleChunkLocation chunk) {
        Town town;
        if (!this.nationalChunks.contains(chunk)) {
            return false;
        }
        if (chunk.isTownChunk() && (town = chunk.getTown()) != null) {
            town.unclaim(chunk);
        }
        this.nationalChunks.remove(chunk);
        chunkNationMap.remove(chunk);
        MapDisplayManager.updateNation(this);
        return true;
    }

    public synchronized boolean forceUnclaim(SimpleChunkLocation chunk) {
        if (!this.nationalChunks.contains(chunk)) {
            return false;
        }
        this.nationalChunks.remove(chunk);
        chunkNationMap.remove(chunk);
        MapDisplayManager.updateNation(this);
        return true;
    }

    public void registerNation() {
        nations.put(this.id, this);
    }

    public void unregisterNation() {
        nations.remove(this.id);
    }

    public void addTown(Town town) {
        this.towns.add(town);
        town.nation = this;
    }

    public void setRelation(Nation other, Relation relation) {
        if (relation == null) {
            return;
        }
        if (relation == Relation.NEUTRAL) {
            this.relations.remove(other);
            other.relations.remove(this);
        } else {
            this.relations.put(other, relation);
            other.relations.put(this, relation);
        }
    }

    public Relation getRelation(Nation other) {
        if (other == this) {
            return Relation.ALLY;
        }
        if (other == null) {
            return Relation.NEUTRAL;
        }
        if (!this.relations.containsKey(other)) {
            return Relation.NEUTRAL;
        }
        return this.relations.get(other);
    }

    public boolean serialize(IDataItem dataItem) {
        dataItem.setUUID(this.id);
        dataItem.set("name", this.name);
        dataItem.set("owner", this.owner.getUUID().toString());
        dataItem.set("color", this.color.asRGB());
        dataItem.set("type", this.type.name());
        ArrayList<CallSite> relationList = new ArrayList<CallSite>();
        ArrayList<CallSite> memberList = new ArrayList<CallSite>();
        ArrayList<CallSite> nationalChunkList = new ArrayList<CallSite>();
        for (Nation other : this.relations.keySet()) {
            relationList.add((CallSite)((Object)(other.getId().toString() + ":" + this.relations.get(other).name())));
        }
        for (SimplePlayer player : this.memberRanks.keySet()) {
            memberList.add((CallSite)((Object)(player.getUUID().toString() + ":" + this.memberRanks.get(player).name())));
        }
        String lstWorld = "";
        for (SimpleChunkLocation chunk : this.nationalChunks) {
            String worldID = chunk.world().getBukkitWorld().getUID().toString();
            if (!lstWorld.isEmpty() && lstWorld.equals(worldID)) {
                nationalChunkList.add((CallSite)((Object)(chunk.x() + "_" + chunk.z())));
                continue;
            }
            nationalChunkList.add((CallSite)((Object)(chunk.x() + "_" + chunk.z() + "_" + worldID)));
            lstWorld = worldID;
        }
        dataItem.set("relations", String.join((CharSequence)";", relationList));
        dataItem.set("members", String.join((CharSequence)";", memberList));
        dataItem.set("chunks", String.join((CharSequence)";", nationalChunkList));
        return true;
    }

    public static Nation deserialize(IDataItem dataItem) {
        Nation nation = new Nation(dataItem.getUUID(), dataItem.getString("name"), Color.fromRGB((int)dataItem.getInteger("color")));
        nation.owner = SimplePlayer.of(UUID.fromString(dataItem.getString("owner")));
        nation.type = NationType.valueOf(dataItem.getString("type"));
        nation.relations.clear();
        for (String relationStr : dataItem.getString("relations").split(";")) {
            String[] relationArr;
            Nation other;
            if (relationStr.isEmpty() || (other = Nation.getNation(UUID.fromString((relationArr = relationStr.split(":"))[0]))) == null) continue;
            nation.setRelation(other, Relation.valueOf(relationArr[1]));
        }
        SimpleWorld world = null;
        for (String chunk : dataItem.getString("chunks").split(";")) {
            SimpleChunkLocation c;
            if (chunk.isEmpty()) continue;
            String[] chunkLocation = chunk.split("_");
            if (world != null && chunkLocation.length == 2) {
                c = SimpleChunkLocation.of(Integer.parseInt(chunkLocation[0]), Integer.parseInt(chunkLocation[1]), world);
            } else {
                c = SimpleChunkLocation.of(Integer.parseInt(chunkLocation[0]), Integer.parseInt(chunkLocation[1]), SimpleWorld.of(UUID.fromString(chunkLocation[2])));
                world = c.world();
            }
            nation.nationalChunks.add(c);
            chunkNationMap.put(c, nation);
        }
        nation.memberRanks.clear();
        for (String memberStr : dataItem.getString("members").split(";")) {
            if (memberStr.isEmpty()) continue;
            String[] memberArr = memberStr.split(":");
            SimplePlayer player = SimplePlayer.of(UUID.fromString(memberArr[0]));
            nation.memberRanks.put(player, NationalRank.getRank(memberArr[1]));
            playerNationMap.put(player, nation);
        }
        nation.registerNation();
        return nation;
    }

    public static Nation createNation(SimplePlayer player, SimpleLocation location, String name, String townName) {
        if (location.getChunkLocation().isClaimed()) {
            return null;
        }
        Nation nation = Nation.createNation(player, name);
        Town.createTown(townName == null ? Config.getString("nation.capital-name").replace("%nation%", name) : townName, location, nation, player);
        return nation;
    }

    public static Nation createNation(SimplePlayer player, String name) {
        Random colorRandomizer = new Random();
        int r = colorRandomizer.nextInt(256);
        int g = colorRandomizer.nextInt(256);
        int b = colorRandomizer.nextInt(256);
        Nation nation = new Nation(UUID.randomUUID(), name, Color.fromRGB((int)r, (int)g, (int)b));
        nation.registerNation();
        nation.setOwner(player);
        playerNationMap.put(player, nation);
        return nation;
    }

    public static Nation getNation(UUID id) {
        return nations.get(id);
    }

    public static Nation getNation(String name) {
        for (Nation nation : nations.values()) {
            if (!nation.getName().equals(name)) continue;
            return nation;
        }
        return null;
    }
}

