/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation;

import cn.jason31416.betternations.nation.NationalRank;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.resolution.AbstractResolution;
import cn.jason31416.betternations.nation.resolution.DailyResolution;
import cn.jason31416.betternations.nation.resolution.DisbandResolution;
import cn.jason31416.betternations.nation.resolution.ImportantResolution;
import cn.jason31416.betternations.nation.resolution.OutsiderResolution;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public enum NationType {
    AUTOCRACY("Autocracy", new ArrayList<NationalRank>(List.of(new NationalRank("Peasant", 10, Set.of(Permission.BUILD)), new NationalRank("Officer", 400, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.STRUCTURE, Permission.MANAGE_ARMY)), new NationalRank("Dictator", 1000, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)))), resolution -> {
        if (!(resolution instanceof OutsiderResolution) && !resolution.proposer.getRank().hasPermission(Permission.CHANGE_NATION_ATTRIBUTE)) {
            return false;
        }
        resolution.setRequiredSigners(List.of(NationalRank.getRank("dictator")));
        resolution.setRequiredRatio(1.0);
        return true;
    }),
    MONARCHY("Monarchy", new ArrayList<NationalRank>(List.of(new NationalRank("Peasant", 10, Set.of(Permission.BUILD)), new NationalRank("Knight", 100, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.STRUCTURE, Permission.MANAGE_ARMY)), new NationalRank("General", 500, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)), new NationalRank("King", 1000, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)))), resolution -> {
        if (!(resolution instanceof OutsiderResolution) && !resolution.proposer.getRank().hasPermission(Permission.CHANGE_NATION_ATTRIBUTE)) {
            return false;
        }
        if (resolution instanceof DailyResolution) {
            resolution.setRequiredSigners(List.of(NationalRank.getRank("king"), NationalRank.getRank("general")));
            resolution.setMinimalSigners(2);
            resolution.setRequiredRatio(0.0);
        } else {
            resolution.setRequiredSigners(List.of(NationalRank.getRank("king")));
            resolution.setRequiredRatio(1.0);
        }
        return true;
    }),
    DEMOCRACY("Democracy", new ArrayList<NationalRank>(List.of(new NationalRank("Member", 10, Set.of(Permission.BUILD)), new NationalRank("Citizen", 900, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)), new NationalRank("Leader", 1000, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)))), resolution -> {
        if (!(resolution instanceof OutsiderResolution) && resolution.proposer.getRank() == NationalRank.getRank("member")) {
            return false;
        }
        resolution.setRequiredSigners(List.of(NationalRank.getRank("citizen"), NationalRank.getRank("leader")));
        resolution.setRequiredRatio(0.5);
        return true;
    }),
    ANARCHY("Anarchy", new ArrayList<NationalRank>(List.of(new NationalRank("Member", 10, Set.of(Permission.BUILD)), new NationalRank("Citizen", 900, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)), new NationalRank("Leader", 1000, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)))), resolution -> {
        if (!(resolution instanceof OutsiderResolution) && resolution.proposer.getRank() == NationalRank.getRank("member")) {
            return false;
        }
        resolution.setRequiredRatio(0.0);
        resolution.setMinimalSigners(0);
        return true;
    }),
    REPUBLIC("Republic", new ArrayList<NationalRank>(List.of(NationalRank.getRank("Member"), new NationalRank("Representative", 900, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)), new NationalRank("President", 1000, Set.of(Permission.BUILD, Permission.NATION_CLAIM, Permission.NATION_UNCLAIM, Permission.CHANGE_NATION_ATTRIBUTE, Permission.STRUCTURE, Permission.CHANGE_RANK, Permission.TOWN_CREATE, Permission.MANAGE_ARMY)))), resolution -> {
        if (!(resolution instanceof OutsiderResolution) && resolution.proposer.getRank() == NationalRank.getRank("member")) {
            return false;
        }
        if (resolution instanceof DisbandResolution) {
            ArrayList<SimplePlayer> signers = new ArrayList<SimplePlayer>();
            signers.add(resolution.nation.owner);
            for (Town i : resolution.nation.getTowns()) {
                signers.add(i.getMayor());
            }
            resolution.addRequiredSigners(signers);
            resolution.setRequiredRatio(1.0);
        } else if (resolution instanceof ImportantResolution) {
            resolution.setRequiredSigners(List.of(NationalRank.getRank("president")));
            resolution.setRequiredRatio(1.0);
        } else if (resolution instanceof DailyResolution) {
            resolution.setRequiredSigners(List.of(NationalRank.getRank("representative"), NationalRank.getRank("president")));
            resolution.setRequiredRatio(0.0);
            resolution.setMinimalSigners(2);
        } else {
            resolution.setRequiredSigners(List.of(NationalRank.getRank("representative"), NationalRank.getRank("president")));
            resolution.setRequiredRatio(0.5);
        }
        return true;
    });

    public final String name;
    public final List<NationalRank> allRanks;
    public final DecisionMaker decisionMaker;

    private NationType(String name, List<NationalRank> ranks, DecisionMaker decisionMaker) {
        this.allRanks = ranks;
        this.name = name;
        this.decisionMaker = decisionMaker;
    }

    public NationalRank getOwnerRank() {
        return this.allRanks.get(this.allRanks.size() - 1);
    }

    public NationalRank getDefaultRank() {
        return this.allRanks.get(0);
    }

    public String getDisplayName() {
        return Message.getMessage("nation.type." + this.name.toLowerCase() + ".name").toString();
    }

    public String getDescription() {
        return Message.getMessage("nation.type." + this.name.toLowerCase() + ".description").toString();
    }

    public static interface DecisionMaker {
        public boolean makeDecision(AbstractResolution var1);
    }
}

