/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation;

import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.DamageSource;
import cn.jason31416.betternations.army.Damageable;
import cn.jason31416.betternations.manager.map.MapDisplayManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.TownLevel;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.betternations.structure.types.TownCore;
import cn.jason31416.betternations.structure.types.TownRuin;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import java.lang.invoke.CallSite;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Town
implements Damageable {
    public static final Map<UUID, Town> towns = new HashMap<UUID, Town>();
    public static final Map<SimpleChunkLocation, Town> chunkTownMap = new HashMap<SimpleChunkLocation, Town>();
    UUID id;
    String name;
    Nation nation;
    public SimplePlayer mayor;
    public double devPoints = 0.0;
    public Map<SimplePlayer, Integer> devadded = new HashMap<SimplePlayer, Integer>();
    public TownCore core;
    public double townHealth = 0.0;
    Set<SimpleChunkLocation> townChunks = new HashSet<SimpleChunkLocation>();
    public Map<SimplePlayer, TownRole> roles = new HashMap<SimplePlayer, TownRole>();

    public Town(UUID id, String name, Nation nation) {
        this.id = id;
        this.name = name;
        this.nation = nation;
    }

    public TownLevel getLevel() {
        for (int i = 1; i < TownLevel.townLevels.size(); ++i) {
            if (!(this.devPoints < TownLevel.townLevels.get((int)i).points)) continue;
            return TownLevel.townLevels.get(i - 1);
        }
        return TownLevel.townLevels.get(TownLevel.townLevels.size() - 1);
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Nation getNation() {
        return this.nation;
    }

    public SimplePlayer getMayor() {
        return this.mayor;
    }

    public TownCore getCore() {
        return this.core;
    }

    public Set<SimpleChunkLocation> getTownChunks() {
        return this.townChunks;
    }

    public TownRole getRole(SimplePlayer player) {
        if (!this.roles.containsKey(player)) {
            return TownRole.NONE;
        }
        return this.roles.get(player);
    }

    public void setRole(SimplePlayer player, TownRole role) {
        if (role == TownRole.NONE) {
            this.roles.remove(player);
            return;
        }
        this.roles.put(player, role);
    }

    public void transferNation(Nation newNation) {
        this.nation.towns.remove(this);
        for (SimpleChunkLocation i : this.townChunks) {
            this.nation.forceUnclaim(i);
            newNation.claim(i);
        }
        this.nation = newNation;
        newNation.addTown(this);
        for (SimplePlayer player : this.roles.keySet()) {
            if (player.getNation() == newNation) continue;
            this.setRole(player, TownRole.NONE);
        }
        this.setRole(newNation.owner, TownRole.MAYOR);
        this.mayor = newNation.owner;
        this.core.updateHologram();
    }

    public void moveCore(SimpleLocation location) {
        if (location.getChunkLocation().getTown() == this) {
            this.core.breakStructure();
            this.core = new TownCore();
            this.core.location = location;
            this.core.town = this;
            this.core.place();
        }
    }

    public void remove() {
        if (this.core != null) {
            this.core.breakStructure();
            this.core.unregister();
        }
        this.townHealth = 0.0;
        this.nation.towns.remove(this);
        for (SimpleChunkLocation chunk : this.townChunks) {
            chunkTownMap.remove(chunk);
        }
        MapDisplayManager.updateTown(this);
        this.unregisterTown();
        if (Config.getBoolean("town.require-ruin")) {
            TownRuin.create(this.core.location, this.name);
        }
    }

    public void registerTown() {
        towns.put(this.id, this);
    }

    public void unregisterTown() {
        towns.remove(this.id);
    }

    public void removeResident(SimplePlayer player) {
        this.roles.remove(player);
    }

    public boolean claimChecks(SimpleChunkLocation chunk) {
        boolean bb = false;
        for (SimpleChunkLocation adjacentChunk : chunk.getAdjacentChunks()) {
            if (!adjacentChunk.isTownChunk() || adjacentChunk.getTown() != this) continue;
            bb = true;
            break;
        }
        return bb;
    }

    public synchronized boolean claim(SimpleChunkLocation chunk) {
        if (chunk.isTownChunk() || chunk.getNation() != this.nation) {
            return false;
        }
        if (!this.claimChecks(chunk)) {
            return false;
        }
        if (!chunk.isClaimed() && !this.nation.claim(chunk)) {
            return false;
        }
        this.townChunks.add(chunk);
        chunkTownMap.put(chunk, this);
        MapDisplayManager.updateTown(this);
        return true;
    }

    private boolean isConnectedToCore(SimpleChunkLocation chunk, SimpleChunkLocation original, SimpleChunkLocation target) {
        ArrayDeque<SimpleChunkLocation> chunks = new ArrayDeque<SimpleChunkLocation>();
        HashSet<SimpleChunkLocation> searched = new HashSet<SimpleChunkLocation>();
        searched.add(original);
        chunks.add(chunk);
        searched.add(chunk);
        while (!chunks.isEmpty()) {
            SimpleChunkLocation cur = (SimpleChunkLocation)chunks.poll();
            if (cur.equals(target)) {
                return true;
            }
            for (SimpleChunkLocation c : cur.getAdjacentChunks()) {
                if (c.getTown() != chunk.getTown() || searched.contains(c)) continue;
                chunks.add(c);
                searched.add(c);
            }
        }
        return false;
    }

    public boolean unclaimChecks(SimpleChunkLocation chunk) {
        if (chunk.getTown() == null) {
            return false;
        }
        for (SimpleChunkLocation i : chunk.getAdjacentChunks()) {
            if (i.getTown() != chunk.getTown() || this.isConnectedToCore(i, chunk, chunk.getTown().getCore().location.getChunkLocation())) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean unclaim(SimpleChunkLocation chunk) {
        if (!chunk.isTownChunk()) {
            return false;
        }
        this.townChunks.remove(chunk);
        chunkTownMap.remove(chunk);
        MapDisplayManager.updateTown(this);
        return true;
    }

    public boolean serialize(IDataItem dataItem) {
        dataItem.setUUID(this.id);
        dataItem.set("name", this.name);
        dataItem.set("mayor", this.mayor.getUUID().toString());
        dataItem.set("nation", this.nation.getId().toString());
        dataItem.set("devpoints", this.devPoints);
        dataItem.set("hp", this.townHealth);
        ArrayList<CallSite> townChunkList = new ArrayList<CallSite>();
        ArrayList<CallSite> roleList = new ArrayList<CallSite>();
        String lstWorld = "";
        for (SimpleChunkLocation chunk : this.townChunks) {
            String worldID = chunk.world().getBukkitWorld().getUID().toString();
            if (!lstWorld.isEmpty() && lstWorld.equals(worldID)) {
                townChunkList.add((CallSite)((Object)(chunk.x() + "_" + chunk.z())));
                continue;
            }
            townChunkList.add((CallSite)((Object)(chunk.x() + "_" + chunk.z() + "_" + worldID)));
            lstWorld = worldID;
        }
        for (SimplePlayer player : this.roles.keySet()) {
            roleList.add((CallSite)((Object)(player.getUUID().toString() + ":" + this.roles.get(player).name())));
        }
        dataItem.set("chunks", String.join((CharSequence)";", townChunkList));
        dataItem.set("roles", String.join((CharSequence)";", roleList));
        return true;
    }

    public static Town deserialize(IDataItem dataItem) {
        String[] roleList;
        UUID id = dataItem.getUUID();
        String name = dataItem.getString("name");
        Nation nation = Nation.getNation(UUID.fromString(dataItem.getString("nation")));
        SimplePlayer mayor = SimplePlayer.of(UUID.fromString(dataItem.getString("mayor")));
        Town town = new Town(id, name, nation);
        town.townHealth = dataItem.getDouble("hp");
        town.mayor = mayor;
        town.devPoints = dataItem.getDouble("devpoints");
        String[] townChunks = dataItem.getString("chunks").split(";");
        SimpleWorld world = null;
        for (String chunk : townChunks) {
            SimpleChunkLocation c;
            if (chunk.isEmpty()) continue;
            String[] chunkLocation = chunk.split("_");
            if (world != null && chunkLocation.length == 2) {
                c = SimpleChunkLocation.of(Integer.parseInt(chunkLocation[0]), Integer.parseInt(chunkLocation[1]), world);
            } else {
                c = SimpleChunkLocation.of(Integer.parseInt(chunkLocation[0]), Integer.parseInt(chunkLocation[1]), SimpleWorld.of(UUID.fromString(chunkLocation[2])));
                world = c.world();
            }
            if (c.getNation() != nation) continue;
            town.townChunks.add(c);
            chunkTownMap.put(c, town);
        }
        for (String role : roleList = dataItem.getString("roles").split(";")) {
            if (role.isEmpty()) continue;
            String[] roleInfo = role.split(":");
            SimplePlayer player = SimplePlayer.of(UUID.fromString(roleInfo[0]));
            TownRole townRole = TownRole.valueOf(roleInfo[1]);
            town.roles.put(player, townRole);
        }
        nation.towns.add(town);
        town.registerTown();
        return town;
    }

    public static Town createTown(String name, SimpleLocation location, Nation nation, SimplePlayer mayor) {
        if (!location.getChunkLocation().isClaimed()) {
            nation.claim(location.getChunkLocation());
        }
        if (location.getChunkLocation().getNation() != nation) {
            return null;
        }
        UUID id = UUID.randomUUID();
        Town town = new Town(id, name, nation);
        town.registerTown();
        town.townHealth = 10.0;
        town.mayor = mayor;
        town.setRole(mayor, TownRole.MAYOR);
        nation.addTown(town);
        town.core = new TownCore();
        town.core.location = location.getBlockLocation();
        town.core.town = town;
        town.core.place();
        town.townChunks.add(location.getChunkLocation());
        chunkTownMap.put(location.getChunkLocation(), town);
        MapDisplayManager.updateTown(town);
        return town;
    }

    public static Town getTown(UUID id) {
        return towns.get(id);
    }

    public static Town getTown(String name) {
        for (Town town : towns.values()) {
            if (!town.getName().equals(name)) continue;
            return town;
        }
        return null;
    }

    public void rename(String newName) {
        this.name = newName;
        if (this.core != null) {
            this.core.hologram.setText(this.core.getHologramText());
        }
    }

    @Override
    public double getHealth() {
        return this.townHealth;
    }

    public double getMaxHealth() {
        return Config.getDouble("combat.chunk-hp") * (double)this.townChunks.size();
    }

    @Override
    public void damage(double dmg) {
        this.townHealth -= dmg;
    }

    @Override
    public void damage(DamageSource dmg) {
        this.townHealth -= dmg.getDamageTowards(ArmorType.TERRITORY);
    }

    @Override
    public boolean isAlive() {
        return this.townHealth > 0.0;
    }
}

