/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.nation.resolution;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.NationType;
import cn.jason31416.betternations.nation.NationalRank;
import cn.jason31416.betternations.nation.resolution.ImportantResolution;
import cn.jason31416.betternations.nation.resolution.OutsiderResolution;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;

public abstract class AbstractResolution {
    public Set<SimplePlayer> requiredSigners;
    public Set<SimplePlayer> signedPlayers = new HashSet<SimplePlayer>();
    public Nation nation;
    public SimplePlayer proposer;
    public long deadline;
    public String resolutionId;
    public boolean isExecuted = false;
    public double requiredRatio = 0.5;
    public int minimalSigners = 1;

    public AbstractResolution(Nation nation, SimplePlayer proposer) {
        this.requiredSigners = new HashSet<SimplePlayer>();
        if (proposer.getNation() == nation) {
            this.requiredSigners.add(proposer);
        }
        this.nation = nation;
        this.proposer = proposer;
        this.deadline = System.currentTimeMillis() + 259200000L;
        this.resolutionId = UUID.randomUUID().toString();
    }

    public void propose() {
        if (this.nation.getType().decisionMaker.makeDecision(this)) {
            for (AbstractResolution res : this.nation.resolutions.values()) {
                if (!res.equals(this)) continue;
                this.proposer.sendMessage(Message.getMessage("nation.resolution.duplicate-exists").add("resolution_id", res.resolutionId).add("resolution_name", res.getResolutionContent().toFormatted()));
                return;
            }
            this.nation.resolutions.put(this.resolutionId, this);
            Message.getMessage("nation.resolution.proposed").add("proposer", this.proposer.getName()).add("resolution_id", this.resolutionId).add("resolution_name", this.getResolutionContent().toFormatted()).send(this.nation.getMembers());
            if (!(this instanceof ImportantResolution) && !(this instanceof OutsiderResolution)) {
                this.sign(this.proposer);
            }
        } else {
            this.proposer.sendMessage(Message.getMessage("nation.resolution.cannot-propose"));
        }
    }

    public boolean checkDate() {
        return System.currentTimeMillis() <= this.deadline;
    }

    public boolean canSign(SimplePlayer player) {
        return !this.isExecuted && this.checkDate() && this.requiredSigners.contains(player) && !this.signedPlayers.contains(player);
    }

    public boolean canUnsign(SimplePlayer player) {
        return !this.isExecuted && this.checkDate() && this.signedPlayers.contains(player);
    }

    public void sign(SimplePlayer player) {
        if (!this.checkDate()) {
            return;
        }
        if (this.requiredSigners.contains(player) && !this.signedPlayers.contains(player) && !this.isExecuted) {
            this.signedPlayers.add(player);
            Message.getMessage("nation.resolution.signed").add("signer", player.getName()).add("resolution_id", this.resolutionId).add("resolution_name", this.getResolutionContent().toFormatted()).send(this.nation.getMembers());
            if (this.checkPass()) {
                Message.getMessage("nation.resolution.passed").add("resolution_id", this.resolutionId).add("resolution_name", this.getResolutionContent().toFormatted()).send(this.nation.getMembers());
                this.execute();
                this.isExecuted = true;
                this.cancel();
            }
        }
    }

    public void unsign(SimplePlayer player) {
        if (!this.checkDate()) {
            return;
        }
        if (!this.isExecuted && this.signedPlayers.contains(player)) {
            Message.getMessage("nation.resolution.unsigned").add("signer", player.getName()).add("resolution_id", this.resolutionId).add("resolution_name", this.getResolutionContent().toFormatted()).send(this.nation.getMembers());
            this.signedPlayers.remove(player);
        }
    }

    public boolean equals(AbstractResolution resolution) {
        return this.getResolutionContent().toString().equals(resolution.getResolutionContent().toString());
    }

    public void cancel() {
        this.nation.resolutions.remove(this.resolutionId);
    }

    public void setRequiredSigners(List<NationalRank> requiredSigners) {
        for (SimplePlayer player : this.nation.getMembers()) {
            if (!requiredSigners.contains(player.getRank())) continue;
            this.requiredSigners.add(player);
        }
    }

    public void addRequiredSigners(List<SimplePlayer> requiredSigners) {
        this.requiredSigners.addAll(requiredSigners);
    }

    public void setRequiredRatio(double requiredRatio) {
        this.requiredRatio = requiredRatio;
    }

    public void setMinimalSigners(int minimalSigners) {
        this.minimalSigners = minimalSigners;
    }

    public boolean checkPass() {
        return !this.isExecuted && ((double)this.signedPlayers.size() >= (double)this.requiredSigners.size() * this.requiredRatio && this.signedPlayers.size() >= Math.min(this.minimalSigners, this.requiredSigners.size()) || this.signedPlayers.contains(this.nation.getOwner()) && this.nation.getType() == NationType.MONARCHY);
    }

    public abstract void execute();

    @Nonnull
    public abstract Message getResolutionContent();
}

