/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.structure;

import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;

public class Hologram {
    public static Map<SimpleChunkLocation, Set<Hologram>> holograms = new HashMap<SimpleChunkLocation, Set<Hologram>>();
    public SimpleLocation location;
    public ArmorStand textDisplay = null;
    public String currentText;

    public Hologram(SimpleLocation location, String text) {
        this.location = location;
        if (!holograms.containsKey(location.getChunkLocation())) {
            holograms.put(location.getChunkLocation(), new HashSet());
        }
        holograms.get(location.getChunkLocation()).add(this);
        this.currentText = text;
        this.spawn();
    }

    public void spawn() {
        if (this.location.getChunkLocation().getChunk().isEntitiesLoaded() && this.textDisplay == null) {
            World world = this.location.getBukkitLocation().getWorld();
            if (world == null) {
                return;
            }
            this.textDisplay = (ArmorStand)world.spawnEntity(this.location.getBukkitLocation(), EntityType.ARMOR_STAND);
            this.textDisplay.setVisible(false);
            this.textDisplay.setCustomName(this.currentText);
            this.textDisplay.setCustomNameVisible(true);
            this.textDisplay.setGravity(false);
            this.textDisplay.setMarker(true);
            this.textDisplay.setCollidable(false);
        }
    }

    public void despawn() {
        if (this.location.getChunkLocation().getChunk().isEntitiesLoaded() && this.textDisplay != null) {
            this.textDisplay.remove();
            this.textDisplay = null;
        }
    }

    public static Hologram createHologram(@Nonnull SimpleLocation location, @Nonnull String text) {
        return new Hologram(location, text);
    }

    public void setText(String text) {
        this.currentText = text;
        if (this.textDisplay != null) {
            this.textDisplay.setCustomName(text);
        }
    }

    public void removeHologram() {
        if (holograms.containsKey(this.location.getChunkLocation())) {
            holograms.get(this.location.getChunkLocation()).remove(this);
            if (holograms.get(this.location.getChunkLocation()).isEmpty()) {
                holograms.remove(this.location.getChunkLocation());
            }
        }
        this.despawn();
    }
}

