/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.command;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.planetlib.command.ParameterType;
import cn.jason31416.planetlib.message.StaticMessages;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleSender;
import java.util.List;

public interface ICommandContext {
    public String getUsage(ParameterType ... var1);

    public SimplePlayer player();

    public SimpleSender sender();

    public List<String> args();

    public String getArg(int var1);

    public ICommandContext getSubContext();

    default public int getIntArg(int index) {
        Object result = ParameterType.INTEGER.handle(this.getArg(index));
        if (result == null) {
            return 0;
        }
        return (Integer)result;
    }

    default public double getDoubleArg(int index) {
        Object result = ParameterType.DOUBLE.handle(this.getArg(index));
        if (result == null) {
            return 0.0;
        }
        return (Double)result;
    }

    default public SimplePlayer getPlayerArg(int index) {
        Object result = ParameterType.PLAYER.handle(this.getArg(index));
        if (result == null) {
            return null;
        }
        return (SimplePlayer)result;
    }

    default public Nation getNationArg(int index) {
        Object result = ParameterType.NATION.handle(this.getArg(index));
        if (result == null) {
            return null;
        }
        return (Nation)result;
    }

    default public boolean checkArgs(ParameterType ... parameterTypes) {
        if (this.args().size() < parameterTypes.length) {
            this.sender().sendMessage(StaticMessages.INCORRECT_USAGE.add("usage", this.getUsage(parameterTypes)));
            return false;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].checker.handle(this.getArg(i)) != null) continue;
            this.sender().sendMessage(StaticMessages.INCORRECT_USAGE.add("usage", this.getUsage(parameterTypes)));
            return false;
        }
        return true;
    }

    default public int getCurrentArg() {
        if (this.args().isEmpty()) {
            return 1;
        }
        return this.args().size();
    }

    default public SimplePlayer getPlayer() {
        return this.player();
    }

    default public SimpleSender getSender() {
        return this.sender();
    }
}

