/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.command;

import cn.jason31416.planetlib.command.CommandContext;
import cn.jason31416.planetlib.command.ICommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.StaticMessages;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleSender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RootCommand
implements ICommand,
IParentCommand,
CommandExecutor,
TabCompleter {
    public Map<String, ICommand> subCommands = new HashMap<String, ICommand>();
    String name;

    public RootCommand(String name) {
        this.name = name;
    }

    public void register() {
        PluginCommand cmd = Bukkit.getPluginCommand((String)this.name);
        if (cmd != null) {
            cmd.setExecutor((CommandExecutor)this);
            cmd.setTabCompleter((TabCompleter)this);
        }
    }

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, @NotNull String[] strings) {
        CommandContext context = new CommandContext(Arrays.asList(strings), SimpleSender.of(commandSender), SimplePlayer.of(commandSender), this.name);
        if (context.args().isEmpty()) {
            Message msg = this.execute(context);
            if (msg != null) {
                context.sender().sendMessage(msg);
            }
            return true;
        }
        if (this.subCommands.containsKey(context.getArg(0))) {
            ICommand subCommand = this.subCommands.get(context.getArg(0));
            Message msg = subCommand.execute(context.getSubContext());
            if (msg != null) {
                context.sender().sendMessage(msg);
            }
        } else {
            context.sender().sendMessage(StaticMessages.UNKNOWN_COMMAND);
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, @NotNull String[] strings) {
        if (strings.length == 0) {
            return null;
        }
        CommandContext context = new CommandContext(Arrays.asList(strings), SimpleSender.of(commandSender), SimplePlayer.of(commandSender), this.name);
        return this.tabComplete(context);
    }

    @Override
    public void registerSubCommand(String name, ICommand command) {
        this.subCommands.put(name, command);
    }

    @Override
    @Nullable
    public abstract Message execute(ICommandContext var1);

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (context.args().size() == 1) {
            ArrayList<String> result = new ArrayList<String>();
            for (String key : this.subCommands.keySet()) {
                if (!key.startsWith(context.getArg(0))) continue;
                result.add(key);
            }
            return result;
        }
        if (this.subCommands.containsKey(context.getArg(0))) {
            ICommand subCommand = this.subCommands.get(context.getArg(0));
            return subCommand.tabComplete(context.getSubContext());
        }
        return null;
    }
}

