/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.command.tempAction;

import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TempAction {
    public static final Map<String, TempAction> actions = new HashMap<String, TempAction>();
    private final Action action;
    private final SimplePlayer forPlayer;
    private final long startTime;
    private final String uuid;

    public TempAction(Action action, SimplePlayer forPlayer) {
        this.action = action;
        this.forPlayer = forPlayer;
        this.startTime = System.currentTimeMillis();
        this.uuid = UUID.randomUUID().toString();
        actions.put(this.uuid, this);
    }

    public boolean execute(SimplePlayer player) {
        if (player.equals(this.forPlayer)) {
            this.action.execute();
            actions.remove(this.uuid);
            return true;
        }
        return false;
    }

    public static void checkAll() {
        for (String action : new ArrayList<String>(actions.keySet())) {
            if (System.currentTimeMillis() - TempAction.actions.get((Object)action).startTime <= 300000L) continue;
            actions.remove(action);
        }
    }

    public static void createAction(Action action, SimplePlayer forPlayer) {
        new TempAction(action, forPlayer);
    }

    public static interface Action {
        public void execute();
    }
}

