/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.gui;

import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.message.StaticMessages;
import cn.jason31416.planetlib.message.StringMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class GUILoader {
    public static Map<String, GUI> loadedGUIs = new HashMap<String, GUI>();

    private static GUI loadFromConfig(ConfigurationSection config) {
        GUI gui = new GUI();
        ConfigurationSection windowSettings = Objects.requireNonNull(config.getConfigurationSection("window"), "Incomplete config structure!");
        gui.title = windowSettings.getString("title", "");
        gui.size = windowSettings.getInt("size");
        if (windowSettings.contains("inputs")) {
            gui.inputs = new HashSet<Integer>(windowSettings.getIntegerList("inputs"));
        }
        ConfigurationSection items = Objects.requireNonNull(config.getConfigurationSection("container"), "Incomplete config structure!");
        for (String key : items.getKeys(false)) {
            ConfigurationSection item = Objects.requireNonNull(items.getConfigurationSection(key), "Incomplete config structure!");
            ArrayList<String> lore = new ArrayList<String>();
            if (item.contains("lore")) {
                for (String line : item.getStringList("lore")) {
                    lore.add(new StringMessage(line).toString());
                }
            }
            Material mat = Material.valueOf((String)item.getString("material", "AIR"));
            if (item.contains("skull")) {
                mat = Material.PLAYER_HEAD;
            }
            if (item.contains("slot")) {
                GUI.Item guiItem = gui.addItem(key, new StringMessage(item.getString("name", "")).toString(), item.getInt("slot"), mat, item.getInt("amount", 1));
                if (!lore.isEmpty()) {
                    guiItem.setLore(lore);
                }
                if (item.contains("model")) {
                    guiItem.setCustomModelData(item.getInt("model"));
                }
                if (item.contains("skull")) {
                    guiItem.setSkullID(item.getString("skull"));
                }
                if (!item.getBoolean("glow", false)) continue;
                guiItem.setGlow(true);
                continue;
            }
            List<GUI.Item> guiItems = gui.addItem(key, new StringMessage(item.getString("name", "")).toString(), item.getIntegerList("slots"), mat, item.getInt("amount", 1));
            if (!lore.isEmpty()) {
                for (GUI.Item guiItem : guiItems) {
                    guiItem.setLore(lore);
                }
            }
            if (item.contains("model")) {
                for (GUI.Item guiItem : guiItems) {
                    guiItem.setCustomModelData(item.getInt("model"));
                }
            }
            if (item.contains("skull")) {
                for (GUI.Item guiItem : guiItems) {
                    guiItem.setSkullID(item.getString("skull"));
                }
            }
            if (!item.getBoolean("glow", false)) continue;
            for (GUI.Item guiItem : guiItems) {
                guiItem.setGlow(true);
            }
        }
        return gui;
    }

    public static void loadFile(File path) {
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)path);
        for (String key : config.getKeys(false)) {
            try {
                loadedGUIs.put(key, GUILoader.loadFromConfig(Objects.requireNonNull(config.getConfigurationSection(key))));
            }
            catch (Exception e) {
                StaticMessages.ERROR_GUI_CONFIG.add("file", path.getName()).add("key", key).sendConsole();
                e.printStackTrace();
            }
        }
    }

    public static GUI getGUI(String name) {
        return loadedGUIs.get(name).copy();
    }
}

