/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.gui;

import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUILoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;

public abstract class GUISession {
    public static final Map<SimplePlayer, GUISession> sessions = new HashMap<SimplePlayer, GUISession>();
    public final SimplePlayer player;
    public GUI gui = null;

    public GUISession(SimplePlayer player) {
        this.player = player;
        if (sessions.containsKey(player)) {
            sessions.get(player).close();
        }
        sessions.put(player, this);
    }

    public abstract void constructGUI(String var1, GUI var2);

    public void display(GUI gui) {
        if (gui == null) {
            throw new IllegalArgumentException("GUI cannot be null");
        }
        this.gui = gui;
        gui.display(this.player);
    }

    public void handleClick(int slot, InventoryAction action, InventoryClickEvent event) {
        this.gui.handleClick(slot, this, action, event);
    }

    public void display(String guiID) {
        try {
            if (!GUILoader.loadedGUIs.containsKey(guiID)) {
                this.player.sendMessage(new StringMessage("<red>Error: Missing GUI " + guiID + ", please contact admin!"));
                this.player.getPlayer().closeInventory();
                PlanetLib.instance.getLogger().severe("Error: Missing GUI: " + guiID + "!");
                return;
            }
            GUI gui = GUILoader.getGUI(guiID);
            this.constructGUI(guiID, gui);
            this.display(gui);
        }
        catch (Exception e) {
            this.player.sendMessage(new StringMessage("<red>Error: Some Error has occured when loading GUI: " + guiID + ", please contact admin!"));
            PlanetLib.instance.getLogger().severe("Error while loading GUI: " + guiID + "!");
            e.printStackTrace();
        }
    }

    public void close() {
        sessions.remove(this.player);
        this.player.getPlayer().closeInventory();
    }

    public Inventory getCurrentInventory() {
        return this.gui.lstInventory;
    }
}

