/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.message;

import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import cn.jason31416.planetlib.wrapper.SimpleSender;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public interface Message {
    public Message add(String var1, Object var2);

    public String toString();

    default public String toFormatted() {
        return this.toString();
    }

    public void send(CommandSender var1);

    default public void send(SimpleSender sender) {
        this.send(sender.sender());
    }

    default public void send(SimplePlayer player) {
        if (player.isOnline()) {
            this.send((CommandSender)player.getPlayer());
        }
    }

    public void sendActionbar(Player var1);

    default public void sendActionbar(SimplePlayer player) {
        if (player.getPlayer() != null) {
            this.sendActionbar(player.getPlayer());
        }
    }

    default public void broadcast() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.send((CommandSender)player);
        }
        this.send((CommandSender)Bukkit.getConsoleSender());
    }

    default public void send(Collection<SimplePlayer> players) {
        for (SimplePlayer player : players) {
            if (!player.isOnline()) continue;
            this.send((CommandSender)player.getPlayer());
        }
    }

    public static Message getMessage(String key) {
        return MessageLoader.getMessage(key);
    }

    public static Message getMessage(String key, String defaultValue) {
        return MessageLoader.getMessage(key, defaultValue);
    }

    public static Message of(String content) {
        return new StringMessage(content);
    }
}

