/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.mob;

import cn.jason31416.planetlib.mob.SimpleMob;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import org.bukkit.Material;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class VanillaMob
implements SimpleMob {
    Mob entity;

    public VanillaMob(String name, EntityType type, SimpleLocation location) {
        EntityEquipment equipment;
        if (location.getBukkitLocation().getWorld() == null) {
            throw new IllegalArgumentException("Location must have a world");
        }
        this.entity = (Mob)location.getBukkitLocation().getWorld().spawnEntity(location.getBukkitLocation(), type);
        this.entity.setCustomName(name);
        this.entity.setCustomNameVisible(true);
        Mob mob = this.entity;
        if (mob instanceof Ageable) {
            Ageable ageableEntity = (Ageable)mob;
            ageableEntity.setAdult();
        }
        if ((equipment = this.entity.getEquipment()) != null) {
            equipment.setItemInMainHand(null);
            equipment.setItemInOffHand(null);
            equipment.setHelmet(new ItemStack(Material.IRON_HELMET));
            equipment.setChestplate(new ItemStack(Material.IRON_CHESTPLATE));
            equipment.setLeggings(new ItemStack(Material.IRON_LEGGINGS));
            equipment.setBoots(new ItemStack(Material.IRON_BOOTS));
        }
        this.entity.teleport(location.getBukkitLocation());
    }

    @Override
    public void teleport(SimpleLocation location) {
        this.entity.teleport(location.getBukkitLocation());
    }

    @Override
    public SimpleLocation getLocation() {
        return SimpleLocation.of(this.entity.getLocation());
    }

    @Override
    public boolean isAlive() {
        return !this.entity.isDead();
    }

    @Override
    public void damage(double hp) {
        this.entity.damage(hp);
    }

    @Override
    public void setMaxHealth(double hp) {
        this.entity.setMaxHealth(hp);
    }

    @Override
    public void setHealth(double hp) {
        this.entity.setHealth(hp);
        this.entity.setMaxHealth(hp);
    }

    @Override
    public Entity getBukkitEntity() {
        return this.entity;
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.entity.setTarget(target);
    }

    @Override
    public void remove() {
        this.entity.remove();
    }

    @Override
    public void setName(String name) {
        this.entity.setCustomName(name);
    }
}

