/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.update;

import cn.jason31416.planetlib.PlanetLib;
import cn.jason31416.planetlib.update.UpdateTask;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateCycle
extends BukkitRunnable {
    public static UpdateCycle instance;
    private static final Map<String, UpdateTask> tasks;
    public int tick = 0;

    public void run() {
        ++this.tick;
        for (final UpdateTask task : tasks.values()) {
            if (this.tick % task.interval != 0 || task.isExecuting) continue;
            new BukkitRunnable(){

                public void run() {
                    task.isExecuting = true;
                    try {
                        task.runnableTask.run();
                    }
                    catch (Exception e) {
                        task.isExecuting = false;
                        throw e;
                    }
                    task.isExecuting = false;
                }
            }.runTaskAsynchronously((Plugin)PlanetLib.instance);
        }
    }

    public static void start() {
        if (instance != null) {
            instance.cancel();
        }
        instance = new UpdateCycle();
        instance.runTaskTimer((Plugin)PlanetLib.instance, 0L, 1L);
    }

    public static void registerTask(String name, UpdateTask task) {
        if (tasks.containsKey(name)) {
            return;
        }
        tasks.put(name, task);
    }

    public static void setInterval(String name, int interval) {
        if (!tasks.containsKey(name)) {
            return;
        }
        UpdateCycle.tasks.get((Object)name).interval = interval;
    }

    public static void unregisterTask(String name) {
        tasks.remove(name);
    }

    public static void unregisterAllTasks() {
        tasks.clear();
    }

    public static void stop() {
        instance.cancel();
        UpdateCycle.unregisterAllTasks();
    }

    static {
        tasks = new HashMap<String, UpdateTask>();
    }
}

