/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.wrapper;

import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record SimpleChunkLocation(int x, int z, SimpleWorld world) implements ConfigurationSerializable
{
    public World getBukkitWorld() {
        return this.world.getBukkitWorld();
    }

    public Chunk getChunk() {
        return this.world.getBukkitWorld().getChunkAt(this.x, this.z);
    }

    public SimpleChunkLocation getRelative(int dx, int dz) {
        return new SimpleChunkLocation(this.x + dx, this.z + dz, this.world);
    }

    public SimpleChunkLocation getRelative(Direction dir) {
        if (dir == Direction.EAST) {
            return this.getRelative(1, 0);
        }
        if (dir == Direction.WEST) {
            return this.getRelative(-1, 0);
        }
        if (dir == Direction.SOUTH) {
            return this.getRelative(0, 1);
        }
        return this.getRelative(0, -1);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleChunkLocation)) {
            return false;
        }
        SimpleChunkLocation other = (SimpleChunkLocation)obj;
        return this.x == other.x && this.z == other.z && this.world.equals(other.world);
    }

    @Override
    public String toString() {
        return "SimpleChunkLocation(x=" + this.x + ", z=" + this.z + ", world=" + this.world + ")";
    }

    public static SimpleChunkLocation of(Chunk chunk) {
        return new SimpleChunkLocation(chunk.getX(), chunk.getZ(), SimpleWorld.of(chunk.getWorld()));
    }

    public double distance(SimpleChunkLocation other) {
        double dx = this.x - other.x;
        double dz = this.z - other.z;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public Collection<SimpleChunkLocation> getAdjacentChunks() {
        int[] dx = new int[]{-1, 0, 1, 0};
        int[] dz = new int[]{0, -1, 0, 1};
        ArrayList<SimpleChunkLocation> result = new ArrayList<SimpleChunkLocation>();
        for (int i = 0; i < 4; ++i) {
            result.add(this.getRelative(dx[i], dz[i]));
        }
        return result;
    }

    public Collection<SimpleChunkLocation> getDiagAdjacentChunks() {
        int[] dx = new int[]{-1, -1, 1, 1};
        int[] dz = new int[]{1, -1, 1, -1};
        ArrayList<SimpleChunkLocation> result = new ArrayList<SimpleChunkLocation>();
        for (int i = 0; i < 4; ++i) {
            result.add(this.getRelative(dx[i], dz[i]));
        }
        return result;
    }

    public Collection<SimpleChunkLocation> getEightAdjacentChunks() {
        int[] dx = new int[]{-1, 0, 1, 0, -1, -1, 1, 1};
        int[] dz = new int[]{0, -1, 0, 1, -1, 1, -1, 1};
        ArrayList<SimpleChunkLocation> result = new ArrayList<SimpleChunkLocation>();
        for (int i = 0; i < 8; ++i) {
            result.add(this.getRelative(dx[i], dz[i]));
        }
        return result;
    }

    public boolean isClaimed() {
        return Nation.chunkNationMap.containsKey(this);
    }

    public boolean isTownChunk() {
        return Town.chunkTownMap.containsKey(this);
    }

    @Nullable
    public Town getTown() {
        return Town.chunkTownMap.get(this);
    }

    @Nullable
    public Nation getNation() {
        return Nation.chunkNationMap.get(this);
    }

    public void unclaim() {
        if (this.getNation() != null) {
            this.getNation().unclaim(this);
        }
    }

    public static SimpleChunkLocation of(int x, int z, SimpleWorld world) {
        return new SimpleChunkLocation(x, z, world);
    }

    public static SimpleChunkLocation of(int x, int z) {
        return new SimpleChunkLocation(x, z, SimpleWorld.defaultWorld());
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("world", this.world().getName());
        data.put("x", this.x);
        data.put("z", this.z);
        return data;
    }

    public static SimpleChunkLocation deserialize(Map<String, Object> map) {
        SimpleWorld world = SimpleWorld.of(UUID.fromString((String)map.get("world")));
        int x = (Integer)map.get("x");
        int z = (Integer)map.get("z");
        return new SimpleChunkLocation(x, z, world);
    }

    public static enum Direction {
        EAST,
        WEST,
        NORTH,
        SOUTH;

    }
}

