/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.wrapper;

import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleWorld;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.jetbrains.annotations.NotNull;

public record SimpleLocation(double x, double y, double z, SimpleWorld world) implements ConfigurationSerializable
{
    public SimpleLocation getRelative(double dx, double dy, double dz) {
        return new SimpleLocation(this.x + dx, this.y + dy, this.z + dz, this.world);
    }

    public SimpleLocation getBlockLocation() {
        return new SimpleLocation(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z), this.world);
    }

    public Block getBlock() {
        return this.world.getBukkitWorld().getBlockAt((int)this.x, (int)this.y, (int)this.z);
    }

    public Location getBukkitLocation() {
        return new Location(this.world.getBukkitWorld(), this.x, this.y, this.z);
    }

    public SimpleChunkLocation getChunkLocation() {
        return new SimpleChunkLocation((int)Math.floor(this.x / 16.0), (int)Math.floor(this.z / 16.0), this.world);
    }

    public static SimpleLocation of(Location location) {
        return new SimpleLocation(location.getX(), location.getY(), location.getZ(), SimpleWorld.of(location.getWorld()));
    }

    public static SimpleLocation of(Block block) {
        return new SimpleLocation(block.getX(), block.getY(), block.getZ(), SimpleWorld.of(block.getWorld()));
    }

    public static SimpleLocation of(double x, double y, double z, SimpleWorld world) {
        return new SimpleLocation(x, y, z, world);
    }

    public Material getBlockMaterial() {
        return this.getBlock().getType();
    }

    public void setBlockMaterial(Material material) {
        this.getBlock().setType(material);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleLocation)) {
            return false;
        }
        SimpleLocation other = (SimpleLocation)obj;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.world.equals(other.world);
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.x) ^ Double.hashCode(this.y) ^ Double.hashCode(this.z) ^ this.world.hashCode();
    }

    @NotNull
    public Map<String, Object> serialize() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("world", this.world().getName());
        data.put("x", this.x);
        data.put("y", this.y);
        data.put("z", this.z);
        return data;
    }

    public static SimpleLocation deserialize(Map<String, Object> map) {
        SimpleWorld world = SimpleWorld.of(UUID.fromString((String)map.get("world")));
        int x = (Integer)map.get("x");
        int y = (Integer)map.get("y");
        int z = (Integer)map.get("z");
        return new SimpleLocation(x, y, z, world);
    }
}

