/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.planetlib.wrapper;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class SimpleWorld {
    private final World world;

    public SimpleWorld(World world) {
        this.world = world;
    }

    public World getBukkitWorld() {
        return this.world;
    }

    public String getName() {
        return this.world.getName();
    }

    public static SimpleWorld of(World world) {
        return new SimpleWorld(world);
    }

    public static SimpleWorld of(UUID worldUUID) {
        return new SimpleWorld(Bukkit.getWorld((UUID)worldUUID));
    }

    public static SimpleWorld of(String worldName) {
        return new SimpleWorld(Bukkit.getWorld((String)worldName));
    }

    public static SimpleWorld defaultWorld() {
        return new SimpleWorld((World)Bukkit.getWorlds().get(0));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SimpleWorld)) {
            return false;
        }
        SimpleWorld other = (SimpleWorld)obj;
        return this.world.equals(other.world);
    }

    public int hashCode() {
        return this.world.getUID().hashCode();
    }

    public String toString() {
        return "SimpleWorld(" + this.getName() + ")";
    }
}

