/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.lib.nbtapi;

import cn.jason31416.betternations.lib.nbtapi.NBTCompound;
import cn.jason31416.betternations.lib.nbtapi.NBTCompoundList;
import cn.jason31416.betternations.lib.nbtapi.NBTContainer;
import cn.jason31416.betternations.lib.nbtapi.NBTDoubleList;
import cn.jason31416.betternations.lib.nbtapi.NBTFloatList;
import cn.jason31416.betternations.lib.nbtapi.NBTIntArrayList;
import cn.jason31416.betternations.lib.nbtapi.NBTIntegerList;
import cn.jason31416.betternations.lib.nbtapi.NBTList;
import cn.jason31416.betternations.lib.nbtapi.NBTListCompound;
import cn.jason31416.betternations.lib.nbtapi.NBTLongList;
import cn.jason31416.betternations.lib.nbtapi.NBTStringList;
import cn.jason31416.betternations.lib.nbtapi.NBTType;
import cn.jason31416.betternations.lib.nbtapi.NBTUUIDList;
import cn.jason31416.betternations.lib.nbtapi.NbtApiException;
import cn.jason31416.betternations.lib.nbtapi.utils.DataFixerUtil;
import cn.jason31416.betternations.lib.nbtapi.utils.GsonWrapper;
import cn.jason31416.betternations.lib.nbtapi.utils.MinecraftVersion;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ClassWrapper;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.MojangToMapping;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ObjectCreator;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ReflectionMethod;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class NBTReflectionUtil {
    private static Field field_unhandledTags = null;
    private static Field field_handle = null;
    private static Object type_custom_data = null;
    private static Object registry_access = null;
    private static final NBTContainer dummyNBT;

    private NBTReflectionUtil() {
    }

    public static Object getNMSEntity(Entity entity) {
        try {
            return ReflectionMethod.CRAFT_ENTITY_GET_HANDLE.run(ClassWrapper.CRAFT_ENTITY.getClazz().cast(entity), new Object[0]);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting the NMS Entity from a Bukkit Entity!", e2);
        }
    }

    public static Object readNBT(InputStream stream) {
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R3)) {
                return ReflectionMethod.NBTFILE_READV2.run(null, stream, ReflectionMethod.NBTACCOUNTER_CREATE_UNLIMITED.run(null, new Object[0]));
            }
            return ReflectionMethod.NBTFILE_READ.run(null, stream);
        }
        catch (Exception e2) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new NbtApiException("Exception while reading a NBT File!", e2);
        }
    }

    public static Object writeNBT(Object nbt, OutputStream stream) {
        try {
            return ReflectionMethod.NBTFILE_WRITE.run(null, nbt, stream);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while writing NBT!", e2);
        }
    }

    public static Object getCraftItemHandle(ItemStack item) {
        try {
            return field_handle.get(item);
        }
        catch (IllegalAccessException | IllegalArgumentException e2) {
            throw new NbtApiException("Error getting handle from " + item.getClass(), e2);
        }
    }

    public static void writeApiNBT(NBTCompound comp, OutputStream stream) {
        try {
            Object workingtag = comp.getResolvedObject();
            ReflectionMethod.NBTFILE_WRITE.run(null, workingtag, stream);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while writing NBT!", e2);
        }
    }

    public static Object getItemRootNBTTagCompound(Object nmsitem) {
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                Object customData = ReflectionMethod.NMSDATACOMPONENTHOLDER_GET.run(nmsitem, type_custom_data);
                if (customData == null) {
                    return null;
                }
                return ReflectionMethod.NMSCUSTOMDATA_GETCOPY.run(customData, new Object[0]);
            }
            Object answer = ReflectionMethod.NMSITEM_GETTAG.run(nmsitem, new Object[0]);
            return answer;
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting an Itemstack's NBTCompound!", e2);
        }
    }

    public static void setItemStackCompound(Object nmsItem, Object compound) {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
            if (compound == null) {
                ReflectionMethod.NMSITEM_SET.run(nmsItem, type_custom_data, null);
            } else {
                ReflectionMethod.NMSITEM_SET.run(nmsItem, type_custom_data, ObjectCreator.NMS_CUSTOMDATA.getInstance(compound));
            }
        } else {
            ReflectionMethod.ITEMSTACK_SET_TAG.run(nmsItem, compound);
        }
    }

    public static Object convertNBTCompoundtoNMSItem(NBTCompound nbtcompound) {
        try {
            Object nmsComp = NBTReflectionUtil.getToCompount(nbtcompound.getCompound(), nbtcompound);
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                if (nbtcompound.hasTag("tag")) {
                    nmsComp = DataFixerUtil.fixUpRawItemData(nmsComp, 3700, DataFixerUtil.getCurrentVersion());
                }
                return ReflectionMethod.NMSITEM_LOAD.run(null, registry_access, nmsComp);
            }
            if (MinecraftVersion.getVersion().getVersionId() >= MinecraftVersion.MC1_11_R1.getVersionId()) {
                return ObjectCreator.NMS_COMPOUNDFROMITEM.getInstance(nmsComp);
            }
            return ReflectionMethod.NMSITEM_CREATESTACK.run(null, nmsComp);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while converting NBTCompound to NMS ItemStack!", e2);
        }
    }

    public static NBTContainer convertNMSItemtoNBTCompound(Object nmsitem) {
        try {
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                return new NBTContainer(ReflectionMethod.NMSITEM_SAVE_MODERN.run(nmsitem, registry_access));
            }
            Object answer = ReflectionMethod.NMSITEM_SAVE.run(nmsitem, ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]));
            return new NBTContainer(answer);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while converting NMS ItemStack to NBTCompound!", e2);
        }
    }

    @Deprecated
    public static Map<String, Object> getUnhandledNBTTags(ItemMeta meta) {
        try {
            return (Map)field_unhandledTags.get(meta);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting unhandled tags from ItemMeta!", e2);
        }
    }

    public static Object getEntityNBTTagCompound(Object nmsEntity) {
        try {
            Object nbt = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
            Object answer = ReflectionMethod.NMS_ENTITY_GET_NBT.run(nmsEntity, nbt);
            if (answer == null) {
                answer = nbt;
            }
            return answer;
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting NBTCompound from NMS Entity!", e2);
        }
    }

    public static Object setEntityNBTTag(Object nbtTag, Object nmsEntity) {
        try {
            ReflectionMethod.NMS_ENTITY_SET_NBT.run(nmsEntity, nbtTag);
            return nmsEntity;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while setting the NBTCompound of an Entity", ex);
        }
    }

    public static Object getTileEntityNBTTagCompound(BlockState tile) {
        try {
            Object cworld = ClassWrapper.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o2 = null;
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                o2 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY_1_7_10.run(nmsworld, tile.getX(), tile.getY(), tile.getZ());
            } else {
                Object pos = ObjectCreator.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
                o2 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            }
            if (o2 == null) {
                throw new NbtApiException("The passed BlockState(" + tile.getType() + ") doesn't point to a BlockEntity. Only BlockEntities like Chest/Signs/Furnance/etc have NBT.");
            }
            Object answer = null;
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                answer = ReflectionMethod.TILEENTITY_GET_NBT_1205.run(o2, registry_access);
            } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1)) {
                answer = ReflectionMethod.TILEENTITY_GET_NBT_1181.run(o2, new Object[0]);
            } else {
                answer = ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance();
                ReflectionMethod.TILEENTITY_GET_NBT.run(o2, answer);
            }
            if (answer == null) {
                throw new NbtApiException("Unable to get NBTCompound from TileEntity! " + tile + " " + o2);
            }
            return answer;
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting NBTCompound from TileEntity!", e2);
        }
    }

    public static void setTileEntityNBTTagCompound(BlockState tile, Object comp) {
        try {
            Object cworld = ClassWrapper.CRAFT_WORLD.getClazz().cast(tile.getWorld());
            Object nmsworld = ReflectionMethod.CRAFT_WORLD_GET_HANDLE.run(cworld, new Object[0]);
            Object o2 = null;
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                o2 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY_1_7_10.run(nmsworld, tile.getX(), tile.getY(), tile.getZ());
            } else {
                Object pos = ObjectCreator.NMS_BLOCKPOSITION.getInstance(tile.getX(), tile.getY(), tile.getZ());
                o2 = ReflectionMethod.NMS_WORLD_GET_TILEENTITY.run(nmsworld, pos);
            }
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
                ReflectionMethod.TILEENTITY_SET_NBT_1205.run(o2, comp, registry_access);
            } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
                ReflectionMethod.TILEENTITY_SET_NBT.run(o2, comp);
            } else if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
                Object blockData = ReflectionMethod.TILEENTITY_GET_BLOCKDATA.run(o2, new Object[0]);
                ReflectionMethod.TILEENTITY_SET_NBT_LEGACY1161.run(o2, blockData, comp);
            } else {
                ReflectionMethod.TILEENTITY_SET_NBT_LEGACY1151.run(o2, comp);
            }
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while setting NBTData for a TileEntity!", e2);
        }
    }

    public static Object getSubNBTTagCompound(Object compound, String name) {
        try {
            if (((Boolean)ReflectionMethod.COMPOUND_HAS_KEY.run(compound, name)).booleanValue()) {
                return ReflectionMethod.COMPOUND_GET_COMPOUND.run(compound, name);
            }
            throw new NbtApiException("Tried getting invalid compound '" + name + "' from '" + compound + "'!");
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while getting NBT subcompounds!", e2);
        }
    }

    public static void addNBTTagCompound(NBTCompound comp, String name) {
        if (name == null) {
            NBTReflectionUtil.remove(comp, name);
            return;
        }
        Object nbttag = comp.getCompound();
        if (nbttag == null) {
            nbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp)) {
            return;
        }
        Object workingtag = NBTReflectionUtil.getToCompount(nbttag, comp);
        try {
            ReflectionMethod.COMPOUND_SET.run(workingtag, name, ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().newInstance());
            comp.setCompound(nbttag);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while adding a Compound!", e2);
        }
    }

    public static boolean valideCompound(NBTCompound comp) {
        Object root = comp.getCompound();
        if (root == null) {
            root = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        Object tmp = NBTReflectionUtil.getToCompount(root, comp);
        comp.setResolvedObject(tmp);
        return tmp != null;
    }

    public static Object getToCompount(Object nbttag, NBTCompound comp) {
        ArrayDeque<String> structure = new ArrayDeque<String>();
        while (comp.getParent() != null) {
            structure.add(comp.getName());
            comp = comp.getParent();
        }
        while (!structure.isEmpty()) {
            String target = (String)structure.pollLast();
            if ((nbttag = NBTReflectionUtil.getSubNBTTagCompound(nbttag, target)) != null) continue;
            throw new NbtApiException("Unable to find tag '" + target + "' in " + nbttag);
        }
        return nbttag;
    }

    public static void mergeOtherNBTCompound(NBTCompound comp, NBTCompound nbtcompoundSrc) {
        Object workingtagSrc = nbtcompoundSrc.getResolvedObject();
        if (workingtagSrc == null) {
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp)) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.getToCompount(rootnbttag, comp);
        try {
            ReflectionMethod.COMPOUND_MERGE.run(workingtag, workingtagSrc);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while merging two NBTCompounds!", e2);
        }
    }

    public static void set(NBTCompound comp, String key, Object val) {
        if (val == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp)) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.getToCompount(rootnbttag, comp);
        try {
            ReflectionMethod.COMPOUND_SET.run(workingtag, key, val);
            comp.setCompound(rootnbttag);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while setting key '" + key + "' to '" + val + "'!", e2);
        }
    }

    public static <T> NBTList<T> getList(NBTCompound comp, String key, NBTType type, Class<T> clazz) {
        Object workingtag = comp.getResolvedObject();
        if (workingtag == null) {
            workingtag = dummyNBT.getCompound();
        }
        try {
            Object nbt = ReflectionMethod.COMPOUND_GET_LIST.run(workingtag, key, type.getId());
            if (clazz == String.class) {
                return new NBTStringList(comp, key, type, nbt);
            }
            if (clazz == NBTListCompound.class) {
                return new NBTCompoundList(comp, key, type, nbt);
            }
            if (clazz == Integer.class) {
                return new NBTIntegerList(comp, key, type, nbt);
            }
            if (clazz == Float.class) {
                return new NBTFloatList(comp, key, type, nbt);
            }
            if (clazz == Double.class) {
                return new NBTDoubleList(comp, key, type, nbt);
            }
            if (clazz == Long.class) {
                return new NBTLongList(comp, key, type, nbt);
            }
            if (clazz == int[].class) {
                return new NBTIntArrayList(comp, key, type, nbt);
            }
            if (clazz == UUID.class) {
                return new NBTUUIDList(comp, key, type, nbt);
            }
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while getting a list with the type '" + (Object)((Object)type) + "'!", ex);
        }
    }

    public static NBTType getListType(NBTCompound comp, String key) {
        Object workingtag = comp.getResolvedObject();
        if (workingtag == null) {
            workingtag = dummyNBT.getCompound();
        }
        try {
            Field f2;
            Object nbt = ReflectionMethod.COMPOUND_GET.run(workingtag, key);
            String fieldname = "type";
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
                fieldname = "w";
            }
            try {
                f2 = nbt.getClass().getDeclaredField(fieldname);
            }
            catch (NoSuchFieldException ignore) {
                f2 = nbt.getClass().getDeclaredField("type");
            }
            f2.setAccessible(true);
            return NBTType.valueOf(f2.getByte(nbt));
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while getting the list type!", ex);
        }
    }

    public static Object getEntry(NBTCompound comp, String key) {
        Object workingtag = comp.getResolvedObject();
        try {
            return ReflectionMethod.COMPOUND_GET.run(workingtag, key);
        }
        catch (Exception ex) {
            throw new NbtApiException("Exception while getting an Entry!", ex);
        }
    }

    public static void setObject(NBTCompound comp, String key, Object value) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return;
        }
        try {
            String json = GsonWrapper.getString(value);
            NBTReflectionUtil.setData(comp, ReflectionMethod.COMPOUND_SET_STRING, key, json);
        }
        catch (Exception e2) {
            throw new NbtApiException("Exception while setting the Object '" + value + "'!", e2);
        }
    }

    public static <T> T getObject(NBTCompound comp, String key, Class<T> type) {
        if (!MinecraftVersion.hasGsonSupport()) {
            return null;
        }
        String json = (String)NBTReflectionUtil.getData(comp, ReflectionMethod.COMPOUND_GET_STRING, key);
        if (json == null) {
            return null;
        }
        return GsonWrapper.deserializeJson(json, type);
    }

    public static void remove(NBTCompound comp, String key) {
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            return;
        }
        if (!NBTReflectionUtil.valideCompound(comp)) {
            return;
        }
        Object workingtag = NBTReflectionUtil.getToCompount(rootnbttag, comp);
        ReflectionMethod.COMPOUND_REMOVE_KEY.run(workingtag, key);
        comp.setCompound(rootnbttag);
    }

    public static Set<String> getKeys(NBTCompound comp) {
        Object workingtag = comp.getResolvedObject();
        if (workingtag == null) {
            return Collections.emptySet();
        }
        return (Set)ReflectionMethod.COMPOUND_GET_KEYS.run(workingtag, new Object[0]);
    }

    public static void setData(NBTCompound comp, ReflectionMethod type, String key, Object data) {
        if (data == null) {
            NBTReflectionUtil.remove(comp, key);
            return;
        }
        Object rootnbttag = comp.getCompound();
        if (rootnbttag == null) {
            rootnbttag = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!NBTReflectionUtil.valideCompound(comp)) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        Object workingtag = NBTReflectionUtil.getToCompount(rootnbttag, comp);
        type.run(workingtag, key, data);
        comp.setCompound(rootnbttag);
    }

    public static Object getData(NBTCompound comp, ReflectionMethod type, String key) {
        Object workingtag = comp.getResolvedObject();
        if (workingtag == null) {
            workingtag = dummyNBT.getCompound();
        }
        return type.run(workingtag, key);
    }

    static {
        try {
            field_unhandledTags = ClassWrapper.CRAFT_METAITEM.getClazz().getDeclaredField("unhandledTags");
            field_unhandledTags.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        try {
            field_handle = ClassWrapper.CRAFT_ITEMSTACK.getClazz().getDeclaredField("handle");
            field_handle.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
            try {
                Field typeField = ClassWrapper.NMS_DATACOMPONENTS.getClazz().getDeclaredField(MojangToMapping.getMapping().get("net.minecraft.core.component.DataComponents#CUSTOM_DATA"));
                type_custom_data = typeField.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException typeField) {
                // empty catch block
            }
            try {
                Object nmsServer = ReflectionMethod.NMSSERVER_GETSERVER.run(Bukkit.getServer(), new Object[0]);
                registry_access = ReflectionMethod.NMSSERVER_GETREGISTRYACCESS.run(nmsServer, new Object[0]);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        dummyNBT = new NBTContainer();
    }
}

