/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.lib.nbtapi.utils;

import cn.jason31416.betternations.lib.nbtapi.NBTCompound;
import cn.jason31416.betternations.lib.nbtapi.NBTContainer;
import cn.jason31416.betternations.lib.nbtapi.NBTReflectionUtil;
import cn.jason31416.betternations.lib.nbtapi.NbtApiException;
import cn.jason31416.betternations.lib.nbtapi.iface.ReadWriteNBT;
import cn.jason31416.betternations.lib.nbtapi.utils.MinecraftVersion;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ClassWrapper;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.MojangToMapping;
import cn.jason31416.betternations.lib.nbtapi.utils.nmsmappings.ReflectionMethod;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;

public class DataFixerUtil {
    public static final int VERSION1_12_2 = 1343;
    public static final int VERSION1_16_5 = 2586;
    public static final int VERSION1_17_1 = 2730;
    public static final int VERSION1_18_2 = 2975;
    public static final int VERSION1_19_2 = 3120;
    public static final int VERSION1_19_4 = 3337;
    public static final int VERSION1_20_1 = 3465;
    public static final int VERSION1_20_2 = 3578;
    public static final int VERSION1_20_4 = 3700;
    public static final int VERSION1_20_5 = 3837;
    public static final int VERSION1_21 = 3953;

    public static Object fixUpRawItemData(Object nbt, int fromVersion, int toVersion) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        DataFixer dataFixer = (DataFixer)ReflectionMethod.GET_DATAFIXER.run(null, new Object[0]);
        DSL.TypeReference itemStackReference = (DSL.TypeReference)ClassWrapper.NMS_REFERENCES.getClazz().getField(MojangToMapping.getMapping().get("net.minecraft.util.datafix.fixes.References#ITEM_STACK")).get(null);
        DynamicOps nbtOps = (DynamicOps)ClassWrapper.NMS_NBTOPS.getClazz().getField(MojangToMapping.getMapping().get("net.minecraft.nbt.NbtOps#INSTANCE")).get(null);
        Dynamic fixed = dataFixer.update(itemStackReference, new Dynamic(nbtOps, nbt), fromVersion, toVersion);
        return fixed.getValue();
    }

    public static ReadWriteNBT fixUpItemData(ReadWriteNBT nbt, int fromVersion, int toVersion) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        return new NBTContainer(DataFixerUtil.fixUpRawItemData(NBTReflectionUtil.getToCompount(((NBTCompound)nbt).getCompound(), (NBTCompound)nbt), fromVersion, toVersion));
    }

    public static int getCurrentVersion() {
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_21_R1)) {
            return 3953;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R4)) {
            return 3837;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R3)) {
            return 3700;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_20_R1)) {
            return 3465;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R3)) {
            return 3337;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_19_R1)) {
            return 3120;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_18_R1)) {
            return 2975;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_17_R1)) {
            return 2730;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
            return 2586;
        }
        if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_12_R1)) {
            return 1343;
        }
        throw new NbtApiException("Trying to update data *to* a version before 1.12.2? Something is probably going wrong, contact the plugin author.");
    }
}

