/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import me.clip.placeholderapi.commands.PlaceholderCommandRouter;
import me.clip.placeholderapi.configuration.PlaceholderAPIConfig;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Version;
import me.clip.placeholderapi.expansion.manager.CloudExpansionManager;
import me.clip.placeholderapi.expansion.manager.LocalExpansionManager;
import me.clip.placeholderapi.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.clip.placeholderapi.listeners.ServerLoadEventListener;
import me.clip.placeholderapi.metrics.bukkit.Metrics;
import me.clip.placeholderapi.metrics.charts.AdvancedPie;
import me.clip.placeholderapi.metrics.charts.SimplePie;
import me.clip.placeholderapi.updatechecker.UpdateChecker;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderAPIPlugin
extends JavaPlugin {
    @NotNull
    private static final Version VERSION;
    private static PlaceholderAPIPlugin instance;
    @NotNull
    private final PlaceholderAPIConfig config = new PlaceholderAPIConfig(this);
    @NotNull
    private final LocalExpansionManager localExpansionManager = new LocalExpansionManager(this);
    @NotNull
    private final CloudExpansionManager cloudExpansionManager = new CloudExpansionManager(this);
    private BukkitAudiences adventure;

    @NotNull
    public static PlaceholderAPIPlugin getInstance() {
        return instance;
    }

    @NotNull
    public static String booleanTrue() {
        return PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().booleanTrue();
    }

    @NotNull
    public static String booleanFalse() {
        return PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().booleanFalse();
    }

    @NotNull
    public static SimpleDateFormat getDateFormat() {
        try {
            return new SimpleDateFormat(PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().dateFormat());
        }
        catch (IllegalArgumentException ex) {
            Msg.warn("Configured date format ('%s') is invalid! Defaulting to 'MM/dd/yy HH:mm:ss'", ex, PlaceholderAPIPlugin.getInstance().getPlaceholderAPIConfig().dateFormat());
            return new SimpleDateFormat("MM/dd/yy HH:mm:ss");
        }
    }

    @Deprecated
    public static Version getServerVersion() {
        return VERSION;
    }

    public void onLoad() {
        instance = this;
        this.saveDefaultConfig();
    }

    public void onEnable() {
        this.setupCommand();
        this.setupMetrics();
        this.setupExpansions();
        this.adventure = BukkitAudiences.create((Plugin)this);
        if (this.config.isCloudEnabled()) {
            this.getCloudExpansionManager().load();
        }
        if (this.config.checkUpdates()) {
            new UpdateChecker(this).fetch();
        }
    }

    public void onDisable() {
        this.getCloudExpansionManager().kill();
        this.getLocalExpansionManager().kill();
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        this.adventure.close();
        this.adventure = null;
        instance = null;
    }

    public void reloadConf(@NotNull CommandSender sender) {
        this.getLocalExpansionManager().kill();
        this.reloadConfig();
        this.getLocalExpansionManager().load(sender);
        if (this.config.isCloudEnabled()) {
            this.getCloudExpansionManager().load();
        } else {
            this.getCloudExpansionManager().kill();
        }
    }

    @NotNull
    public LocalExpansionManager getLocalExpansionManager() {
        return this.localExpansionManager;
    }

    @NotNull
    public CloudExpansionManager getCloudExpansionManager() {
        return this.cloudExpansionManager;
    }

    @NotNull
    public BukkitAudiences getAdventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    @NotNull
    public PlaceholderAPIConfig getPlaceholderAPIConfig() {
        return this.config;
    }

    private void setupCommand() {
        PluginCommand pluginCommand = this.getCommand("placeholderapi");
        if (pluginCommand == null) {
            return;
        }
        PlaceholderCommandRouter router = new PlaceholderCommandRouter(this);
        pluginCommand.setExecutor((CommandExecutor)router);
        pluginCommand.setTabCompleter((TabCompleter)router);
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this, 438);
        metrics.addCustomChart(new SimplePie("using_expansion_cloud", () -> this.getPlaceholderAPIConfig().isCloudEnabled() ? "yes" : "no"));
        metrics.addCustomChart(new SimplePie("using_spigot", () -> PlaceholderAPIPlugin.getServerVersion().isSpigot() ? "yes" : "no"));
        metrics.addCustomChart(new AdvancedPie("expansions_used", () -> {
            HashMap<String, Integer> values = new HashMap<String, Integer>();
            for (PlaceholderExpansion expansion : this.getLocalExpansionManager().getExpansions()) {
                values.put(expansion.getRequiredPlugin() == null ? expansion.getIdentifier() : expansion.getRequiredPlugin(), 1);
            }
            return values;
        }));
    }

    private void setupExpansions() {
        Bukkit.getPluginManager().registerEvents((Listener)this.getLocalExpansionManager(), (Plugin)this);
        try {
            Class.forName("org.bukkit.event.server.ServerLoadEvent");
            new ServerLoadEventListener(this);
        }
        catch (ClassNotFoundException ignored) {
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.getLocalExpansionManager().load((CommandSender)Bukkit.getConsoleSender()), 1L);
        }
    }

    static {
        boolean isSpigot;
        String version = Bukkit.getServer().getBukkitVersion().split("-")[0];
        if (version.chars().filter(c2 -> c2 == 46).count() == 1L) {
            String suffix = "R1";
            version = 'v' + version.replace('.', '_') + '_' + suffix;
        } else {
            int minor = Integer.parseInt(version.split("\\.")[2].charAt(0) + "");
            version = 'v' + version.replace('.', '_').replace("_" + minor, "") + '_' + "R" + (minor - 1);
        }
        try {
            Class.forName("org.spigotmc.SpigotConfig");
            isSpigot = true;
        }
        catch (ClassNotFoundException | ExceptionInInitializerError ignored) {
            isSpigot = false;
        }
        VERSION = new Version(version, isSpigot);
    }
}

