/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands.impl.local;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.commands.PlaceholderCommand;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandDump
extends PlaceholderCommand {
    @NotNull
    private static final String URL = "https://paste.helpch.at/";
    @NotNull
    private static final Gson gson = new Gson();
    @NotNull
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withLocale(Locale.US).withZone(ZoneId.of("UTC"));

    public CommandDump() {
        super("dump", new String[0]);
    }

    @Override
    public void evaluate(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params) {
        this.postDump(this.makeDump(plugin)).whenComplete((key, exception) -> {
            if (exception != null) {
                plugin.getLogger().log(Level.WARNING, "failed to post dump details", (Throwable)exception);
                Msg.msg(sender, "&cFailed to post dump details, check console.");
                return;
            }
            Msg.msg(sender, "&aSuccessfully posted dump: https://paste.helpch.at/" + key);
        });
    }

    @NotNull
    private CompletableFuture<String> postDump(@NotNull String dump) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://paste.helpch.at/documents").openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
                connection.setDoOutput(true);
                connection.connect();
                try (Closeable stream = connection.getOutputStream();){
                    ((OutputStream)stream).write(dump.getBytes(StandardCharsets.UTF_8));
                }
                stream = connection.getInputStream();
                var3_4 = null;
                try {
                    String json = CharStreams.toString((Readable)new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                    String string = ((JsonObject)gson.fromJson(json, JsonObject.class)).get("key").getAsString();
                    return string;
                }
                catch (Throwable throwable) {
                    var3_4 = throwable;
                    throw throwable;
                }
                finally {
                    if (stream != null) {
                        if (var3_4 != null) {
                            try {
                                ((InputStream)stream).close();
                            }
                            catch (Throwable throwable) {
                                var3_4.addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)stream).close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    @NotNull
    private String makeDump(@NotNull PlaceholderAPIPlugin plugin) {
        StringBuilder builder = new StringBuilder();
        builder.append("Generated: ").append(DATE_FORMAT.format(Instant.now())).append("\n\n");
        builder.append("PlaceholderAPI: ").append(plugin.getDescription().getVersion()).append("\n\n");
        builder.append("Expansions Registered:").append('\n');
        List expansions = plugin.getLocalExpansionManager().getExpansions().stream().sorted(Comparator.comparing(PlaceholderExpansion::getIdentifier).thenComparing(PlaceholderExpansion::getAuthor)).collect(Collectors.toList());
        int size = expansions.stream().map(e2 -> e2.getIdentifier().length()).max(Integer::compareTo).orElse(0);
        for (String[] expansion : expansions) {
            builder.append("  ").append(String.format("%-" + size + "s", expansion.getIdentifier())).append(" [Author: ").append(expansion.getAuthor()).append(", Version: ").append(expansion.getVersion()).append("]\n");
        }
        builder.append('\n');
        builder.append("Expansions Directory:").append('\n');
        String[] jars = plugin.getLocalExpansionManager().getExpansionsFolder().list((dir, name) -> name.toLowerCase(Locale.ROOT).endsWith(".jar"));
        if (jars == null) {
            builder.append("  \u00a8[Warning]: Could not load jar files from expansions folder.");
        } else {
            for (String jar : jars) {
                builder.append("  ").append(jar).append('\n');
            }
        }
        builder.append('\n');
        builder.append("Server Info: ").append(plugin.getServer().getBukkitVersion()).append('/').append(plugin.getServer().getVersion()).append("\n");
        builder.append("Java Version: ").append(System.getProperty("java.version")).append("\n\n");
        builder.append("Plugin Info:").append('\n');
        List plugins = Arrays.stream(plugin.getServer().getPluginManager().getPlugins()).sorted(Comparator.comparing(Plugin::getName)).collect(Collectors.toList());
        size = plugins.stream().map(pl -> pl.getName().length()).max(Integer::compareTo).orElse(0);
        for (Plugin other : plugins) {
            builder.append("  ").append(String.format("%-" + size + "s", other.getName())).append(" [Authors: [").append(String.join((CharSequence)", ", other.getDescription().getAuthors())).append("], Version: ").append(other.getDescription().getVersion()).append("]").append("\n");
        }
        return builder.toString();
    }
}

