/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmyStack;
import cn.jason31416.betternations.army.ArmyType;
import cn.jason31416.betternations.army.BreakCampRunnable;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.types.Granary;
import cn.jason31416.planetlib.ColorUtils;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.plugin.Plugin;

public class ArmyCamp
extends StructuredArmy {
    @Override
    public String getHologramText() {
        return Message.getMessage("combat.camp-name").add("nation", this.stack.nation.getColorTag() + this.stack.nation.getName()).add("units", this.stack.size()).toString();
    }

    @Override
    public Material getMaterial() {
        return ColorUtils.getClosest(this.stack.nation.getColor()).stained_glass();
    }

    public static double supplyGain(SimpleChunkLocation loc, Nation nation) {
        if (nation.getRelation(loc.getNation()) == Relation.ALLY && Granary.granaries.containsKey(loc)) {
            double ret = 0.0;
            for (Granary i : Granary.granaries.get(loc)) {
                ret += Math.min(Config.getDouble("combat.supply-regain-speed"), i.supply);
            }
            return ret;
        }
        return 0.0;
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (this.runnable != null) {
            return false;
        }
        if (type == AbstractStructure.InteractionType.INTERACT) {
            final ArmyCamp camp = this;
            new GUISession(player){
                final ArmyStack selected;
                {
                    super(player);
                    this.selected = new ArmyStack(ArmyCamp.this.stack.nation);
                }

                @Override
                public void constructGUI(String guiID, GUI gui) {
                    switch (guiID) {
                        case "camped-army": {
                            ArmyCamp.this.stack.displayGUI(gui, 10, 44);
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            gui.getItems("army-overview").setItemStack(ArmyCamp.this.stack.getItemDisplay(ArmyCamp.supplyGain(ArmyCamp.this.location.getChunkLocation(), ArmyCamp.this.stack.nation)));
                            if (ArmyCamp.this.isInCombat()) {
                                gui.getItems("combat-overview").setClickHandler(new GUI.SwitchGuiRunnable("combat-overview"));
                            } else {
                                gui.getItems("combat-overview").setMaterial(Material.BARRIER);
                            }
                            if (this.player.getNation() == ArmyCamp.this.stack.nation && this.player.hasPermission(Permission.MANAGE_ARMY)) {
                                gui.getItems("action-page").setClickHandler(new GUI.SwitchGuiRunnable("camped-actions"));
                                break;
                            }
                            gui.getItems("action-page").setMaterial(Material.BLACK_WOOL).setName("&c\u6ca1\u6709\u6743\u9650").setLore(List.of());
                            break;
                        }
                        case "combat-overview": {
                            int lcnt = 10;
                            int rcnt = 14;
                            for (StructuredArmy i : StructuredArmy.armyLocationMap.get(ArmyCamp.this.location.getChunkLocation())) {
                                if (i.stack.nation.getRelation(ArmyCamp.this.stack.nation) == Relation.ENEMY) {
                                    gui.addItem("stack-" + rcnt, rcnt, i.getStack().getItemDisplay(ArmyCamp.supplyGain(i.location.getChunkLocation(), i.getStack().nation)));
                                    if (++rcnt % 9 != 8) continue;
                                    rcnt += 6;
                                    continue;
                                }
                                if (i != camp && !i.isInCombat()) continue;
                                gui.addItem("stack-" + lcnt, lcnt, i.getStack().getItemDisplay(ArmyCamp.supplyGain(i.location.getChunkLocation(), i.getStack().nation)));
                                if (++lcnt % 9 != 4) continue;
                                lcnt += 6;
                            }
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                        }
                        case "camped-actions": {
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            if (ArmyCamp.this.isInCombat()) {
                                gui.getItems("extract").setMaterial(Material.BARRIER);
                                gui.getItems("split").setMaterial(Material.BARRIER);
                            }
                            gui.getItems("extract").setClickHandler((session, action, evt) -> {
                                if (ArmyCamp.this.isInCombat()) {
                                    Message.getMessage("combat.cannot-move-unit-during-combat").send(this.player);
                                    session.close();
                                    return;
                                }
                                if (ArmyCamp.this.stack.curHolder == camp) {
                                    TransportArmy.spawn(ArmyCamp.this.location, this.player, ArmyCamp.this.stack);
                                    camp.breakStructure();
                                    camp.unregister();
                                    session.close();
                                }
                            });
                            gui.getItems("split").setClickHandler((session, action, evt) -> {
                                if (ArmyCamp.this.isInCombat()) {
                                    Message.getMessage("combat.cannot-move-unit-during-combat").send(this.player);
                                    session.close();
                                    return;
                                }
                                session.display("camped-split");
                            });
                            break;
                        }
                        case "camped-split": {
                            int pos = 10;
                            for (ArmyType type : ArmyCamp.this.stack.armies.keySet()) {
                                if (pos >= 44) {
                                    return;
                                }
                                int p = pos;
                                gui.addItem("army-" + pos, pos, ArmyCamp.this.stack.armies.get(type).getItemStack()).setQuantity(this.selected.armies.getOrDefault((Object)type, (ArmyStack.Unit)new ArmyStack.Unit((ArmyType)type, (int)1)).count).setLore(MessageLoader.getList("combat.unit.selecting-item-lore").add("health", (double)Math.round(ArmyCamp.this.stack.armies.get((Object)type).hp * 10.0) / 10.0).add("max_health", (double)ArmyCamp.this.stack.armies.get((Object)type).count * type.health).add("count", this.selected.armies.getOrDefault((Object)type, (ArmyStack.Unit)new ArmyStack.Unit((ArmyType)type, (int)0)).count).add("total", ArmyCamp.this.stack.armies.get((Object)type).count).asList()).setClickHandler((session, action, event) -> {
                                    if (!(action != InventoryAction.PICKUP_ALL || this.selected.armies.containsKey(type) && this.selected.armies.get((Object)type).count >= ArmyCamp.this.stack.armies.get((Object)type).count)) {
                                        this.selected.addArmy(type, 1);
                                    } else if (action == InventoryAction.PICKUP_HALF) {
                                        this.selected.removeArmy(type, 1);
                                    } else {
                                        return;
                                    }
                                    gui.getItems("army-overview").setItemStack(this.selected.getItemDisplay());
                                    gui.getItem(p).setLore(MessageLoader.getList("combat.unit.selecting-item-lore").add("health", (double)Math.round(ArmyCamp.this.stack.armies.get((Object)type).hp * 10.0) / 10.0).add("max_health", (double)ArmyCamp.this.stack.armies.get((Object)type).count * type.health).add("count", this.selected.armies.getOrDefault((Object)type, (ArmyStack.Unit)new ArmyStack.Unit((ArmyType)type, (int)0)).count).add("total", ArmyCamp.this.stack.armies.get((Object)type).count).asList()).setQuantity(this.selected.armies.getOrDefault((Object)type, (ArmyStack.Unit)new ArmyStack.Unit((ArmyType)type, (int)1)).count);
                                    gui.update();
                                });
                                if (++pos % 9 != 8) continue;
                                pos += 2;
                            }
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            gui.getItems("army-overview").setItemStack(this.selected.getItemDisplay());
                            gui.getItems("confirm").setClickHandler((session, action, event) -> {
                                if (ArmyCamp.this.isInCombat()) {
                                    Message.getMessage("combat.cannot-move-unit-during-combat").send(this.player);
                                    session.close();
                                    return;
                                }
                                if (this.selected.size() > 0) {
                                    double sup = 0.0;
                                    for (ArmyType tp : this.selected.armies.keySet()) {
                                        if (!ArmyCamp.this.stack.armies.containsKey(tp)) {
                                            this.player.sendMessage(Message.getMessage("combat.invalid-selection"));
                                            return;
                                        }
                                        this.selected.armies.get((Object)tp).hp = ArmyCamp.this.stack.armies.get((Object)tp).hp / (double)ArmyCamp.this.stack.armies.get((Object)tp).count * (double)this.selected.armies.get((Object)tp).count;
                                        ArmyCamp.this.stack.armies.get((Object)tp).hp -= this.selected.armies.get((Object)tp).hp;
                                        sup += ArmyCamp.this.stack.supply / ArmyCamp.this.stack.getMaxSupply() * tp.maxSupply * (double)this.selected.armies.get((Object)tp).count;
                                        if (ArmyCamp.this.stack.removeArmy(tp, this.selected.armies.get((Object)tp).count)) continue;
                                        this.player.sendMessage(Message.getMessage("combat.invalid-selection"));
                                        return;
                                    }
                                    ArmyCamp.this.stack.supply -= sup;
                                    this.selected.supply = sup;
                                    TransportArmy.spawn(ArmyCamp.this.location.getRelative(0.0, 1.0, 0.0), this.player, this.selected);
                                    if (ArmyCamp.this.stack.size() <= 0) {
                                        ArmyCamp.this.unregister();
                                        ArmyCamp.this.breakStructure();
                                    } else {
                                        ArmyCamp.this.hologram.setText(ArmyCamp.this.getHologramText());
                                    }
                                }
                                this.player.getPlayer().closeInventory();
                            });
                            break;
                        }
                    }
                }
            }.display("camped-army");
        } else {
            if (type == AbstractStructure.InteractionType.BREAK) {
                if (this.stack.curHolder == this && player.getNation() == this.stack.nation) {
                    if (!this.isInCombat()) {
                        TransportArmy.spawn(this.location, player, this.stack);
                        this.breakStructure();
                        this.unregister();
                    } else {
                        Message.getMessage("combat.cannot-move-unit-during-combat").send(player);
                    }
                } else if (this.stack.nation.getRelation(player.getNation()) == Relation.ENEMY && this.runnable == null) {
                    if (this.location.getChunkLocation().getNation() == this.stack.nation) {
                        player.sendMessage(Message.getMessage("combat.cannot-break-camps-in-nation"));
                    } else {
                        this.runnable = new BreakCampRunnable(player, this);
                        this.runnable.runTaskTimer((Plugin)BetterNations.instance, 2L, 2L);
                    }
                }
                return false;
            }
            if (type == AbstractStructure.InteractionType.SNEAK_CLICK && TransportArmy.transports.containsKey(player)) {
                new GUISession(player){

                    @Override
                    public void constructGUI(String guiID, GUI gui) {
                        switch (guiID) {
                            case "join-camped": {
                                int pos = 10;
                                for (TransportArmy i : TransportArmy.transports.get(this.player)) {
                                    if (!i.isActive || !(i.getLocation().getBukkitLocation().distance(ArmyCamp.this.location.getBukkitLocation()) < 3.0)) continue;
                                    int p = pos;
                                    gui.addItem("item-" + pos, pos, i.stack.getItemDisplay()).setClickHandler((session, action, event) -> {
                                        if (i.isActive) {
                                            i.mob.remove();
                                            ArmyCamp.this.stack.addArmyStack(i.stack);
                                            i.unregister();
                                            ArmyCamp.this.hologram.setText(ArmyCamp.this.getHologramText());
                                            if (!TransportArmy.transports.containsKey(this.player)) {
                                                this.player.getPlayer().closeInventory();
                                            } else {
                                                session.display("join-camped");
                                            }
                                        }
                                    });
                                    ++pos;
                                }
                                gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            }
                        }
                    }
                }.display("join-camped");
            }
        }
        return true;
    }
}

