/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.InvasionFlag;
import cn.jason31416.betternations.army.states.SiegeFlag;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.wrapper.SimpleChunkLocation;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityPortalEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.PlayerLeashEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.spigotmc.event.entity.EntityMountEvent;

public class ArmyListener
implements Listener {
    @EventHandler
    public void onTransportDeath(EntityDeathEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
            TransportArmy.transportArmyMap.get(event.getEntity()).destroy(false);
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    @EventHandler
    public void onTransportTransform(EntityTransformEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTransportDamaged(EntityDamageEvent event) {
        Mob mob;
        Entity entity;
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity()) && (entity = event.getEntity()) instanceof Mob && (mob = (Mob)entity).getHealth() > event.getFinalDamage()) {
            TransportArmy.transportArmyMap.get((Object)event.getEntity()).stack.damage(event.getFinalDamage());
            TransportArmy.transportArmyMap.get(event.getEntity()).updateName();
            new BukkitRunnable(){

                public void run() {
                    try {
                        mob.setMaxHealth(mob.getHealth());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }.runTaskLater((Plugin)BetterNations.instance, 0L);
        }
    }

    @EventHandler
    public void onTransportHeal(EntityRegainHealthEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTransportLeashed(PlayerLeashEntityEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTransportMount(EntityMountEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity()) && !(event.getMount() instanceof RideableMinecart) && !(event.getMount() instanceof Boat)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTransportTeleportWorld(EntityPortalEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onTransportDamagePlayer(EntityDamageByEntityEvent event) {
        Entity entity;
        if (TransportArmy.transportArmyMap.containsKey(event.getDamager()) && event.getEntity() instanceof Player) {
            event.setCancelled(true);
        }
        if ((entity = event.getDamager()) instanceof Player) {
            Player pl = (Player)entity;
            if (TransportArmy.transportArmyMap.containsKey(event.getEntity())) {
                SimplePlayer player = SimplePlayer.of(pl);
                TransportArmy army = TransportArmy.transportArmyMap.get(event.getEntity());
                if (army.getStack().nation.getRelation(player.getNation()) == Relation.ALLY) {
                    event.setDamage(0.0);
                    event.setCancelled(true);
                    if (army.isActive) {
                        SimpleLocation loc = army.mob.getLocation().getBlockLocation();
                        while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
                            loc = loc.getRelative(0.0, 1.0, 0.0);
                        }
                        if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
                            return;
                        }
                        ArmyCamp c = new ArmyCamp();
                        army.unregister();
                        c.stack = army.stack;
                        c.location = loc;
                        army.stack.curHolder = c;
                        c.place();
                        army.mob.remove();
                    }
                }
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        for (TransportArmy army : TransportArmy.transportArmyMap.values()) {
            if (!army.player.getPlayer().equals(event.getPlayer())) continue;
            army.encamp();
        }
    }

    @EventHandler
    public void onPlayerInteractTransport(PlayerInteractEntityEvent event) {
        if (TransportArmy.transportArmyMap.containsKey(event.getRightClicked())) {
            SimplePlayer player = SimplePlayer.of(event.getPlayer());
            final TransportArmy army = TransportArmy.transportArmyMap.get(event.getRightClicked());
            if (player.getNation() == army.stack.nation && player.hasPermission(Permission.MANAGE_ARMY)) {
                new GUISession(player){

                    @Override
                    public void constructGUI(String guiID, GUI gui) {
                        switch (guiID) {
                            case "transport-army": {
                                army.stack.displayGUI(gui, 10, 44);
                                gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                                gui.getItems("army-overview").setItemStack(army.stack.getItemDisplay());
                                gui.getItems("action-page").setClickHandler(new GUI.SwitchGuiRunnable("transport-actions"));
                            }
                            case "transport-actions": {
                                gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                                gui.getItems("encamp").setClickHandler((session, action, evt) -> army.encamp());
                                boolean flag = true;
                                for (Object i : (Set)StructuredArmy.armyLocationMap.getOrDefault(army.getLocation().getChunkLocation(), new HashSet())) {
                                    if (!(i instanceof InvasionFlag)) continue;
                                    flag = false;
                                    break;
                                }
                                if (Config.getBoolean("allow-war") && flag && army.getLocation().getChunkLocation().isClaimed() && !army.getLocation().getChunkLocation().isTownChunk() && army.stack.nation.getRelation(army.getLocation().getChunkLocation().getNation()) == Relation.ENEMY) {
                                    gui.getItems("invade").setClickHandler((session, action, evt) -> {
                                        if (army2.isActive && army.getLocation().getChunkLocation().isClaimed() && !army.getLocation().getChunkLocation().isTownChunk() && army2.stack.nation.getRelation(army.getLocation().getChunkLocation().getNation()) == Relation.ENEMY) {
                                            SimpleLocation loc = army2.mob.getLocation().getBlockLocation();
                                            while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
                                                loc = loc.getRelative(0.0, 1.0, 0.0);
                                            }
                                            if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
                                                loc = loc.getRelative(0.0, -1.0, 0.0);
                                            }
                                            InvasionFlag c = new InvasionFlag();
                                            army.unregister();
                                            c.stack = army2.stack;
                                            c.location = loc;
                                            army2.stack.curHolder = c;
                                            c.place();
                                            army2.mob.remove();
                                            this.player.getPlayer().closeInventory();
                                            Message.getMessage("combat.invasion-started").add("nation", army2.stack.nation.getName()).add("location", loc.x() + "," + loc.y() + "," + loc.z()).send(army.getLocation().getChunkLocation().getNation().getMembers());
                                        }
                                    });
                                } else {
                                    gui.getItems("invade").setMaterial(Material.AIR);
                                }
                                Town adjTown = null;
                                if (army.getLocation().getChunkLocation().isClaimed() && army.getLocation().getChunkLocation().getNation() == army.stack.nation) {
                                    for (SimpleChunkLocation simpleChunkLocation : army.getLocation().getChunkLocation().getAdjacentChunks()) {
                                        if (!simpleChunkLocation.isTownChunk() || army.stack.nation.getRelation(simpleChunkLocation.getNation()) != Relation.ENEMY) continue;
                                        adjTown = simpleChunkLocation.getTown();
                                        break;
                                    }
                                }
                                if (adjTown != null) {
                                    for (StructuredArmy structuredArmy : (Set)StructuredArmy.armyLocationMap.getOrDefault(army.getLocation().getChunkLocation(), new HashSet())) {
                                        if (!(structuredArmy instanceof SiegeFlag)) continue;
                                        adjTown = null;
                                    }
                                }
                                if (Config.getBoolean("allow-war") && adjTown != null) {
                                    Town t = adjTown;
                                    gui.getItems("siege").placeholder("town", adjTown.getName()).setClickHandler((session, action, evt) -> {
                                        if (army2.isActive && army2.stack.nation.getRelation(t.getNation()) == Relation.ENEMY) {
                                            SimpleLocation loc = army2.mob.getLocation().getBlockLocation();
                                            while (loc.y() < (double)loc.world().getBukkitWorld().getMaxHeight() && loc.getBlockMaterial() != Material.AIR) {
                                                loc = loc.getRelative(0.0, 1.0, 0.0);
                                            }
                                            if (loc.y() >= (double)loc.world().getBukkitWorld().getMaxHeight()) {
                                                return;
                                            }
                                            SiegeFlag c = new SiegeFlag(t);
                                            army.unregister();
                                            c.stack = army2.stack;
                                            c.location = loc;
                                            army2.stack.curHolder = c;
                                            c.place();
                                            army2.mob.remove();
                                            this.player.getPlayer().closeInventory();
                                        }
                                    });
                                    break;
                                }
                                gui.getItems("siege").setMaterial(Material.AIR);
                            }
                        }
                    }
                }.display("transport-army");
            }
        }
    }
}

