/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.army.states;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.army.ArmorType;
import cn.jason31416.betternations.army.BreakCampRunnable;
import cn.jason31416.betternations.army.states.ArmyCamp;
import cn.jason31416.betternations.army.states.StructuredArmy;
import cn.jason31416.betternations.army.states.TransportArmy;
import cn.jason31416.betternations.manager.ArmyUpdateManager;
import cn.jason31416.betternations.nation.Nation;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Relation;
import cn.jason31416.betternations.structure.AbstractStructure;
import cn.jason31416.betternations.structure.Hologram;
import cn.jason31416.planetlib.ColorUtils;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.Utils;
import cn.jason31416.planetlib.data.IDataItem;
import cn.jason31416.planetlib.gui.GUI;
import cn.jason31416.planetlib.gui.GUISession;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import cn.jason31416.planetlib.wrapper.SimplePlayer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class InvasionFlag
extends StructuredArmy {
    @Override
    public String getHologramText() {
        return Message.getMessage("combat.invasion-name").add("nation", this.stack.nation.getColorTag() + this.stack.nation.getName()).add("units", this.stack.size()).toString();
    }

    @Override
    public void place() {
        this.location.setBlockMaterial(this.getMaterial());
        this.hologram = Hologram.createHologram(SimpleLocation.of(this.location.getBlock().getLocation().add(0.5, 2.3, 0.5)), this.getHologramText());
        this.register();
    }

    @Override
    public boolean serialize(IDataItem dataItem) {
        dataItem.set("chunkhp", ArmyUpdateManager.chunkHealths.getOrDefault(this.location.getChunkLocation(), Config.getDouble("combat.chunk-hp", 10.0)));
        return super.serialize(dataItem);
    }

    @Override
    public void deserialize(IDataItem dataItem) {
        super.deserialize(dataItem);
        ArmyUpdateManager.chunkHealths.put(this.location.getChunkLocation(), dataItem.getDouble("chunkhp"));
    }

    @Override
    public Material getMaterial() {
        return ColorUtils.getClosest(this.stack.nation.getColor()).banner();
    }

    @Override
    public boolean processInteraction(AbstractStructure.InteractionType type, SimplePlayer player) {
        if (type == AbstractStructure.InteractionType.INTERACT) {
            final InvasionFlag invasion = this;
            new GUISession(player){

                @Override
                public void constructGUI(final String guiID, final GUI gui) {
                    switch (guiID) {
                        case "invasion-main": {
                            InvasionFlag.this.stack.displayGUI(gui, 28, 44);
                            gui.getItems("army-overview").setItemStack(InvasionFlag.this.stack.getItemDisplay(ArmyCamp.supplyGain(InvasionFlag.this.location.getChunkLocation(), InvasionFlag.this.stack.nation)));
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            if (this.player.getNation() == InvasionFlag.this.stack.nation && this.player.hasPermission(Permission.MANAGE_ARMY)) {
                                gui.getItems("action-page").setClickHandler(new GUI.SwitchGuiRunnable("invasion-actions"));
                            } else {
                                gui.getItems("action-page").setMaterial(Material.BARRIER);
                            }
                            double mxhp = Config.getDouble("combat.chunk-hp", 20.0);
                            double chunkhp = ArmyUpdateManager.chunkHealths.getOrDefault(invasion.location.getChunkLocation(), mxhp);
                            if (chunkhp > mxhp) {
                                return;
                            }
                            int cnt = (int)((mxhp - chunkhp) * 5.0 / mxhp);
                            for (int i = 0; i < 7; ++i) {
                                int pos = i + 10;
                                if (i < cnt) {
                                    gui.addItem("prog-" + i, " ", pos, Material.RED_STAINED_GLASS_PANE, 1);
                                    continue;
                                }
                                if (i == cnt) {
                                    gui.addItem("prog-" + i, Message.getMessage("combat.progress.invasion.attack.name").add("attacker", InvasionFlag.this.stack.nation.getColorTag() + InvasionFlag.this.stack.nation.getName()).toString(), pos, Material.IRON_SWORD, 1).setLore(MessageLoader.getList("combat.progress.invasion.attack.lore").add("next_attack", Utils.formatSeconds((int)((ArmyUpdateManager.nextUpdate - System.currentTimeMillis()) / 1000L))).add("health", (double)Math.round(InvasionFlag.this.stack.getHealth() * 10.0) / 10.0).add("damage", InvasionFlag.this.stack.getDamageTowards(ArmorType.TERRITORY)).asList());
                                    continue;
                                }
                                if (i == cnt + 1) {
                                    Nation nation = InvasionFlag.this.location.getChunkLocation().getNation();
                                    if (nation == null) continue;
                                    gui.addItem("prog-" + i, Message.getMessage("combat.progress.invasion.defend.name").add("chunk", InvasionFlag.this.location.world().getName() + "," + InvasionFlag.this.location.getChunkLocation().x() + "," + InvasionFlag.this.location.getChunkLocation().z()).add("defender", nation.getColorTag() + nation.getName()).toString(), pos, ColorUtils.getClosest(nation.getColor()).banner(), 1).setLore(MessageLoader.getList("combat.progress.invasion.defend.lore").add("health", chunkhp).asList());
                                    continue;
                                }
                                gui.addItem("prog-" + i, " ", pos, Material.BLUE_STAINED_GLASS_PANE, 1);
                            }
                            new BukkitRunnable(){

                                public void run() {
                                    if (!GUISession.sessions.containsKey(player) || GUISession.sessions.get((Object)player).gui != gui) {
                                        return;
                                    }
                                    if (!invasion.running) {
                                        player.getPlayer().closeInventory();
                                        return;
                                    }
                                    int pos = 28;
                                    while (pos < 44) {
                                        gui.container.remove(pos);
                                        if (++pos % 9 != 8) continue;
                                        pos += 2;
                                    }
                                    this.constructGUI(guiID, gui);
                                    gui.update();
                                }
                            }.runTaskLater((Plugin)BetterNations.instance, 4L);
                        }
                        case "invasion-actions": {
                            gui.getItems("close").setClickHandler(new GUI.CloseGuiRunnable());
                            if (InvasionFlag.this.isInCombat()) {
                                gui.getItems("extract").setMaterial(Material.BARRIER);
                            }
                            gui.getItems("extract").setClickHandler((session, action, evt) -> {
                                if (InvasionFlag.this.isInCombat()) {
                                    Message.getMessage("combat.cannot-move-unit-during-combat").send(this.player);
                                    session.close();
                                    return;
                                }
                                if (InvasionFlag.this.stack.curHolder == invasion) {
                                    TransportArmy.spawn(InvasionFlag.this.location, this.player, InvasionFlag.this.stack);
                                    invasion.breakStructure();
                                    invasion.unregister();
                                    session.close();
                                }
                            });
                        }
                    }
                }
            }.display("invasion-main");
        } else if (type == AbstractStructure.InteractionType.BREAK) {
            if (this.stack.nation.getRelation(player.getNation()) == Relation.ENEMY && this.runnable == null) {
                this.runnable = new BreakCampRunnable(player, this);
                this.runnable.runTaskTimer((Plugin)BetterNations.instance, 2L, 2L);
            }
            return false;
        }
        return true;
    }

    public void convertToCamp() {
        if (Bukkit.isPrimaryThread()) {
            ArmyCamp camp = new ArmyCamp();
            camp.stack = this.stack;
            camp.location = this.location;
            this.breakStructure();
            this.unregister();
            camp.place();
        } else {
            Bukkit.getScheduler().runTask((Plugin)BetterNations.instance, this::convertToCamp);
        }
    }
}

