/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.chat;

import cn.jason31416.betternations.nation.Town;
import cn.jason31416.betternations.nation.TownRole;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.command.ParameterType;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.MessageLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ChatCommand
extends ChildCommand {
    public static final ChatInfo CTGlobal = new ChatInfo(ChatType.GLOBAL);
    public static final ChatInfo CTNation = new ChatInfo(ChatType.NATION);
    public static final Map<String, ChatInfo> CTTownMap = new HashMap<String, ChatInfo>();
    public static Map<String, ChatInfo> playerChatMap = new HashMap<String, ChatInfo>();

    public ChatCommand(IParentCommand parent) {
        super("chat", parent);
    }

    @Override
    @Nullable
    public Message execute(ICommandContext context) {
        if (!context.checkArgs(ParameterType.STRING)) {
            return null;
        }
        switch (context.getArg(0)) {
            case "town": {
                if (!context.checkArgs(ParameterType.STRING, ParameterType.STRING)) {
                    return null;
                }
                Town t = Town.getTown(context.getArg(1));
                if (t == null) {
                    return Message.getMessage("command.failed.town-not-exist");
                }
                if (t.getRole(context.player()) == TownRole.NONE) {
                    return Message.getMessage("command.failed.no-permission");
                }
                if (!CTTownMap.containsKey(context.getArg(1))) {
                    CTTownMap.put(context.getArg(1), new ChatInfo(Town.getTown(context.getArg(1))));
                }
                playerChatMap.put(context.player().getName(), CTTownMap.get(context.getArg(1)));
                return MessageLoader.getMessage("command.success.chat-changed").add("chat_type", Message.getMessage("chat.town").add("town", context.getArg(1)));
            }
            case "nation": {
                playerChatMap.put(context.player().getName(), CTNation);
                return MessageLoader.getMessage("command.success.chat-changed").add("chat_type", Message.getMessage("chat.nation"));
            }
            case "global": {
                playerChatMap.put(context.player().getName(), CTGlobal);
                return MessageLoader.getMessage("command.success.chat-changed").add("chat_type", Message.getMessage("chat.global"));
            }
        }
        return Message.getMessage("command.failed.invalid-chat-type");
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (context.getArg(0).equals("town")) {
            return Town.towns.values().stream().map(Town::getName).toList();
        }
        return List.of("nation", "town", "global");
    }

    public static class ChatInfo {
        public ChatType type;
        public Town town;

        public ChatInfo(ChatType t) {
            this.type = t;
            this.town = null;
        }

        public ChatInfo(Town t) {
            this.town = t;
            this.type = ChatType.TOWN;
        }

        public int hashCode() {
            if (this.type == ChatType.GLOBAL) {
                return 0;
            }
            if (this.type == ChatType.NATION) {
                return -1;
            }
            return this.town.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ChatInfo)) {
                return false;
            }
            ChatInfo i = (ChatInfo)other;
            if (i.type == this.type && this.type == ChatType.GLOBAL || i.type == this.type && this.type == ChatType.NATION) {
                return true;
            }
            if (this.town == null && i.town == null) {
                return true;
            }
            if (this.town == null || i.town == null) {
                return false;
            }
            return this.town.equals(i.town);
        }
    }

    public static enum ChatType {
        GLOBAL,
        NATION,
        TOWN;

    }
}

