/*
 * Decompiled with CFR 0.152.
 */
package cn.jason31416.betternations.command.town;

import cn.jason31416.betternations.BetterNations;
import cn.jason31416.betternations.nation.Permission;
import cn.jason31416.betternations.nation.Town;
import cn.jason31416.planetlib.Config;
import cn.jason31416.planetlib.command.ChildCommand;
import cn.jason31416.planetlib.command.ICommandContext;
import cn.jason31416.planetlib.command.IParentCommand;
import cn.jason31416.planetlib.command.ParameterType;
import cn.jason31416.planetlib.message.Message;
import cn.jason31416.planetlib.message.StringMessage;
import cn.jason31416.planetlib.wrapper.SimpleLocation;
import java.util.List;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;

public class TownTeleportCommand
extends ChildCommand {
    public TownTeleportCommand(IParentCommand parent) {
        super("tp", parent);
    }

    @Override
    @Nullable
    public Message execute(final ICommandContext context) {
        if (context.getPlayer() == null || !context.getSender().isPlayer() || !context.checkArgs(ParameterType.STRING)) {
            return null;
        }
        final Town to = Town.getTown(context.getArg(0));
        if (to == null) {
            return Message.getMessage("command.failed.town-not-exist");
        }
        if (!to.getRole(context.getPlayer()).hasPermission(Permission.BUILD)) {
            return Message.getMessage("command.failed.no-permission");
        }
        new BukkitRunnable(){
            int countdown = Config.getInt("town.teleport-countdown", 3);
            final SimpleLocation loc = context.getPlayer().getLocation();

            public void run() {
                if (!context.getPlayer().getLocation().equals(this.loc)) {
                    Message.getMessage("town.teleport-canceled").send(context.getSender());
                    new StringMessage("").sendActionbar(context.getSender().toPlayer());
                    this.cancel();
                }
                Message.getMessage("town.teleport-countdown").add("timer", this.countdown).sendActionbar(context.getSender().toPlayer());
                if (this.countdown <= 0) {
                    if (context.getSender().toPlayer().getPlayer() != null) {
                        context.getSender().toPlayer().getPlayer().teleport(to.core.location.getRelative(0.0, 1.0, 0.0).getBukkitLocation());
                        Message.getMessage("town.teleport-success").sendActionbar(context.getSender().toPlayer());
                    }
                    this.cancel();
                }
                --this.countdown;
            }
        }.runTaskTimer((Plugin)BetterNations.instance, 0L, 20L);
        return null;
    }

    @Override
    public List<String> tabComplete(ICommandContext context) {
        if (context.getPlayer().getNation() != null) {
            return context.getPlayer().getNation().getTowns().stream().map(Town::getName).toList();
        }
        return null;
    }
}

